/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.nacos.impl;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.nacos.DynamicConfigPublisher;
import org.apache.ozhera.log.model.MiLogStreamConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamConfigNacosPublisher
implements DynamicConfigPublisher<MiLogStreamConfig> {
    private static final Logger log = LoggerFactory.getLogger(StreamConfigNacosPublisher.class);
    private ConfigService configService;

    @Override
    public synchronized void publish(Long spaceId, MiLogStreamConfig config) {
        if (config == null) {
            return;
        }
        try {
            this.configService.publishConfig(CommonExtensionServiceFactory.getCommonExtensionService().getSpaceDataId(spaceId), "DEFAULT_GROUP", gson.toJson((Object)config));
        }
        catch (NacosException e) {
            log.error(String.format("Create namespace push data exceptions, parameters\uff1a%s", gson.toJson((Object)config)), (Throwable)e);
        }
    }

    @Override
    public void remove(String dataId) {
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }
}

