/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.rpc.common;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceThread
implements Runnable {
    private static final Logger stlog = LoggerFactory.getLogger(ServiceThread.class);
    private static final long JoinTime = 90000L;
    protected final Thread thread = new Thread((Runnable)this, this.getServiceName());
    protected volatile boolean hasNotified = false;
    protected volatile boolean stoped = false;

    public abstract String getServiceName();

    public void start() {
        this.thread.start();
    }

    public void shutdown() {
        this.shutdown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean interrupt) {
        this.stoped = true;
        stlog.info("shutdown thread " + this.getServiceName() + " interrupt " + interrupt);
        ServiceThread serviceThread = this;
        synchronized (serviceThread) {
            if (!this.hasNotified) {
                this.hasNotified = true;
                this.notify();
            }
        }
        try {
            if (interrupt) {
                this.thread.interrupt();
            }
            long beginTime = System.currentTimeMillis();
            if (!this.thread.isDaemon()) {
                this.thread.join(this.getJointime());
            }
            long eclipseTime = System.currentTimeMillis() - beginTime;
            stlog.info("join thread " + this.getServiceName() + " eclipse time(ms) " + eclipseTime + " " + this.getJointime());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public long getJointime() {
        return 90000L;
    }

    public void stop() {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean interrupt) {
        this.stoped = true;
        stlog.info("stop thread " + this.getServiceName() + " interrupt " + interrupt);
        ServiceThread serviceThread = this;
        synchronized (serviceThread) {
            if (!this.hasNotified) {
                this.hasNotified = true;
                this.notify();
            }
        }
        if (interrupt) {
            this.thread.interrupt();
        }
    }

    public void makeStop() {
        this.stoped = true;
        stlog.info("makestop thread " + this.getServiceName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        ServiceThread serviceThread = this;
        synchronized (serviceThread) {
            if (!this.hasNotified) {
                this.hasNotified = true;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForRunning(long interval) {
        ServiceThread serviceThread = this;
        synchronized (serviceThread) {
            if (this.hasNotified) {
                this.hasNotified = false;
                this.onWaitEnd();
                return;
            }
            try {
                this.wait(interval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.hasNotified = false;
                this.onWaitEnd();
            }
        }
    }

    protected void onWaitEnd() {
    }

    public boolean isStoped() {
        return this.stoped;
    }
}

