/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.consumer;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.trace.etl.api.service.DataSourceService;
import org.apache.ozhera.trace.etl.api.service.IMetricsParseService;
import org.apache.ozhera.trace.etl.config.TraceConfig;
import org.apache.ozhera.trace.etl.consumer.MutiMetricsCall;
import org.apache.ozhera.trace.etl.domain.DriverDomain;
import org.apache.ozhera.trace.etl.domain.ErrorTraceMessage;
import org.apache.ozhera.trace.etl.domain.HeraTraceEtlConfig;
import org.apache.ozhera.trace.etl.domain.JaegerTracerDomain;
import org.apache.ozhera.trace.etl.domain.MetricsParseResult;
import org.apache.ozhera.trace.etl.service.HeraContextService;
import org.apache.ozhera.trace.etl.util.ThriftUtil;
import org.apache.ozhera.tspandata.TAttributeKey;
import org.apache.ozhera.tspandata.TAttributeType;
import org.apache.ozhera.tspandata.TAttributes;
import org.apache.ozhera.tspandata.TResource;
import org.apache.ozhera.tspandata.TSpanData;
import org.apache.ozhera.tspandata.TValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MetricsParseService
implements IMetricsParseService {
    private static final Logger log = LoggerFactory.getLogger(MetricsParseService.class);
    @NacosValue(value="${query.excludeMethod}", autoRefreshed=true)
    private String excludeMethod;
    @NacosValue(value="${query.exclude.httpServer}", autoRefreshed=true)
    private String excludeHttpServer;
    @NacosValue(value="${query.excludeThread}", autoRefreshed=true)
    private String excludeThread;
    @NacosValue(value="${query.excludeDB}", autoRefreshed=true)
    private String excludeDB;
    @NacosValue(value="${query.excludeHttpurl}", autoRefreshed=true)
    private String excludeHttpurl;
    @NacosValue(value="${query.excludeUA}", autoRefreshed=true)
    private String excludeUA;
    @NacosValue(value="${query.env}", autoRefreshed=true)
    private String env;
    @NacosValue(value="${query.dispatcher.excludeServiceName}", autoRefreshed=true)
    private String excludeServiceName;
    @NacosValue(value="${query.slowtime.http}", autoRefreshed=true)
    private int httpSlowTime;
    @NacosValue(value="${query.slowtime.dubbo}", autoRefreshed=true)
    private int dubboSlowTime;
    @NacosValue(value="${query.slowtime.mysql}", autoRefreshed=true)
    private int mysqlSlowTime;
    @NacosValue(value="${query.exclude.sql}", autoRefreshed=true)
    private boolean excludeSql;
    private static final String DEFAULT_SQL_LABEL = "default select";
    @NacosValue(value="${query.exclude.server.ip}", autoRefreshed=true)
    private boolean excludeServerIp;
    private static final String DEFAULT_SERVER_IP = "10.0.0.0";
    @NacosValue(value="${query.exclude.dubbo.method}", autoRefreshed=true)
    private boolean excludeDubboMethod;
    private static final String DEFAULT_DUBBO_METHOD = "default";
    @Value(value="${es.domain}")
    private String esDomain;
    @Autowired
    private DataSourceService esService;
    @Autowired
    private TraceConfig traceConfig;
    @Autowired
    private HeraContextService heraContextService;
    @Autowired
    private MutiMetricsCall mutiMetrics;
    private static final double[] redisBuckets = new double[]{0.1, 0.5, 1.0, 10.0, 100.0, 500.0, 1000.0};
    private static final double[] aopDubboBuckets = new double[]{50.0, 100.0, 150.0, 200.0, 250.0, 300.0, 400.0, 500.0, 700.0, 1000.0, 2000.0, 3000.0, 5000.0};
    private static final double[] sqlBuckets = new double[]{10.0, 50.0, 100.0, 500.0, 1000.0};
    private static final String DB_DRIVER = "dbDriver";

    @PostConstruct
    public void init() {
        this.mutiMetrics.init(this.env, "");
    }

    public void parse(TSpanData tSpanData) {
        try {
            String serviceName = tSpanData.getExtra().getServiceName();
            if (StringUtils.isEmpty((CharSequence)serviceName)) {
                log.error("serviceName is empty : " + String.valueOf(tSpanData));
                return;
            }
            this.traceStatistics(serviceName);
            MetricsParseResult metricsParseResult = this.metricsParse(tSpanData);
            if (metricsParseResult.isIgnore()) {
                return;
            }
            if (metricsParseResult.isValidate()) {
                this.computeMetrics(metricsParseResult.getJaegerTracerDomain(), metricsParseResult.getHeraTraceEtlConfig());
            }
            if (metricsParseResult.getDriverDomain() != null) {
                this.esService.insertDriver(metricsParseResult.getDriverDomain());
            }
        }
        catch (Exception e) {
            log.error("exporte metrics error serviceName: " + tSpanData.getExtra().getServiceName() + " traceId: " + tSpanData.getTraceId(), (Throwable)e);
        }
    }

    private void traceStatistics(String applicationName) {
        this.mutiMetrics.newCounter("trace_statistics_span_count", "application").with(new String[]{applicationName}).add(1.0, new String[]{applicationName});
    }

    public MetricsParseResult metricsParse(TSpanData tSpanData) {
        TResource resource;
        String serviceName = tSpanData.getExtra().getServiceName();
        if (StringUtils.isEmpty((CharSequence)serviceName) || this.exclude(this.excludeServiceName, serviceName)) {
            return new MetricsParseResult(true);
        }
        HeraTraceEtlConfig config = this.defaultConfig(this.traceConfig.getConfig(serviceName));
        String operationName = tSpanData.getName();
        if (StringUtils.isEmpty((CharSequence)operationName) || this.exclude(config == null ? this.excludeMethod : config.getExcludeMethod(), operationName)) {
            return new MetricsParseResult(true);
        }
        DriverDomain driverDomain = null;
        if (operationName.equals(DB_DRIVER)) {
            driverDomain = new DriverDomain();
            driverDomain.setTimeStamp(String.valueOf(System.currentTimeMillis()));
            driverDomain.setAppName(this.formatServiceName(serviceName));
        }
        JaegerTracerDomain jtd = new JaegerTracerDomain();
        jtd.setServiceName(serviceName);
        jtd.setTraceId(tSpanData.getTraceId());
        long startTime = tSpanData.getStartEpochNanos();
        if (startTime > 0L) {
            jtd.setStartTime(startTime / 1000000L);
        }
        long duration = tSpanData.getEndEpochNanos() - startTime;
        long durationUs = duration / 1000L;
        if (duration > 0L) {
            jtd.setDuration(durationUs);
        }
        jtd.setEndTime(jtd.getStartTime() + durationUs / 1000L);
        jtd.setMethod(operationName);
        if (this.excludeServerIp) {
            jtd.setServerIp(DEFAULT_SERVER_IP);
        } else {
            jtd.setServerIp(tSpanData.getExtra().getIp());
        }
        TAttributes attributes = tSpanData.getAttributes();
        List tagsKeys = attributes.getKeys();
        List tagsValues = attributes.getValues();
        boolean isValidate = true;
        if (tagsKeys != null && tagsValues != null && tagsKeys.size() > 0 && tagsKeys.size() == tagsValues.size()) {
            for (int i = 0; i < tagsKeys.size(); ++i) {
                String key = ((TAttributeKey)tagsKeys.get(i)).getValue();
                String value = ThriftUtil.getStringValue((TValue)((TValue)tagsValues.get(i)), (TAttributeType)((TAttributeKey)tagsKeys.get(i)).getType());
                if ("thread.name".equals(key) && this.exclude(config == null ? this.excludeThread : config.getExcludeThread(), value)) {
                    isValidate = false;
                    break;
                }
                if ("http.url".equals(key) && this.exclude(config == null ? this.excludeHttpurl : config.getExcludeHttpUrl(), value)) {
                    isValidate = false;
                    break;
                }
                if ("http.user_agent".equals(key) && this.exclude(config == null ? this.excludeUA : config.getExcludeUa(), value)) {
                    isValidate = false;
                    break;
                }
                if ("db.statement".equals(key) && this.exclude(config == null ? this.excludeDB : config.getExcludeSql(), value)) {
                    isValidate = false;
                    break;
                }
                if ("http.status_code".equals(key)) {
                    jtd.setHttpCode(value);
                }
                if ("rpc.system".equals(key)) {
                    jtd.setType(value);
                }
                if ("rpc.method".equals(key)) {
                    if (this.excludeDubboMethod) {
                        jtd.setMethod(DEFAULT_DUBBO_METHOD);
                    } else {
                        jtd.setMethod(value);
                    }
                }
                if ("rpc.service".equals(key)) {
                    jtd.setRpcServiceName(value);
                }
                if ("span.kind".equals(key)) {
                    jtd.setKind(value);
                }
                if ("db.system".equals(key)) {
                    jtd.setType(value);
                }
                if ("db.statement".equals(key)) {
                    jtd.setStatement(value);
                }
                if ("http.method".equals(key)) {
                    jtd.setType("aop");
                }
                if ("net.peer.name".equals(key) || "net.peer.ip".equals(key)) {
                    jtd.setDbHost(value);
                }
                if ("net.peer.port".equals(key)) {
                    jtd.setDbPort(value);
                }
                if ("error".equals(key) && Boolean.valueOf(value).booleanValue()) {
                    jtd.setSuccess(false);
                }
                if ("db.connection_string".equals(key)) {
                    jtd.setDataSource(value);
                }
                if ("db.operation".equals(key)) {
                    jtd.setSqlMethod(value);
                }
                if ("db.name".equals(key)) {
                    jtd.setDbName(value);
                }
                if ("messaging.system".equals(key)) {
                    jtd.setType(value);
                }
                if ("messaging.destination".equals(key)) {
                    jtd.setTopic(value);
                }
                if ("hera.annotations".equals(key) && Boolean.valueOf(value).booleanValue()) {
                    jtd.setType("customizeMethod");
                }
                if (driverDomain != null && "db.driver.domainPort".equals(key)) {
                    driverDomain.setDomainPort(value);
                }
                if (driverDomain != null && "db.driver.userName".equals(key)) {
                    driverDomain.setUserName(value);
                }
                if (driverDomain != null && "db.driver.password".equals(key)) {
                    driverDomain.setPassword(value);
                }
                if (driverDomain != null && "db.driver.type".equals(key)) {
                    driverDomain.setType(value);
                }
                if (driverDomain == null || !"db.driver.dbName".equals(key)) continue;
                driverDomain.setDataBaseName(value);
            }
        }
        if ((resource = tSpanData.getResouce()) != null) {
            TAttributes resourceAttributes = resource.getAttributes();
            List resourceKeys = resourceAttributes.getKeys();
            List resourceValues = resourceAttributes.getValues();
            if (resourceKeys != null && resourceValues != null && resourceKeys.size() > 0) {
                for (int i = 0; i < resourceKeys.size(); ++i) {
                    String key = ((TAttributeKey)resourceKeys.get(i)).getValue();
                    String value = ThriftUtil.getStringValue((TValue)((TValue)resourceValues.get(i)), (TAttributeType)((TAttributeKey)resourceKeys.get(i)).getType());
                    if ("service.env".equals(key)) {
                        jtd.setServiceEnv(value);
                    }
                    if ("service.function.module".equals(key)) {
                        jtd.setFunctionModule(value);
                    }
                    if ("service.function.name".equals(key)) {
                        jtd.setFunctionName(value);
                    }
                    if ("service.function.id".equals(key)) {
                        jtd.setFunctionId(value);
                    }
                    if (!"service.env.id".equals(key)) continue;
                    jtd.setServiceEnvId(value);
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)jtd.getServiceEnv())) {
            jtd.setServiceEnv("default_env");
        }
        return new MetricsParseResult(jtd, driverDomain, false, isValidate, config);
    }

    private void computeMetrics(JaegerTracerDomain jtc, HeraTraceEtlConfig config) {
        String metricsName;
        String mysqlMetricsName;
        String dubboMetricsName;
        if (StringUtils.isEmpty((CharSequence)jtc.getType())) {
            return;
        }
        if ("redis".equals(jtc.getType())) {
            this.redisBuild(jtc.getStatement(), jtc);
        }
        if ("mysql".equals(jtc.getType()) || "mongodb".equals(jtc.getType())) {
            if (this.excludeSql) {
                jtc.setSql(DEFAULT_SQL_LABEL);
            } else {
                jtc.setSql(jtc.getStatement());
            }
        }
        String serviceName = jtc.getServiceName();
        String metricsServiceName = this.formatServiceName(serviceName);
        jtc.setMetricsServiceName(metricsServiceName);
        if ("aop".equals(jtc.getType())) {
            String httpMetricsName = "hera_";
            if ("server".equals(jtc.getKind())) {
                if (this.exclude(config == null ? this.excludeHttpServer : config.getExcludeHttpserverMethod(), jtc.getMethod())) {
                    return;
                }
                this.mutiMetrics.newCounter(httpMetricsName + jtc.getType() + "TotalMethodCount", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                if (jtc.isSuccess()) {
                    this.mutiMetrics.newCounter(httpMetricsName + jtc.getType() + "SuccessMethodCount", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    double d = jtc.getDuration();
                    int n = config == null ? this.httpSlowTime : config.getHttpSlowThreshold();
                    if (d > (double)n) {
                        this.mutiMetrics.newCounter(httpMetricsName + "httpSlowQuery", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                        this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "http", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "timeout", jtc.getHttpCode(), jtc.getServiceEnv()));
                    }
                } else {
                    this.mutiMetrics.newCounter(httpMetricsName + "httpError", "methodName", "application", "serverIp", "errorCode", "serverEnv", "serverEnvId").with(new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getHttpCode(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getHttpCode(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "http", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "error", jtc.getHttpCode(), jtc.getServiceEnv()));
                }
                this.mutiMetrics.newHistogram(httpMetricsName + jtc.getType() + "MethodTimeCount", aopDubboBuckets, "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                this.mutiMetrics.newHistogram(httpMetricsName + jtc.getType() + "MethodTimeCount_without_methodName", aopDubboBuckets, "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
            } else if ("client".equals(jtc.getKind())) {
                this.mutiMetrics.newCounter(httpMetricsName + jtc.getType() + "ClientTotalMethodCount", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                if (jtc.isSuccess()) {
                    this.mutiMetrics.newCounter(httpMetricsName + jtc.getType() + "ClientSuccessMethodCount", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    double d = jtc.getDuration();
                    int n = config == null ? this.httpSlowTime : config.getHttpSlowThreshold();
                    if (d > (double)n) {
                        this.mutiMetrics.newCounter(httpMetricsName + "httpClientSlowQuery", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                        this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "http_client", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "timeout", jtc.getHttpCode(), jtc.getServiceEnv()));
                    }
                } else {
                    this.mutiMetrics.newCounter(httpMetricsName + "httpClientError", "methodName", "application", "serverIp", "errorCode", "serverEnv", "serverEnvId").with(new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getHttpCode(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getHttpCode(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "http_client", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "error", jtc.getHttpCode(), jtc.getServiceEnv()));
                }
                this.mutiMetrics.newHistogram(httpMetricsName + jtc.getType() + "ClientMethodTimeCount", aopDubboBuckets, "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                this.mutiMetrics.newHistogram(httpMetricsName + jtc.getType() + "ClientMethodTimeCount_without_methodName", aopDubboBuckets, "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
            }
        }
        if ("dubbo".equals(jtc.getType())) {
            dubboMetricsName = "hera_";
            if ("client".equals(jtc.getKind())) {
                this.mutiMetrics.newHistogram(dubboMetricsName + "dubboConsumerTimeCost", aopDubboBuckets, "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                this.mutiMetrics.newHistogram(dubboMetricsName + "dubboConsumerTimeCost_without_methodName", aopDubboBuckets, "serviceName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{jtc.getRpcServiceName(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                this.mutiMetrics.newCounter(dubboMetricsName + "dubboBisTotalCount", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                if (jtc.isSuccess()) {
                    this.mutiMetrics.newCounter(dubboMetricsName + "dubboBisSuccessCount", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    double d = jtc.getDuration();
                    int n = config == null ? this.dubboSlowTime : config.getDubboSlowThreshold();
                    if (d > (double)n) {
                        this.mutiMetrics.newCounter(dubboMetricsName + "dubboConsumerSlowQuery", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                        this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getRpcServiceName() + "/" + jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "dubbo_consumer", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "timeout", jtc.getHttpCode(), jtc.getServiceEnv()));
                    }
                } else {
                    this.mutiMetrics.newCounter(dubboMetricsName + "dubboConsumerError", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getRpcServiceName() + "/" + jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "dubbo_consumer", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "error", jtc.getHttpCode(), jtc.getServiceEnv()));
                }
            } else if ("server".equals(jtc.getKind())) {
                this.mutiMetrics.newCounter(dubboMetricsName + "dubboMethodCalledCount", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                this.mutiMetrics.newHistogram(dubboMetricsName + "dubboProviderCount", aopDubboBuckets, "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                this.mutiMetrics.newHistogram(dubboMetricsName + "dubboProviderCount_without_methodName", aopDubboBuckets, "serviceName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{jtc.getRpcServiceName(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                if (jtc.isSuccess()) {
                    this.mutiMetrics.newCounter(dubboMetricsName + "dubboMethodCalledSuccessCount", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    double d = jtc.getDuration();
                    int n = config == null ? this.dubboSlowTime : config.getDubboSlowThreshold();
                    if (d > (double)n) {
                        this.mutiMetrics.newCounter(dubboMetricsName + "dubboProviderSlowQuery", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                        this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getRpcServiceName() + "/" + jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "dubbo_provider", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "timeout", jtc.getHttpCode(), jtc.getServiceEnv()));
                    }
                } else {
                    this.mutiMetrics.newCounter(dubboMetricsName + "dubboProviderError", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getRpcServiceName() + "/" + jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "dubbo_provider", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "error", jtc.getHttpCode(), jtc.getServiceEnv()));
                }
            }
        }
        if ("redis".equals(jtc.getType())) {
            String redisMetricsName = "hera_";
            if (jtc.isSuccess()) {
                this.mutiMetrics.newCounter(redisMetricsName + "RedisSuccessCount", "method", "host", "port", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{this.reduceString(jtc.getMethod(), 100), jtc.getDbHost(), jtc.getDbPort(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{this.reduceString(jtc.getMethod(), 100), jtc.getDbHost(), jtc.getDbPort(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
            } else {
                this.mutiMetrics.newCounter(redisMetricsName + "redisError", "method", "host", "port", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{this.reduceString(jtc.getMethod(), 100), jtc.getDbHost(), jtc.getDbPort(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{this.reduceString(jtc.getMethod(), 100), jtc.getDbHost(), jtc.getDbPort(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "redis", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), jtc.getDbHost() + ":" + jtc.getDbPort(), String.valueOf(jtc.getDuration()), "error", jtc.getHttpCode(), jtc.getServiceEnv()));
            }
            this.mutiMetrics.newCounter(redisMetricsName + "RedisTotalCount", "method", "host", "port", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{this.reduceString(jtc.getMethod(), 100), jtc.getDbHost(), jtc.getDbPort(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{this.reduceString(jtc.getMethod(), 100), jtc.getDbHost(), jtc.getDbPort(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
            this.mutiMetrics.newHistogram(redisMetricsName + "RedisMethodTimeCost", redisBuckets, "method", "host", "port", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{this.reduceString(jtc.getMethod(), 100), jtc.getDbHost(), jtc.getDbPort(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{this.reduceString(jtc.getMethod(), 100), jtc.getDbHost(), jtc.getDbPort(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
        }
        if ("mysql".equals(jtc.getType())) {
            mysqlMetricsName = "hera_";
            if (jtc.isSuccess()) {
                this.mutiMetrics.newCounter(mysqlMetricsName + "sqlSuccessCount", "dataSource", "sqlMethod", "sql", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getDataSource() + "/" + jtc.getDbName(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getDataSource() + "/" + jtc.getDbName(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                double d = jtc.getDuration();
                int n = config == null ? this.mysqlSlowTime : config.getMysqlSlowThreshold();
                if (d > (double)n) {
                    this.mutiMetrics.newCounter(mysqlMetricsName + "dbSlowQuery", "dataSource", "sqlMethod", "sql", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getDataSource() + "/" + jtc.getDbName(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getDataSource() + "/" + jtc.getDbName(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, this.reduceString(jtc.getSql(), 200), metricsServiceName, jtc.getTraceId(), "mysql", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), jtc.getDataSource() + "/" + jtc.getDbName(), String.valueOf(jtc.getDuration()), "timeout", jtc.getHttpCode(), jtc.getServiceEnv()));
                }
            } else {
                this.mutiMetrics.newCounter(mysqlMetricsName + "dbError", "dataSource", "sqlMethod", "sql", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getDataSource() + "/" + jtc.getDbName(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getDataSource() + "/" + jtc.getDbName(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, this.reduceString(jtc.getSql(), 200), metricsServiceName, jtc.getTraceId(), "mysql", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), jtc.getDataSource() + "/" + jtc.getDbName(), String.valueOf(jtc.getDuration()), "error", jtc.getHttpCode(), jtc.getServiceEnv()));
            }
            this.mutiMetrics.newCounter(mysqlMetricsName + "sqlTotalCount", "dataSource", "sqlMethod", "sql", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getDataSource() + "/" + jtc.getDbName(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getDataSource() + "/" + jtc.getDbName(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
            this.mutiMetrics.newHistogram(mysqlMetricsName + "sqlTotalTimer", sqlBuckets, "dataSource", "sqlMethod", "sql", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getDataSource() + "/" + jtc.getDbName(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{jtc.getDataSource() + "/" + jtc.getDbName(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
        }
        if ("mongodb".equals(jtc.getType())) {
            mysqlMetricsName = "hera_";
            if (jtc.isSuccess()) {
                this.mutiMetrics.newCounter(mysqlMetricsName + "mongoSuccessCount", "dataSource", "method", "command", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getDataSource(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getDataSource(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                if (jtc.getDuration() > (double)this.mysqlSlowTime) {
                    this.mutiMetrics.newCounter(mysqlMetricsName + "mongodbSlowQuery", "dataSource", "method", "command", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getDataSource(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getDataSource(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, this.reduceString(jtc.getSql(), 200), metricsServiceName, jtc.getTraceId(), "mongodb", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), jtc.getDataSource(), String.valueOf(jtc.getDuration()), "timeout", jtc.getHttpCode(), jtc.getServiceEnv()));
                }
            } else {
                this.mutiMetrics.newCounter(mysqlMetricsName + "mongodbError", "dataSource", "method", "command", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getDataSource(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getDataSource(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, this.reduceString(jtc.getSql(), 200), metricsServiceName, jtc.getTraceId(), "mongodb", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), jtc.getDataSource(), String.valueOf(jtc.getDuration()), "error", jtc.getHttpCode(), jtc.getServiceEnv()));
            }
            this.mutiMetrics.newCounter(mysqlMetricsName + "mongoTotalCount", "dataSource", "method", "command", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getDataSource(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getDataSource(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
            this.mutiMetrics.newHistogram(mysqlMetricsName + "mongoTotalTimer", sqlBuckets, "dataSource", "method", "command", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getDataSource(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{jtc.getDataSource(), jtc.getSqlMethod(), this.reduceString(jtc.getSql(), 100), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
        }
        if ("rocketmq".equals(jtc.getType())) {
            metricsName = "hera_";
            if ("producer".equals(jtc.getKind())) {
                this.mutiMetrics.newHistogram(metricsName + "rocketmqProducerTimeCost", aopDubboBuckets, "topic", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                this.mutiMetrics.newCounter(metricsName + "rocketmqProducerTotalCount", "topic", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                if (jtc.isSuccess()) {
                    this.mutiMetrics.newCounter(metricsName + "rocketmqProducerSuccessCount", "topic", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    if (jtc.getDuration() > (double)this.dubboSlowTime) {
                        this.mutiMetrics.newCounter(metricsName + "rocketmqProducerSlowQuery", "topic", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                        this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "rocketmq_producer", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "timeout", jtc.getHttpCode(), jtc.getServiceEnv()));
                    }
                } else {
                    this.mutiMetrics.newCounter(metricsName + "rocketmqProducerError", "topic", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "rocketmq_producer", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "error", jtc.getHttpCode(), jtc.getServiceEnv()));
                }
            } else if ("consumer".equals(jtc.getKind())) {
                this.mutiMetrics.newHistogram(metricsName + "rocketmqConsumerTimeCost", aopDubboBuckets, "topic", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                this.mutiMetrics.newCounter(metricsName + "rocketmqConsumerTotalCount", "topic", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                if (jtc.isSuccess()) {
                    this.mutiMetrics.newCounter(metricsName + "rocketmqConsumerSuccessCount", "topic", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    if (jtc.getDuration() > (double)this.dubboSlowTime) {
                        this.mutiMetrics.newCounter(metricsName + "rocketmqConsumerSlowQuery", "topic", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                        this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "rocketmq_consumer", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "timeout", jtc.getHttpCode(), jtc.getServiceEnv()));
                    }
                } else {
                    this.mutiMetrics.newCounter(metricsName + "rocketmqConsumerError", "topic", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getTopic(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "rocketmq_consumer", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "error", jtc.getHttpCode(), jtc.getServiceEnv()));
                }
            }
        }
        if ("customizeMethod".equals(jtc.getType())) {
            metricsName = "hera_";
            this.mutiMetrics.newHistogram(metricsName + "CustomizeMethodTimeCost", aopDubboBuckets, "application", "methodName", "serverIp", "serverEnv", "serverEnvId").with(new String[]{metricsServiceName, jtc.getMethod(), jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{metricsServiceName, jtc.getMethod(), jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
            this.mutiMetrics.newCounter(metricsName + "CustomizeMethodTotalCount", "application", "methodName", "serverIp", "serverEnv", "serverEnvId").with(new String[]{metricsServiceName, jtc.getMethod(), jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{metricsServiceName, jtc.getMethod(), jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
            if (jtc.isSuccess()) {
                this.mutiMetrics.newCounter(metricsName + "CustomizeMethodSuccessCount", "application", "methodName", "serverIp", "serverEnv", "serverEnvId").with(new String[]{metricsServiceName, jtc.getMethod(), jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{metricsServiceName, jtc.getMethod(), jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                if (jtc.getDuration() > (double)this.dubboSlowTime) {
                    this.mutiMetrics.newCounter(metricsName + "CustomizeMethodSlowQuery", "application", "methodName", "serverIp", "serverEnv", "serverEnvId").with(new String[]{metricsServiceName, jtc.getMethod(), jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{metricsServiceName, jtc.getMethod(), jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "customize_method", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "timeout", jtc.getHttpCode(), jtc.getServiceEnv()));
                }
            } else {
                this.mutiMetrics.newCounter(metricsName + "CustomizeMethodError", "application", "methodName", "serverIp", "serverEnv", "serverEnvId").with(new String[]{metricsServiceName, jtc.getMethod(), jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{metricsServiceName, jtc.getMethod(), jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "customize_method", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "error", jtc.getHttpCode(), jtc.getServiceEnv()));
            }
        }
        if ("grpc".equals(jtc.getType())) {
            dubboMetricsName = "hera_";
            if ("client".equals(jtc.getKind())) {
                this.mutiMetrics.newHistogram(dubboMetricsName + "grpcClientTimeCost", aopDubboBuckets, "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                this.mutiMetrics.newCounter(dubboMetricsName + "grpcClient", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                if (jtc.isSuccess()) {
                    this.mutiMetrics.newCounter(dubboMetricsName + "grpcClientSuccess", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    double d = jtc.getDuration();
                    int n = config == null ? this.dubboSlowTime : config.getDubboSlowThreshold();
                    if (d > (double)n) {
                        this.mutiMetrics.newCounter(dubboMetricsName + "grpcClientSlowQuery", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                        this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getRpcServiceName() + "/" + jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "grpc_client", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "timeout", jtc.getHttpCode(), jtc.getServiceEnv()));
                    }
                } else {
                    this.mutiMetrics.newCounter(dubboMetricsName + "grpcClientError", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getRpcServiceName() + "/" + jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "grpc_client", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "error", jtc.getHttpCode(), jtc.getServiceEnv()));
                }
            } else if ("server".equals(jtc.getKind())) {
                this.mutiMetrics.newCounter(dubboMetricsName + "grpcServer", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                this.mutiMetrics.newHistogram(dubboMetricsName + "grpcServerTimeCost", aopDubboBuckets, "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).observe(jtc.getDuration(), new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                if (jtc.isSuccess()) {
                    this.mutiMetrics.newCounter(dubboMetricsName + "grpcServerSuccess", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    double d = jtc.getDuration();
                    int n = config == null ? this.dubboSlowTime : config.getDubboSlowThreshold();
                    if (d > (double)n) {
                        this.mutiMetrics.newCounter(dubboMetricsName + "grpcServerSlowQuery", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                        this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getRpcServiceName() + "/" + jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "grpc_server", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "timeout", jtc.getHttpCode(), jtc.getServiceEnv()));
                    }
                } else {
                    this.mutiMetrics.newCounter(dubboMetricsName + "grpcServerError", "serviceName", "methodName", "application", "serverIp", "serverEnv", "serverEnvId").with(new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()}).add(1.0, new String[]{jtc.getRpcServiceName(), jtc.getMethod(), metricsServiceName, jtc.getServerIp(), jtc.getServiceEnv(), jtc.getServiceEnvId()});
                    this.esService.insertErrorTrace(new ErrorTraceMessage(this.esDomain, jtc.getRpcServiceName() + "/" + jtc.getMethod(), metricsServiceName, jtc.getTraceId(), "grpc_server", jtc.getServerIp(), String.valueOf(jtc.getEndTime()), "", String.valueOf(jtc.getDuration()), "error", jtc.getHttpCode(), jtc.getServiceEnv()));
                }
            }
        }
    }

    private boolean exclude(String excludeList, String excludeString) {
        String[] splits;
        for (String split : splits = excludeList.split("\\|")) {
            if (!StringUtils.isNotEmpty((CharSequence)split) || !excludeString.contains(split)) continue;
            return true;
        }
        return false;
    }

    private void redisBuild(String statement, JaegerTracerDomain jtc) {
        if (StringUtils.isNotEmpty((CharSequence)statement)) {
            String[] s;
            if (statement.indexOf("?") >= 0) {
                statement = statement.replace("?", "").trim();
            }
            if ((s = statement.split(" ")).length == 1) {
                jtc.setMethod(s[0]);
                jtc.setKey("");
            } else if (s.length == 2) {
                jtc.setMethod(s[0]);
                jtc.setKey(s[1]);
            } else if (s.length > 2) {
                jtc.setMethod(s[0]);
                Object key = "";
                for (int i = 1; i < s.length; ++i) {
                    key = (String)key + s[i] + ",";
                }
                jtc.setKey(((String)key).substring(0, ((String)key).length() - 1));
            }
        }
    }

    public String reduceString(String ori, int size) {
        if (StringUtils.isNotEmpty((CharSequence)ori) && ori.length() > size) {
            String substring = ori.substring(0, size - 1);
            return substring;
        }
        return ori;
    }

    private String formatServiceName(String serviceName) {
        return serviceName.replace("-", "_");
    }

    private HeraTraceEtlConfig defaultConfig(HeraTraceEtlConfig config) {
        if (config == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)config.getExcludeHttpserverMethod())) {
            config.setExcludeHttpserverMethod(this.excludeHttpServer);
        }
        if (StringUtils.isEmpty((CharSequence)config.getExcludeMethod())) {
            config.setExcludeMethod(this.excludeMethod);
        }
        if (StringUtils.isEmpty((CharSequence)config.getExcludeSql())) {
            config.setExcludeSql(this.excludeDB);
        }
        if (StringUtils.isEmpty((CharSequence)config.getExcludeHttpUrl())) {
            config.setExcludeHttpUrl(this.excludeHttpurl);
        }
        if (StringUtils.isEmpty((CharSequence)config.getExcludeThread())) {
            config.setExcludeThread(this.excludeThread);
        }
        if (StringUtils.isEmpty((CharSequence)config.getExcludeUa())) {
            config.setExcludeUa(this.excludeUA);
        }
        if (config.getDubboSlowThreshold() == null) {
            config.setDubboSlowThreshold(Integer.valueOf(this.dubboSlowTime));
        }
        if (config.getHttpSlowThreshold() == null) {
            config.setHttpSlowThreshold(Integer.valueOf(this.httpSlowTime));
        }
        if (config.getMysqlSlowThreshold() == null) {
            config.setMysqlSlowThreshold(Integer.valueOf(this.mysqlSlowTime));
        }
        return config;
    }
}

