/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.mybatisplus;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.MybatisSqlSessionFactoryBuilder;
import com.xiaomi.youpin.docean.common.Resource;
import com.xiaomi.youpin.docean.plugin.mybatisplus.MybatisSessionFactory;
import com.xiaomi.youpin.docean.plugin.mybatisplus.MybatisTransactionFactory;
import java.io.IOException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSessionFactoryBean {
    private static final Logger log = LoggerFactory.getLogger(SqlSessionFactoryBean.class);
    private DataSource dataSource;
    private Interceptor[] plugins;
    private Resource[] mapperLocations;
    private TransactionFactory transactionFactory = new MybatisTransactionFactory();
    private String environment = "docean";
    private MybatisSqlSessionFactoryBuilder sqlSessionFactoryBuilder = new MybatisSqlSessionFactoryBuilder();

    public SqlSessionFactory buildSqlSessionFactory() throws IOException {
        MybatisConfiguration configuration = new MybatisConfiguration();
        if (null != this.plugins) {
            for (Interceptor interceptor : this.plugins) {
                configuration.addInterceptor(interceptor);
                log.debug("Registered plugin: '" + String.valueOf(interceptor) + "'");
            }
        }
        configuration.setEnvironment(new Environment(this.environment, this.transactionFactory, this.dataSource));
        if (null != this.mapperLocations) {
            for (Interceptor interceptor : this.mapperLocations) {
                if (interceptor == null) continue;
                try {
                    XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(interceptor.getInputStream(), (Configuration)configuration, interceptor.toString(), configuration.getSqlFragments());
                    xmlMapperBuilder.parse();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to parse mapping resource: '" + String.valueOf(interceptor) + "'", e);
                }
                finally {
                    ErrorContext.instance().reset();
                }
                log.debug("Parsed mapper file: '" + String.valueOf(interceptor) + "'");
            }
        } else {
            log.debug("Property 'mapperLocations' was not specified or no matching resources found");
        }
        return new MybatisSessionFactory(this.sqlSessionFactoryBuilder.build((Configuration)configuration));
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Interceptor[] getPlugins() {
        return this.plugins;
    }

    public Resource[] getMapperLocations() {
        return this.mapperLocations;
    }

    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public MybatisSqlSessionFactoryBuilder getSqlSessionFactoryBuilder() {
        return this.sqlSessionFactoryBuilder;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setPlugins(Interceptor[] plugins) {
        this.plugins = plugins;
    }

    public void setMapperLocations(Resource[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setSqlSessionFactoryBuilder(MybatisSqlSessionFactoryBuilder sqlSessionFactoryBuilder) {
        this.sqlSessionFactoryBuilder = sqlSessionFactoryBuilder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlSessionFactoryBean)) {
            return false;
        }
        SqlSessionFactoryBean other = (SqlSessionFactoryBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPlugins(), other.getPlugins())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMapperLocations(), other.getMapperLocations())) {
            return false;
        }
        TransactionFactory this$transactionFactory = this.getTransactionFactory();
        TransactionFactory other$transactionFactory = other.getTransactionFactory();
        if (this$transactionFactory == null ? other$transactionFactory != null : !this$transactionFactory.equals(other$transactionFactory)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        MybatisSqlSessionFactoryBuilder this$sqlSessionFactoryBuilder = this.getSqlSessionFactoryBuilder();
        MybatisSqlSessionFactoryBuilder other$sqlSessionFactoryBuilder = other.getSqlSessionFactoryBuilder();
        return !(this$sqlSessionFactoryBuilder == null ? other$sqlSessionFactoryBuilder != null : !this$sqlSessionFactoryBuilder.equals(other$sqlSessionFactoryBuilder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlSessionFactoryBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPlugins());
        result = result * 59 + Arrays.deepHashCode(this.getMapperLocations());
        TransactionFactory $transactionFactory = this.getTransactionFactory();
        result = result * 59 + ($transactionFactory == null ? 43 : $transactionFactory.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        MybatisSqlSessionFactoryBuilder $sqlSessionFactoryBuilder = this.getSqlSessionFactoryBuilder();
        result = result * 59 + ($sqlSessionFactoryBuilder == null ? 43 : $sqlSessionFactoryBuilder.hashCode());
        return result;
    }

    public String toString() {
        return "SqlSessionFactoryBean(dataSource=" + String.valueOf(this.getDataSource()) + ", plugins=" + Arrays.deepToString(this.getPlugins()) + ", mapperLocations=" + Arrays.deepToString(this.getMapperLocations()) + ", transactionFactory=" + String.valueOf(this.getTransactionFactory()) + ", environment=" + this.getEnvironment() + ", sqlSessionFactoryBuilder=" + String.valueOf(this.getSqlSessionFactoryBuilder()) + ")";
    }
}

