/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.es;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesResponse;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.client.indices.IndexTemplateMetadata;
import org.elasticsearch.client.indices.IndexTemplatesExistRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.elasticsearch.client.sniff.NodesSniffer;
import org.elasticsearch.client.sniff.SniffOnFailureListener;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class EsClient {
    private static Sniffer sniffer;
    private static final int SNIFF_INTERVAL_MILLIS = 180000;
    private static final int SNIFF_AFTER_FAILURE_DELAY_MILLIS = 60000;
    private static final int MAX_CONN_PER_ROUTE = 500;
    private static final int MAX_CONN_TOTAL = 500;
    private static final int SOCKET_TIMEOUT_MS = 600000;
    private static final int CONNECTION_REQUEST_TIMEOUT_MS = 5000000;
    private static final int CONNECT_TIMEOUT_MS = 5000000;
    private static final long KEEP_ALIVE_DURATION_MS;
    private RestHighLevelClient client;
    private RestClient restClient;
    public static boolean startedSniffer;
    private SniffOnFailureListener sniffOnFailureListener = new SniffOnFailureListener();

    public EsClient(String esAddr, String token, String catalog, String database) {
        this.validateParams(esAddr, token, catalog, database);
        Header[] defaultHeaders = this.createDefaultHeaders(token, catalog, database);
        RestClientBuilder builder = this.createRestClientBuilder(esAddr, defaultHeaders);
        this.initializeHighLevelClient(builder);
        this.initializeSnifferIfNeeded();
    }

    private void validateParams(String esAddr, String token, String catalog, String database) {
        if (esAddr == null || esAddr.isEmpty() || token == null || token.isEmpty() || catalog == null || catalog.isEmpty() || database == null || database.isEmpty()) {
            throw new IllegalArgumentException("Invalid parameters provided");
        }
    }

    private Header[] createDefaultHeaders(String token, String catalog, String database) {
        return new Header[]{new BasicHeader("Authorization", token), new BasicHeader("catalog", catalog), new BasicHeader("database", database)};
    }

    private void initializeSnifferIfNeeded() {
        if (startedSniffer) {
            this.initializeSniffer();
        }
    }

    private RestClientBuilder createRestClientBuilder(String esAddr, Header[] defaultHeaders) {
        String[] esAddrParts = esAddr.split(":");
        if (esAddrParts.length != 2) {
            throw new IllegalArgumentException("Invalid Elasticsearch address");
        }
        String host = esAddrParts[0];
        int port = Integer.parseInt(esAddrParts[1]);
        return RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(host, port, "http")}).setDefaultHeaders(defaultHeaders).setFailureListener((RestClient.FailureListener)this.sniffOnFailureListener).setHttpClientConfigCallback(x -> x.setMaxConnPerRoute(500).setMaxConnTotal(500).setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(600000).setConnectionRequestTimeout(5000000).setConnectTimeout(5000000).build()).setKeepAliveStrategy((response, context) -> KEEP_ALIVE_DURATION_MS).setDefaultIOReactorConfig(IOReactorConfig.custom().setSoKeepAlive(true).build()));
    }

    public EsClient(String esAddr, String user, String pwd) {
        List<HttpHost> hosts = this.createHttpHosts(esAddr);
        Header[] headers = this.createHeaders(user, pwd);
        RestClientBuilder clientBuilder = this.createRestClientBuilder(hosts, headers);
        this.initializeHighLevelClient(clientBuilder);
        this.initializeSnifferIfNeeded();
    }

    private void validateParams(String esAddr, String user, String pwd) {
        if (esAddr == null || esAddr.isEmpty() || user == null || user.isEmpty() || pwd == null || pwd.isEmpty()) {
            throw new IllegalArgumentException("Invalid parameters provided");
        }
    }

    private List<HttpHost> createHttpHosts(String esAddr) {
        String[] addrs = esAddr.split(",");
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
        for (String addr : addrs) {
            String[] hostAndPort = addr.split(":");
            String host = hostAndPort[0];
            int port = Integer.parseInt(hostAndPort[1]);
            hosts.add(new HttpHost(host, port));
        }
        return hosts;
    }

    private Header[] createHeaders(String user, String pwd) {
        String urlEncodePassword = new String(Base64.getUrlEncoder().encode(String.format("%s:%s", user, pwd).getBytes()));
        String basicAuth = String.format("Basic %s", urlEncodePassword);
        return new Header[]{new BasicHeader("Authorization", basicAuth), new BasicHeader("Content-Type", "application/json")};
    }

    private RestClientBuilder createRestClientBuilder(List<HttpHost> hosts, Header[] headers) {
        return RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[0])).setDefaultHeaders(headers).setFailureListener((RestClient.FailureListener)this.sniffOnFailureListener).setFailureListener((RestClient.FailureListener)this.sniffOnFailureListener).setHttpClientConfigCallback(x -> x.setMaxConnPerRoute(500).setMaxConnTotal(500).setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(600000).setConnectionRequestTimeout(5000000).setConnectTimeout(5000000).build()).setKeepAliveStrategy((response, context) -> KEEP_ALIVE_DURATION_MS).setDefaultIOReactorConfig(IOReactorConfig.custom().setSoKeepAlive(true).build()));
    }

    private void initializeHighLevelClient(RestClientBuilder clientBuilder) {
        this.client = new RestHighLevelClient(clientBuilder);
        this.restClient = this.client.getLowLevelClient();
    }

    private void initializeSniffer() {
        sniffer = Sniffer.builder((RestClient)this.restClient).setSniffIntervalMillis(180000).setSniffAfterFailureDelayMillis(60000).setNodesSniffer((NodesSniffer)new ElasticsearchNodesSniffer(this.restClient, TimeUnit.SECONDS.toMillis(60L), ElasticsearchNodesSniffer.Scheme.HTTP)).build();
        this.sniffOnFailureListener.setSniffer(sniffer);
    }

    public SearchResponse search(SearchRequest searchRequest) throws IOException {
        SearchResponse res = this.client.search(searchRequest, RequestOptions.DEFAULT);
        return res;
    }

    public void insertDoc(String index, Map<String, Object> data) throws IOException {
        IndexRequest indexRequest = new IndexRequest(index, "_doc", UUID.randomUUID().toString()).source(data);
        indexRequest.opType(DocWriteRequest.OpType.CREATE);
        IndexResponse indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
    }

    public void insertDoc(String index, Map<String, Object> data, String id) throws IOException {
        IndexRequest indexRequest = new IndexRequest(index, "_doc", id).source(data);
        indexRequest.opType(DocWriteRequest.OpType.CREATE);
        IndexResponse indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
    }

    public void insertDocForIndex(String index, Map<String, Object> data) throws IOException {
        IndexRequest indexRequest = new IndexRequest(index, "_doc", UUID.randomUUID().toString()).source(data);
        indexRequest.opType(DocWriteRequest.OpType.INDEX);
        IndexResponse indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
    }

    public void insertDocForIndex(String index, Map<String, Object> data, String id) throws IOException {
        IndexRequest indexRequest = new IndexRequest(index, "_doc", id).source(data);
        indexRequest.opType(DocWriteRequest.OpType.INDEX);
        IndexResponse indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
    }

    public void insertDocJson(String index, String jsonString) throws IOException {
        IndexRequest indexRequest = new IndexRequest(index, "_doc", UUID.randomUUID().toString()).source(jsonString, XContentType.JSON);
        indexRequest.opType(DocWriteRequest.OpType.CREATE);
        IndexResponse indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
    }

    public void insertDocJson(String index, String jsonString, String id) throws IOException {
        IndexRequest indexRequest = new IndexRequest(index, "_doc", id).source(jsonString, XContentType.JSON);
        indexRequest.opType(DocWriteRequest.OpType.CREATE);
        IndexResponse indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
    }

    public void insertDocAsyn(String index, Map<String, Object> data, ActionListener<IndexResponse> listener) {
        IndexRequest request = new IndexRequest(index).source(data);
        this.client.indexAsync(request, RequestOptions.DEFAULT, listener);
    }

    public void createIndex(String name, String mapping) throws IOException {
        org.elasticsearch.action.admin.indices.create.CreateIndexRequest request = new org.elasticsearch.action.admin.indices.create.CreateIndexRequest(name);
        request.mapping(mapping, new Object[]{XContentType.JSON});
        RequestOptions options = RequestOptions.DEFAULT;
        this.client.indices().create(request, options);
    }

    public CreateIndexResponse createIndex(org.elasticsearch.action.admin.indices.create.CreateIndexRequest request) throws IOException {
        return this.client.indices().create(request, RequestOptions.DEFAULT);
    }

    public org.elasticsearch.client.indices.CreateIndexResponse createIndex(CreateIndexRequest request) throws IOException {
        return this.client.indices().create(request, RequestOptions.DEFAULT);
    }

    public GetResponse get(GetRequest getRequest) throws IOException {
        GetResponse getResponse = this.client.get(getRequest, RequestOptions.DEFAULT);
        return getResponse;
    }

    public SearchResponse queryByIndex(String index) throws IOException {
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)"_index", (Object)index);
        sourceBuilder.query((QueryBuilder)queryBuilder);
        searchRequest.source(sourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        return searchResponse;
    }

    public DeleteResponse delete(DeleteRequest request) throws IOException {
        DeleteResponse resp = this.client.delete(request, RequestOptions.DEFAULT);
        return resp;
    }

    public UpdateResponse update(UpdateRequest request) throws IOException {
        UpdateResponse response = this.client.update(request, RequestOptions.DEFAULT);
        return response;
    }

    @Deprecated
    public boolean bulkInsert(String index, List<Map<String, Object>> dataList) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (int i = 0; i < dataList.size(); ++i) {
            bulkRequest.add(new IndexRequest(index).source(dataList.get(i)));
        }
        bulkRequest.timeout(TimeValue.timeValueSeconds((long)5L));
        BulkResponse bulkResponse = this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        return !bulkResponse.hasFailures();
    }

    public boolean createIndexTemplate(PutIndexTemplateRequest request) throws IOException {
        AcknowledgedResponse response = this.client.indices().putTemplate(request, RequestOptions.DEFAULT);
        return response.isAcknowledged();
    }

    public boolean existsTemplate(IndexTemplatesExistRequest request) throws IOException {
        return this.client.indices().existsTemplate(request, RequestOptions.DEFAULT);
    }

    public List<IndexTemplateMetadata> getIndexTemplates(GetIndexTemplatesRequest request) throws IOException {
        GetIndexTemplatesResponse templatesResponse = this.client.indices().getIndexTemplate(request, RequestOptions.DEFAULT);
        return templatesResponse.getIndexTemplates();
    }

    public Long count(CountRequest countRequest) throws IOException {
        CountResponse countResponse = this.client.count(countRequest, RequestOptions.DEFAULT);
        long count = countResponse.getCount();
        return count;
    }

    public EsRet dateHistogram(String indexName, String interval, long startTime, long endTime, BoolQueryBuilder builder) throws IOException {
        return this.dateHistogram(indexName, "timestamp", interval, startTime, endTime, builder);
    }

    public EsRet dateHistogram(String indexName, String field, String interval, long startTime, long endTime, BoolQueryBuilder builder) throws IOException {
        EsRet esRet = new EsRet(this);
        DateHistogramAggregationBuilder aggregationBuilder = ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"dateHistogram").minDocCount(0L).fixedInterval(new DateHistogramInterval(interval)).field(field)).timeZone(TimeZone.getTimeZone("GMT+8").toZoneId())).format("yyyy-MM-dd HH:mm:ss")).extendedBounds(new LongBounds(Long.valueOf(startTime), Long.valueOf(endTime)));
        SearchRequest searchRequest = new SearchRequest();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)builder).aggregation((AggregationBuilder)aggregationBuilder).size(0).timeout(TimeValue.timeValueSeconds((long)10L));
        searchRequest.source(searchSourceBuilder);
        searchRequest.indices(new String[]{indexName});
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        if (searchResponse == null || searchResponse.getAggregations() == null) {
            return esRet;
        }
        Aggregation agg = searchResponse.getAggregations().get("dateHistogram");
        List buckets = ((Histogram)agg).getBuckets();
        ArrayList<String> timestamps = new ArrayList<String>();
        ArrayList<Long> counts = new ArrayList<Long>();
        for (Histogram.Bucket bucket : buckets) {
            timestamps.add(bucket.getKeyAsString());
            counts.add(bucket.getDocCount());
        }
        esRet.setCounts(counts);
        esRet.setTimestamps(timestamps);
        return esRet;
    }

    public Integer getClusterHealth() throws IOException {
        ClusterHealthRequest request = new ClusterHealthRequest();
        request.timeout(TimeValue.timeValueSeconds((long)50L));
        ClusterHealthResponse response = this.client.cluster().health(request, RequestOptions.DEFAULT);
        return response.status().getStatus();
    }

    public void searchAsync(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        this.client.searchAsync(searchRequest, RequestOptions.DEFAULT, listener);
    }

    public RestHighLevelClient getEsOriginalClient() {
        return this.client;
    }

    public void close() throws IOException {
        this.client.close();
        if (sniffer != null) {
            sniffer.close();
        }
    }

    public GetMappingsResponse queryIndexMapping(String indexName) throws IOException {
        GetMappingsRequest request = new GetMappingsRequest().indices(new String[]{indexName});
        return this.client.indices().getMapping(request, RequestOptions.DEFAULT);
    }

    static {
        KEEP_ALIVE_DURATION_MS = TimeUnit.MINUTES.toMillis(2L);
        startedSniffer = true;
    }

    public class EsRet {
        private List<String> timestamps;
        private List<Long> counts;

        public EsRet(EsClient this$0) {
        }

        public List<String> getTimestamps() {
            return this.timestamps;
        }

        public List<Long> getCounts() {
            return this.counts;
        }

        public void setTimestamps(List<String> timestamps) {
            this.timestamps = timestamps;
        }

        public void setCounts(List<Long> counts) {
            this.counts = counts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EsRet)) {
                return false;
            }
            EsRet other = (EsRet)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$timestamps = this.getTimestamps();
            List<String> other$timestamps = other.getTimestamps();
            if (this$timestamps == null ? other$timestamps != null : !((Object)this$timestamps).equals(other$timestamps)) {
                return false;
            }
            List<Long> this$counts = this.getCounts();
            List<Long> other$counts = other.getCounts();
            return !(this$counts == null ? other$counts != null : !((Object)this$counts).equals(other$counts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EsRet;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $timestamps = this.getTimestamps();
            result = result * 59 + ($timestamps == null ? 43 : ((Object)$timestamps).hashCode());
            List<Long> $counts = this.getCounts();
            result = result * 59 + ($counts == null ? 43 : ((Object)$counts).hashCode());
            return result;
        }

        public String toString() {
            return "EsClient.EsRet(timestamps=" + String.valueOf(this.getTimestamps()) + ", counts=" + String.valueOf(this.getCounts()) + ")";
        }
    }
}

