/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.redis.core.convert.BinaryConverters;
import org.springframework.util.ClassUtils;

public abstract class Jsr310Converters {
    private static final boolean JAVA_8_IS_PRESENT = ClassUtils.isPresent((String)"java.time.LocalDateTime", (ClassLoader)Jsr310Converters.class.getClassLoader());

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        if (!JAVA_8_IS_PRESENT) {
            return Collections.emptySet();
        }
        ArrayList converters = new ArrayList();
        converters.add(new LocalDateTimeToBytesConverter());
        converters.add(new BytesToLocalDateTimeConverter());
        converters.add(new LocalDateToBytesConverter());
        converters.add(new BytesToLocalDateConverter());
        converters.add(new LocalTimeToBytesConverter());
        converters.add(new BytesToLocalTimeConverter());
        converters.add(new ZonedDateTimeToBytesConverter());
        converters.add(new BytesToZonedDateTimeConverter());
        converters.add(new InstantToBytesConverter());
        converters.add(new BytesToInstantConverter());
        converters.add(new ZoneIdToBytesConverter());
        converters.add(new BytesToZoneIdConverter());
        converters.add(new PeriodToBytesConverter());
        converters.add(new BytesToPeriodConverter());
        converters.add(new DurationToBytesConverter());
        converters.add(new BytesToDurationConverter());
        return converters;
    }

    public static boolean supports(Class<?> type) {
        if (!JAVA_8_IS_PRESENT) {
            return false;
        }
        return Arrays.asList(LocalDateTime.class, LocalDate.class, LocalTime.class, Instant.class, ZonedDateTime.class, ZoneId.class, Period.class, Duration.class).contains(type);
    }

    @ReadingConverter
    static class BytesToDurationConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], Duration> {
        BytesToDurationConverter() {
        }

        public Duration convert(byte[] source) {
            return Duration.parse(this.toString(source));
        }
    }

    @WritingConverter
    static class DurationToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<Duration, byte[]> {
        DurationToBytesConverter() {
        }

        public byte[] convert(Duration source) {
            return this.fromString(source.toString());
        }
    }

    @ReadingConverter
    static class BytesToPeriodConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], Period> {
        BytesToPeriodConverter() {
        }

        public Period convert(byte[] source) {
            return Period.parse(this.toString(source));
        }
    }

    @WritingConverter
    static class PeriodToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<Period, byte[]> {
        PeriodToBytesConverter() {
        }

        public byte[] convert(Period source) {
            return this.fromString(source.toString());
        }
    }

    @ReadingConverter
    static class BytesToZoneIdConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], ZoneId> {
        BytesToZoneIdConverter() {
        }

        public ZoneId convert(byte[] source) {
            return ZoneId.of(this.toString(source));
        }
    }

    @WritingConverter
    static class ZoneIdToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<ZoneId, byte[]> {
        ZoneIdToBytesConverter() {
        }

        public byte[] convert(ZoneId source) {
            return this.fromString(source.toString());
        }
    }

    @ReadingConverter
    static class BytesToInstantConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], Instant> {
        BytesToInstantConverter() {
        }

        public Instant convert(byte[] source) {
            return Instant.parse(this.toString(source));
        }
    }

    @WritingConverter
    static class InstantToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<Instant, byte[]> {
        InstantToBytesConverter() {
        }

        public byte[] convert(Instant source) {
            return this.fromString(source.toString());
        }
    }

    @ReadingConverter
    static class BytesToZonedDateTimeConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], ZonedDateTime> {
        BytesToZonedDateTimeConverter() {
        }

        public ZonedDateTime convert(byte[] source) {
            return ZonedDateTime.parse(this.toString(source));
        }
    }

    @WritingConverter
    static class ZonedDateTimeToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<ZonedDateTime, byte[]> {
        ZonedDateTimeToBytesConverter() {
        }

        public byte[] convert(ZonedDateTime source) {
            return this.fromString(source.toString());
        }
    }

    @ReadingConverter
    static class BytesToLocalTimeConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], LocalTime> {
        BytesToLocalTimeConverter() {
        }

        public LocalTime convert(byte[] source) {
            return LocalTime.parse(this.toString(source));
        }
    }

    @WritingConverter
    static class LocalTimeToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<LocalTime, byte[]> {
        LocalTimeToBytesConverter() {
        }

        public byte[] convert(LocalTime source) {
            return this.fromString(source.toString());
        }
    }

    @ReadingConverter
    static class BytesToLocalDateConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], LocalDate> {
        BytesToLocalDateConverter() {
        }

        public LocalDate convert(byte[] source) {
            return LocalDate.parse(this.toString(source));
        }
    }

    @WritingConverter
    static class LocalDateToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<LocalDate, byte[]> {
        LocalDateToBytesConverter() {
        }

        public byte[] convert(LocalDate source) {
            return this.fromString(source.toString());
        }
    }

    @ReadingConverter
    static class BytesToLocalDateTimeConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<byte[], LocalDateTime> {
        BytesToLocalDateTimeConverter() {
        }

        public LocalDateTime convert(byte[] source) {
            return LocalDateTime.parse(this.toString(source));
        }
    }

    @WritingConverter
    static class LocalDateTimeToBytesConverter
    extends BinaryConverters.StringBasedConverter
    implements Converter<LocalDateTime, byte[]> {
        LocalDateTimeToBytesConverter() {
        }

        public byte[] convert(LocalDateTime source) {
            return this.fromString(source.toString());
        }
    }
}

