/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.trace;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.TracingContext;
import org.apache.skywalking.apm.agent.core.context.status.StatusCheckService;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.LogDataEntity;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.context.trace.TraceSegment;
import org.apache.skywalking.apm.agent.core.context.trace.TraceSegmentRef;
import org.apache.skywalking.apm.agent.core.context.util.KeyValuePair;
import org.apache.skywalking.apm.agent.core.context.util.TagValuePair;
import org.apache.skywalking.apm.agent.core.context.util.ThrowableTransformer;
import org.apache.skywalking.apm.agent.core.dictionary.DictionaryUtil;
import org.apache.skywalking.apm.network.language.agent.v3.SpanObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanType;
import org.apache.skywalking.apm.network.trace.component.Component;

public abstract class AbstractTracingSpan
implements AbstractSpan {
    protected int spanId;
    protected int parentSpanId;
    protected List<TagValuePair> tags;
    protected String operationName;
    protected SpanLayer layer;
    protected volatile boolean isInAsyncMode = false;
    private volatile boolean isAsyncStopped = false;
    protected final TracingContext owner;
    protected long startTime;
    protected long endTime;
    protected boolean errorOccurred = false;
    protected int componentId = 0;
    protected List<LogDataEntity> logs;
    protected List<TraceSegmentRef> refs;
    protected boolean skipAnalysis;

    protected AbstractTracingSpan(int spanId, int parentSpanId, String operationName, TracingContext owner) {
        this.operationName = operationName;
        this.spanId = spanId;
        this.parentSpanId = parentSpanId;
        this.owner = owner;
    }

    @Override
    public AbstractTracingSpan tag(String key, String value) {
        return this.tag((AbstractTag)Tags.ofKey(key), value);
    }

    @Override
    public AbstractTracingSpan tag(AbstractTag<?> tag, String value) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagValuePair>(8);
        }
        if (tag.isCanOverwrite()) {
            for (TagValuePair pair : this.tags) {
                if (!pair.sameWith(tag)) continue;
                pair.setValue(value);
                return this;
            }
        }
        this.tags.add(new TagValuePair(tag, value));
        return this;
    }

    public boolean finish(TraceSegment owner) {
        this.endTime = System.currentTimeMillis();
        owner.archive(this);
        return true;
    }

    @Override
    public AbstractTracingSpan start() {
        this.startTime = System.currentTimeMillis();
        return this;
    }

    @Override
    public AbstractTracingSpan log(Throwable t) {
        if (this.logs == null) {
            this.logs = new LinkedList<LogDataEntity>();
        }
        if (!this.errorOccurred && ServiceManager.INSTANCE.findService(StatusCheckService.class).isError(t)) {
            this.errorOccurred();
        }
        this.logs.add(new LogDataEntity.Builder().add(new KeyValuePair("event", "error")).add(new KeyValuePair("error.kind", t.getClass().getName())).add(new KeyValuePair("message", t.getMessage())).add(new KeyValuePair("stack", ThrowableTransformer.INSTANCE.convert2String(t, 4000))).build(System.currentTimeMillis()));
        return this;
    }

    @Override
    public AbstractTracingSpan log(long timestampMicroseconds, Map<String, ?> fields) {
        if (this.logs == null) {
            this.logs = new LinkedList<LogDataEntity>();
        }
        LogDataEntity.Builder builder = new LogDataEntity.Builder();
        for (Map.Entry<String, ?> entry : fields.entrySet()) {
            builder.add(new KeyValuePair(entry.getKey(), entry.getValue().toString()));
        }
        this.logs.add(builder.build(timestampMicroseconds));
        return this;
    }

    @Override
    public AbstractTracingSpan errorOccurred() {
        this.errorOccurred = true;
        return this;
    }

    @Override
    public AbstractTracingSpan setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    @Override
    public int getSpanId() {
        return this.spanId;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public AbstractTracingSpan setLayer(SpanLayer layer) {
        this.layer = layer;
        return this;
    }

    @Override
    public AbstractTracingSpan setComponent(Component component) {
        this.componentId = component.getId();
        return this;
    }

    @Override
    public AbstractSpan start(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public SpanObject.Builder transform() {
        SpanObject.Builder spanBuilder = SpanObject.newBuilder();
        spanBuilder.setSpanId(this.spanId);
        spanBuilder.setParentSpanId(this.parentSpanId);
        spanBuilder.setStartTime(this.startTime);
        spanBuilder.setEndTime(this.endTime);
        spanBuilder.setOperationName(this.operationName);
        spanBuilder.setSkipAnalysis(this.skipAnalysis);
        if (this.isEntry()) {
            spanBuilder.setSpanType(SpanType.Entry);
        } else if (this.isExit()) {
            spanBuilder.setSpanType(SpanType.Exit);
        } else {
            spanBuilder.setSpanType(SpanType.Local);
        }
        if (this.layer != null) {
            spanBuilder.setSpanLayerValue(this.layer.getCode());
        }
        if (this.componentId != DictionaryUtil.nullValue()) {
            spanBuilder.setComponentId(this.componentId);
        }
        spanBuilder.setIsError(this.errorOccurred);
        if (this.tags != null) {
            for (TagValuePair tag : this.tags) {
                spanBuilder.addTags(tag.transform());
            }
        }
        if (this.logs != null) {
            for (LogDataEntity log : this.logs) {
                spanBuilder.addLogs(log.transform());
            }
        }
        if (this.refs != null) {
            for (TraceSegmentRef ref : this.refs) {
                spanBuilder.addRefs(ref.transform());
            }
        }
        return spanBuilder;
    }

    @Override
    public void ref(TraceSegmentRef ref) {
        if (this.refs == null) {
            this.refs = new LinkedList<TraceSegmentRef>();
        }
        if (this.refs.size() == Config.Agent.TRACE_SEGMENT_REF_LIMIT_PER_SPAN) {
            return;
        }
        if (!this.refs.contains(ref)) {
            this.refs.add(ref);
        }
    }

    @Override
    public AbstractSpan prepareForAsync() {
        if (this.isInAsyncMode) {
            throw new RuntimeException("Prepare for async repeatedly. Span is already in async mode.");
        }
        ContextManager.awaitFinishAsync(this);
        this.isInAsyncMode = true;
        return this;
    }

    @Override
    public AbstractSpan asyncFinish() {
        if (!this.isInAsyncMode) {
            throw new RuntimeException("Span is not in async mode, please use '#prepareForAsync' to active.");
        }
        if (this.isAsyncStopped) {
            throw new RuntimeException("Can not do async finish for the span repeatedly.");
        }
        this.endTime = System.currentTimeMillis();
        this.owner.asyncStop(this);
        this.isAsyncStopped = true;
        return this;
    }

    @Override
    public boolean isProfiling() {
        return this.owner.profileStatus().isProfiling();
    }

    @Override
    public void skipAnalysis() {
        this.skipAnalysis = true;
    }
}

