/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.a.a.a;
import dm.jdbc.driver.DBError;
import dm.jdbc.util.StringUtil;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Collection;
import java.util.Iterator;

public class ConvertUtil {
    public static boolean toBoolean(String string) {
        if (StringUtil.equals(string = StringUtil.trimToEmpty(string), "0")) {
            return false;
        }
        if (StringUtil.equals(string, "1")) {
            return true;
        }
        try {
            long l2 = Long.valueOf(string);
            return l2 != 0L;
        }
        catch (Exception exception) {
            boolean bl = false;
            try {
                bl = Boolean.valueOf(string);
            }
            catch (Exception exception2) {
                DBError.throwRuntimeException(DBError.ECJDBC_DATA_CONVERTION_ERROR.reason);
            }
            return bl;
        }
    }

    public static int toInt(long l2) {
        return l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
    }

    public static Integer toInteger(String string, String string2, String string3) {
        if (StringUtil.isEmpty(string = StringUtil.substringBetween(string, string2, string3))) {
            return null;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static long[] toLongArray(Collection collection) {
        long[] lArray = new long[collection.size()];
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (n2 < lArray.length) {
            lArray[n2] = (Long)iterator.next();
            ++n2;
        }
        return lArray;
    }

    public static final char[] ASCIIBytesToJavaChars(byte[] byArray, int n2, int n3) {
        char[] cArray = new char[n3];
        int n4 = n2 + n3;
        int n5 = n2;
        int n6 = n2;
        while (n5 < n4) {
            cArray[n5] = (char)(0xFF & byArray[n6]);
            ++n5;
            ++n6;
        }
        return cArray;
    }

    public static final byte[] JavaCharsToASCIIBytes(char[] cArray, int n2, int n3) {
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            byArray[n4] = (byte)cArray[n2 + n4];
            ++n4;
        }
        return byArray;
    }

    public static final byte[] StringToAsciiBytes(String string) {
        if (StringUtil.isEmpty(string)) {
            return new byte[0];
        }
        char[] cArray = string.toCharArray();
        return ConvertUtil.JavaCharsToASCIIBytes(cArray, 0, cArray.length);
    }

    public static final byte[] JavaCharsToUnicodeBytes(char[] cArray, int n2, int n3) {
        byte[] byArray = new byte[n3 * 2];
        int n4 = n2;
        int n5 = 0;
        while (n5 < n3) {
            char c2 = cArray[n4++];
            byArray[n5++] = (byte)(c2 >> 8 & 0xFF);
            byArray[n5++] = (byte)(c2 & 0xFF);
        }
        return byArray;
    }

    public static final String UnicodeBytesToString(byte[] byArray, int n2) {
        int n3 = n2 >>> 1;
        char[] cArray = new char[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            int n6 = byArray[n5] << 8;
            cArray[n4] = (char)(n6 | byArray[n5 + 1] & 0xFF);
            n5 += 2;
            ++n4;
        }
        return new String(cArray);
    }

    public static byte[] StringToUnicodeBytes(String string) {
        if (StringUtil.isEmpty(string)) {
            return new byte[0];
        }
        char[] cArray = string.toCharArray();
        return ConvertUtil.JavaCharsToASCIIBytes(cArray, 0, cArray.length);
    }

    public static String getClobData(Clob clob, long l2, long l3) {
        if (l3 < Integer.MAX_VALUE) {
            return clob.getSubString(l2, (int)l3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        long l4 = l3;
        int n2 = 0;
        long l5 = l2;
        while (l4 > 0L) {
            n2 = (int)(l4 < Integer.MAX_VALUE ? l4 : Integer.MAX_VALUE);
            stringBuilder.append(clob.getSubString(l5, n2));
            l4 -= (long)n2;
            l5 += (long)n2;
        }
        return stringBuilder.toString();
    }

    public static String getClobData(Clob clob) {
        long l2 = clob.length();
        return ConvertUtil.getClobData(clob, 1L, l2);
    }

    public static byte[] getBlobData(Blob blob, long l2, long l3) {
        if (l3 < Integer.MAX_VALUE) {
            return blob.getBytes(l2, (int)l3);
        }
        a a2 = a.a(Integer.MAX_VALUE, true, 0);
        long l4 = l3;
        int n2 = 0;
        long l5 = l2;
        while (l4 > 0L) {
            n2 = (int)(l4 < Integer.MAX_VALUE ? l4 : Integer.MAX_VALUE);
            a2.a(blob.getBytes(l5, n2));
            l4 -= (long)n2;
            l5 += (long)n2;
        }
        a2.d(0);
        return a2.k(a2.length());
    }

    public static byte[] getBlobData(Blob blob) {
        long l2 = blob.length();
        return ConvertUtil.getBlobData(blob, 1L, l2);
    }
}

