/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.util.Date;

public class DateUtil {
    public static final int DATE = 1;
    public static final int DATE_TIME = 2;
    public static final int YYYY_MM_DD_HH_MM_SS = 3;

    public static String formatMilliSecond(int n2, int n3) {
        String string = null;
        string = n2 < 10 ? "00000000" + n2 : (n2 < 100 ? "0000000" + n2 : (n2 < 1000 ? "000000" + n2 : (n2 < 10000 ? "00000" + n2 : (n2 < 100000 ? "0000" + n2 : (n2 < 1000000 ? "000" + n2 : (n2 < 10000000 ? "00" + n2 : (n2 < 100000000 ? "0" + n2 : Integer.toString(n2))))))));
        if (n3 < 9) {
            string = string.substring(0, n3);
        }
        return string;
    }

    public static String formatTZ(int n2) {
        int n3 = Math.abs(n2 / 60);
        int n4 = Math.abs(n2 % 60);
        if (n2 >= 0) {
            return "+" + DateUtil.format2(n3) + ":" + DateUtil.format2(n4);
        }
        return "-" + DateUtil.format2(n3) + ":" + DateUtil.format2(n4);
    }

    public static String formatYear(int n2) {
        if (n2 >= 0) {
            if (n2 < 10) {
                return "000" + n2;
            }
            if (n2 < 100) {
                return "00" + n2;
            }
            if (n2 < 1000) {
                return "0" + n2;
            }
            return Integer.toString(n2);
        }
        if (n2 > -10) {
            return "-000" + -n2;
        }
        if (n2 > -100) {
            return "-00" + -n2;
        }
        if (n2 > -1000) {
            return "-0" + -n2;
        }
        return Integer.toString(n2);
    }

    public static String format2(int n2) {
        if (n2 < 10) {
            return "0" + n2;
        }
        return Integer.toString(n2);
    }

    public static boolean checkDate(int n2, int n3, int n4) {
        if (n2 > 9999 || n2 < -4712 || n3 > 12 || n3 < 1) {
            return false;
        }
        int n5 = DateUtil.getDaysOfMonth(n2, n3);
        return n4 <= n5 && n4 >= 1;
    }

    public static boolean isLeapYear(int n2) {
        return n2 % 4 == 0 && n2 % 100 != 0 || n2 % 400 == 0;
    }

    public static int getDaysOfMonth(int n2, int n3) {
        switch (n3) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                return DateUtil.isLeapYear(n2) ? 29 : 28;
            }
        }
        return 0;
    }

    public static String formatDate(Date date, int n2) {
        String string = null;
        int n3 = date.getYear();
        int n4 = date.getMonth();
        String string2 = DateUtil.getStrFromInt(date.getDate());
        String string3 = DateUtil.getStrFromInt(date.getHours());
        String string4 = DateUtil.getStrFromInt(date.getMinutes());
        String string5 = DateUtil.getStrFromInt(date.getSeconds());
        switch (n2) {
            case 1: {
                string = n3 + 1900 + "-" + DateUtil.getStrFromInt(n4 + 1) + "-" + string2;
                break;
            }
            case 2: {
                string = n3 + 1900 + "-" + DateUtil.getStrFromInt(n4 + 1) + "-" + string2 + " " + string3 + ":" + string4 + ":" + string5;
                break;
            }
            case 3: {
                string = n3 + 1900 + "_" + DateUtil.getStrFromInt(n4 + 1) + "_" + string2 + "_" + string3 + "_" + string4 + "_" + string5;
                break;
            }
            default: {
                string = date.toString();
            }
        }
        return string;
    }

    private static String getStrFromInt(int n2) {
        return n2 < 10 ? "0" + n2 : String.valueOf(n2);
    }

    public static void main(String[] stringArray) {
    }
}

