/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.execute.branch;

import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.server.cluster.raft.execute.AbstractRaftMsgExecute;
import org.apache.seata.server.cluster.raft.sync.msg.RaftBaseMsg;
import org.apache.seata.server.cluster.raft.sync.msg.RaftBranchSessionSyncMsg;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.storage.raft.session.RaftSessionManager;

public class UpdateBranchSessionExecute
extends AbstractRaftMsgExecute {
    public Boolean execute(RaftBaseMsg syncMsg) throws Throwable {
        String xid;
        RaftBranchSessionSyncMsg sessionSyncMsg = (RaftBranchSessionSyncMsg)syncMsg;
        RaftSessionManager raftSessionManager = (RaftSessionManager)SessionHolder.getRootSessionManager((String)sessionSyncMsg.getGroup());
        GlobalSession globalSession = raftSessionManager.findGlobalSession(xid = sessionSyncMsg.getBranchSession().getXid());
        if (globalSession == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("The transaction corresponding to the XID: {} does not exist, which may cause a two-phase concurrency issue, msg type: {}", (Object)xid, (Object)syncMsg.getMsgType());
            }
            return false;
        }
        long branchId = sessionSyncMsg.getBranchSession().getBranchId();
        BranchSession branchSession = globalSession.getBranch(branchId);
        if (branchSession == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("The branch session corresponding to the branchId: {} does not exist, which may cause a two-phase concurrency issue, msg type: {}", (Object)sessionSyncMsg.getBranchSession().getBranchId(), (Object)syncMsg.getMsgType());
            }
            return false;
        }
        BranchStatus status = BranchStatus.get((int)sessionSyncMsg.getBranchSession().getStatus());
        branchSession.setStatus(status);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("update branch: {} , status: {}", (Object)branchSession.getBranchId(), (Object)branchSession.getStatus());
        }
        return true;
    }
}

