/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.seata.common.result.SingleResult;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.server.console.exception.ConsoleException;
import org.apache.seata.server.console.impl.AbstractService;
import org.apache.seata.server.console.service.GlobalSessionService;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;

public abstract class AbstractGlobalService
extends AbstractService
implements GlobalSessionService {
    public SingleResult<Void> deleteGlobalSession(String xid) {
        GlobalSession globalSession = this.checkGlobalSession(xid);
        GlobalStatus globalStatus = globalSession.getStatus();
        if (FAIL_STATUS.contains(globalStatus) || RETRY_STATUS.contains(globalStatus) || FINISH_STATUS.contains(globalStatus) || GlobalStatus.Deleting.equals((Object)globalStatus) || GlobalStatus.StopCommitOrCommitRetry.equals((Object)globalStatus) || GlobalStatus.StopRollbackOrRollbackRetry.equals((Object)globalStatus)) {
            try {
                if (!GlobalStatus.Deleting.equals((Object)globalStatus)) {
                    globalSession.changeGlobalStatus(GlobalStatus.Deleting);
                }
                List branchSessions = globalSession.getBranchSessions();
                ArrayList iteratorBranchSessions = new ArrayList(branchSessions);
                for (BranchSession branchSession : iteratorBranchSessions) {
                    if (this.doDeleteBranch(globalSession, branchSession)) continue;
                    return SingleResult.failure((String)"Delete branch fail, please try again");
                }
                globalSession.end();
                return SingleResult.success(null);
            }
            catch (Exception e) {
                throw new ConsoleException((Throwable)e, String.format("delete global session fail, xid:%s", xid));
            }
        }
        throw new IllegalArgumentException("current global transaction status is not support deleted");
    }

    public SingleResult<Void> forceDeleteGlobalSession(String xid) {
        GlobalSession globalSession = this.checkGlobalSession(xid);
        GlobalStatus globalStatus = globalSession.getStatus();
        try {
            if (!GlobalStatus.Deleting.equals((Object)globalStatus)) {
                globalSession.changeGlobalStatus(GlobalStatus.Deleting);
            }
            List branchSessions = globalSession.getBranchSessions();
            ArrayList iteratorBranchSessions = new ArrayList(branchSessions);
            for (BranchSession branchSession : iteratorBranchSessions) {
                if (this.doForceDeleteBranch(globalSession, branchSession)) continue;
                return SingleResult.failure((String)"Force delete branch fail, please try again");
            }
            globalSession.end();
            return SingleResult.success(null);
        }
        catch (Exception e) {
            throw new ConsoleException((Throwable)e, String.format("force delete global session fail, xid:%s", xid));
        }
    }

    public SingleResult<Void> stopGlobalRetry(String xid) {
        GlobalStatus newStatus;
        GlobalSession globalSession = this.checkGlobalSession(xid);
        GlobalStatus globalStatus = globalSession.getStatus();
        Object object = COMMIT_ING_STATUS.contains(globalStatus) ? GlobalStatus.StopCommitOrCommitRetry : (newStatus = RETRY_ROLLBACK_STATUS.contains(globalStatus) || ROLLBACK_ING_STATUS.contains(globalStatus) ? GlobalStatus.StopRollbackOrRollbackRetry : null);
        if (newStatus == null) {
            throw new IllegalArgumentException("current global transaction status is not support stop");
        }
        try {
            globalSession.changeGlobalStatus(newStatus);
            return SingleResult.success();
        }
        catch (Exception e) {
            throw new ConsoleException((Throwable)e, String.format("Stop global session retry fail, xid:%s", xid));
        }
    }

    public SingleResult<Void> startGlobalRetry(String xid) {
        GlobalStatus newStatus;
        GlobalSession globalSession = this.checkGlobalSession(xid);
        GlobalStatus globalStatus = globalSession.getStatus();
        Object object = GlobalStatus.StopCommitOrCommitRetry.equals((Object)globalStatus) ? GlobalStatus.CommitRetrying : (newStatus = GlobalStatus.StopRollbackOrRollbackRetry.equals((Object)globalStatus) ? GlobalStatus.RollbackRetrying : null);
        if (newStatus == null) {
            throw new IllegalArgumentException("current global transaction status is not support start");
        }
        try {
            globalSession.changeGlobalStatus(newStatus);
            return SingleResult.success();
        }
        catch (Exception e) {
            throw new ConsoleException((Throwable)e, String.format("Start global session retry fail, xid:%s", xid));
        }
    }

    public SingleResult<Void> sendCommitOrRollback(String xid) {
        GlobalSession globalSession = this.checkGlobalSession(xid);
        GlobalStatus globalStatus = globalSession.getStatus();
        try {
            boolean res;
            if (RETRY_COMMIT_STATUS.contains(globalStatus) || GlobalStatus.Committing.equals((Object)globalStatus) || GlobalStatus.StopCommitOrCommitRetry.equals((Object)globalStatus)) {
                res = this.doRetryCommitGlobal(globalSession);
            } else if (RETRY_ROLLBACK_STATUS.contains(globalStatus) || GlobalStatus.Rollbacking.equals((Object)globalStatus) || GlobalStatus.StopRollbackOrRollbackRetry.equals((Object)globalStatus)) {
                res = this.doRetryRollbackGlobal(globalSession);
            } else {
                throw new IllegalArgumentException("current global transaction status is not support to do");
            }
            return res ? SingleResult.success() : SingleResult.failure((String)"Commit or rollback fail, please try again");
        }
        catch (Exception e) {
            throw new ConsoleException((Throwable)e, String.format("send commit or rollback to rm fail, xid:%s", xid));
        }
    }

    public SingleResult<Void> changeGlobalStatus(String xid) {
        GlobalSession globalSession = this.checkGlobalSession(xid);
        GlobalStatus globalStatus = globalSession.getStatus();
        try {
            if (FAIL_COMMIT_STATUS.contains(globalStatus)) {
                boolean committed = this.doRetryCommitGlobal(globalSession);
                return committed ? SingleResult.success() : SingleResult.failure((String)"Commit fail, please try again");
            }
            if (FAIL_ROLLBACK_STATUS.contains(globalStatus)) {
                boolean rollbacked = this.doRetryRollbackGlobal(globalSession);
                return rollbacked ? SingleResult.success() : SingleResult.failure((String)"Rollback fail, please try again");
            }
        }
        catch (Exception e) {
            throw new ConsoleException((Throwable)e, String.format("change global status fail, xid:%s", xid));
        }
        throw new IllegalArgumentException("current global transaction status is not support to change");
    }
}

