/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.raft.store;

import com.alipay.sofa.jraft.Closure;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.metadata.ClusterRole;
import org.apache.seata.common.metadata.Instance;
import org.apache.seata.core.store.MappingDO;
import org.apache.seata.discovery.registry.MultiRegistryFactory;
import org.apache.seata.discovery.registry.RegistryService;
import org.apache.seata.server.cluster.raft.RaftServerManager;
import org.apache.seata.server.cluster.raft.sync.msg.RaftSyncMsgType;
import org.apache.seata.server.cluster.raft.sync.msg.RaftVGroupSyncMsg;
import org.apache.seata.server.cluster.raft.util.RaftTaskUtil;
import org.apache.seata.server.store.VGroupMappingStoreManager;

@LoadLevel(name="raft")
public class RaftVGroupMappingStoreManager
implements VGroupMappingStoreManager {
    private static final Map<String, Map<String, MappingDO>> VGROUP_MAPPING = new ConcurrentHashMap();

    public boolean localAddVGroup(MappingDO mappingDO) {
        return VGROUP_MAPPING.computeIfAbsent(mappingDO.getUnit(), k -> new HashMap()).put(mappingDO.getVGroup(), mappingDO) == null;
    }

    public void localAddVGroups(Map<String, MappingDO> vGroups, String unit) {
        VGROUP_MAPPING.computeIfAbsent(unit, k -> new HashMap()).putAll(vGroups);
    }

    public boolean addVGroup(MappingDO mappingDO) {
        CompletableFuture completableFuture = new CompletableFuture();
        Closure closure = status -> {
            if (status.isOk()) {
                completableFuture.complete(this.localAddVGroup(mappingDO));
            } else {
                completableFuture.complete(false);
            }
        };
        RaftVGroupSyncMsg raftVGroupSyncMsg = new RaftVGroupSyncMsg(mappingDO, RaftSyncMsgType.ADD_VGROUP_MAPPING);
        try {
            RaftTaskUtil.createTask((Closure)closure, (Object)raftVGroupSyncMsg, completableFuture);
            return (Boolean)completableFuture.get();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public boolean removeVGroup(String vGroup) {
        CompletableFuture completableFuture = new CompletableFuture();
        Closure closure = status -> {
            if (status.isOk()) {
                completableFuture.complete(this.localRemoveVGroup(vGroup));
            } else {
                completableFuture.complete(false);
            }
        };
        MappingDO mappingDO = new MappingDO();
        mappingDO.setVGroup(vGroup);
        RaftVGroupSyncMsg raftVGroupSyncMsg = new RaftVGroupSyncMsg(mappingDO, RaftSyncMsgType.REMOVE_VGROUP_MAPPING);
        try {
            RaftTaskUtil.createTask((Closure)closure, (Object)raftVGroupSyncMsg, completableFuture);
            return (Boolean)completableFuture.get();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public boolean localRemoveVGroup(String vGroup) {
        VGROUP_MAPPING.forEach((unit, vgroup) -> {
            MappingDO cfr_ignored_0 = (MappingDO)vgroup.remove(vGroup);
        });
        return true;
    }

    public Map<String, Object> loadVGroups() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        VGROUP_MAPPING.forEach((unit, vgroup) -> {
            for (String group : vgroup.keySet()) {
                result.put(group, unit);
            }
        });
        return result;
    }

    public Map<String, MappingDO> loadVGroupsByUnit(String unit) {
        return VGROUP_MAPPING.getOrDefault(unit, new HashMap());
    }

    public void clear(String unit) {
        VGROUP_MAPPING.remove(unit);
    }

    public Map<String, Object> readVGroups() {
        return this.loadVGroups();
    }

    public void notifyMapping() {
        Instance instance = Instance.getInstance();
        Map map = this.readVGroups();
        instance.addMetadata("vGroup", (Object)map);
        try {
            for (String group : RaftServerManager.groups()) {
                Instance node = instance.clone();
                node.setRole(RaftServerManager.isLeader((String)group) ? ClusterRole.LEADER : ClusterRole.FOLLOWER);
                Instance.getInstances().add(node);
                for (RegistryService registryService : MultiRegistryFactory.getInstances()) {
                    registryService.register(node);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("vGroup mapping relationship notified failed! ", e);
        }
        finally {
            Instance.getInstances().clear();
        }
    }
}

