/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.store;

import com.alibaba.druid.pool.DruidDataSource;
import javax.sql.DataSource;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.store.db.AbstractDataSourceProvider;

@LoadLevel(name="druid")
public class DruidDataSourceProvider
extends AbstractDataSourceProvider {
    public DataSource doGenerate() {
        DruidDataSource ds = new DruidDataSource();
        ds.setDriverClassName(this.getDriverClassName());
        ds.setDriverClassLoader(this.getDriverClassLoader());
        ds.setUrl(this.getUrl());
        ds.setUsername(this.getUser());
        ds.setPassword(this.getPassword());
        ds.setInitialSize(this.getMinConn());
        ds.setMaxActive(this.getMaxConn());
        ds.setMinIdle(this.getMinConn());
        ds.setMaxWait(this.getMaxWait().longValue());
        long timeBetweenEvictionRunsMillis = CONFIG.getLong("store.db.druid.timeBetweenEvictionRunsMillis", 120000L);
        ds.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis < 0L ? 120000L : timeBetweenEvictionRunsMillis);
        long minEvictableIdleTimeMillis = CONFIG.getLong("store.db.druid.minEvictableIdleTimeMillis", 300000L);
        ds.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis < 0L ? 300000L : minEvictableIdleTimeMillis);
        boolean testWhileIdle = CONFIG.getBoolean("store.db.druid.testWhileIdle", true);
        ds.setTestWhileIdle(testWhileIdle);
        boolean testOnBorrow = CONFIG.getBoolean("store.db.druid.testOnBorrow", false);
        ds.setTestOnBorrow(testOnBorrow);
        boolean keepAlive = CONFIG.getBoolean("store.db.druid.keepAlive", false);
        ds.setKeepAlive(keepAlive);
        ds.setPoolPreparedStatements(true);
        ds.setMaxPoolPreparedStatementPerConnectionSize(20);
        ds.setValidationQuery(this.getValidationQuery(this.getDBType()));
        ds.setDefaultAutoCommit(true);
        ds.setUseOracleImplicitCache(false);
        ds.setDefaultTransactionIsolation(Integer.valueOf(2));
        return ds;
    }
}

