/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.store;

import org.apache.seata.common.store.LockMode;
import org.apache.seata.common.store.SessionMode;
import org.apache.seata.common.store.StoreMode;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.server.env.ContainerHelper;
import org.apache.seata.server.storage.file.FlushDiskMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class StoreConfig {
    private static final Configuration CONFIGURATION = ConfigurationFactory.getInstance();
    private static StoreMode storeMode;
    private static SessionMode sessionMode;
    private static LockMode lockMode;
    private static final int DEFAULT_MAX_BRANCH_SESSION_SIZE = 16384;
    private static final int DEFAULT_MAX_GLOBAL_SESSION_SIZE = 512;
    private static final int DEFAULT_WRITE_BUFFER_SIZE = 16384;

    public static void setStartupParameter(String storeMode, String sessionMode, String lockMode) {
        if (StringUtils.isNotBlank((String)storeMode)) {
            StoreConfig.storeMode = StoreMode.get((String)storeMode);
        }
        if (StringUtils.isNotBlank((String)sessionMode)) {
            StoreConfig.sessionMode = SessionMode.get((String)sessionMode);
        }
        if (StringUtils.isNotBlank((String)lockMode)) {
            StoreConfig.lockMode = LockMode.get((String)lockMode);
        }
    }

    public static int getMaxBranchSessionSize() {
        return CONFIGURATION.getInt("store.file.maxBranchSessionSize", 16384);
    }

    public static int getMaxGlobalSessionSize() {
        return CONFIGURATION.getInt("store.file.maxGlobalSessionSize", 512);
    }

    public static int getFileWriteBufferCacheSize() {
        return CONFIGURATION.getInt("store.file.fileWriteBufferCacheSize", 16384);
    }

    public static FlushDiskMode getFlushDiskMode() {
        return FlushDiskMode.findDiskMode((String)CONFIGURATION.getConfig("store.file.flushDiskMode"));
    }

    private static StoreMode getStoreMode() {
        if (null != storeMode) {
            return storeMode;
        }
        String storeModeEnv = ContainerHelper.getStoreMode();
        if (StringUtils.isNotBlank((String)storeModeEnv)) {
            return StoreMode.get((String)storeModeEnv);
        }
        String storeModeConfig = CONFIGURATION.getConfig("store.mode", "file");
        return StoreMode.get((String)storeModeConfig);
    }

    public static SessionMode getSessionMode() {
        if (null != sessionMode) {
            return sessionMode;
        }
        String sessionModeEnv = ContainerHelper.getSessionStoreMode();
        if (StringUtils.isNotBlank((String)sessionModeEnv)) {
            return SessionMode.get((String)sessionModeEnv);
        }
        String sessionModeConfig = CONFIGURATION.getConfig("store.session.mode");
        if (StringUtils.isNotBlank((String)sessionModeConfig)) {
            return SessionMode.get((String)sessionModeConfig);
        }
        return SessionMode.get((String)StoreConfig.getStoreMode().name());
    }

    public static LockMode getLockMode() {
        if (null != lockMode) {
            return lockMode;
        }
        String lockModeEnv = ContainerHelper.getLockStoreMode();
        if (StringUtils.isNotBlank((String)lockModeEnv)) {
            return LockMode.get((String)lockModeEnv);
        }
        String lockModeConfig = CONFIGURATION.getConfig("store.lock.mode");
        if (StringUtils.isNotBlank((String)lockModeConfig)) {
            return LockMode.get((String)lockModeConfig);
        }
        return LockMode.get((String)StoreConfig.getStoreMode().name());
    }
}

