/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.remote.CommandError;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.UnsupportedNamedTypeException;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class UnsupportedNamedTypeError
implements CommandError,
ComparableByContent<UnsupportedNamedTypeError> {
    private final String typeName;
    public static SerializationHandle<UnsupportedNamedTypeError> SERIALIZATION_HANDLE = new SerializationHandle<UnsupportedNamedTypeError>(){

        @Override
        public <S> UnsupportedNamedTypeError deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            String typeName = adapter.readString(input);
            return new UnsupportedNamedTypeError(typeName);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, UnsupportedNamedTypeError error, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeString(output, error.typeName);
        }

        @Override
        public int getTypeId() {
            return 19;
        }

        @Override
        public Class<UnsupportedNamedTypeError> getSerializedType() {
            return UnsupportedNamedTypeError.class;
        }

        @Override
        public UnsupportedNamedTypeError fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            String typeName = (String)snapshot.get("typeName");
            return new UnsupportedNamedTypeError(typeName);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(UnsupportedNamedTypeError error, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("typeName", error.typeName);
            return result;
        }

        @Override
        public String getTypeName() {
            return "UnsupportedNamedTypeError";
        }
    };

    public UnsupportedNamedTypeError(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public RuntimeException asException() {
        return new UnsupportedNamedTypeException(this.typeName);
    }

    @Override
    public boolean equalsByContent(UnsupportedNamedTypeError other) {
        return other.typeName.equals(this.typeName);
    }
}

