/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.test.DirectoryUtils;
import org.apache.curator.test.InstanceSpec;
import org.apache.curator.test.QuorumConfigBuilder;
import org.apache.curator.test.TestingQuorumPeerMain;
import org.apache.curator.test.TestingZooKeeperMain;
import org.apache.curator.test.ZooKeeperMainFace;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingZooKeeperServer
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TestingZooKeeperServer.class);
    private final QuorumConfigBuilder configBuilder;
    private final int thisInstanceIndex;
    private volatile ZooKeeperMainFace main;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);

    public TestingZooKeeperServer(QuorumConfigBuilder configBuilder) {
        this(configBuilder, 0);
    }

    public TestingZooKeeperServer(QuorumConfigBuilder configBuilder, int thisInstanceIndex) {
        System.setProperty("zookeeper.jmx.log4j.disable", "true");
        this.configBuilder = configBuilder;
        this.thisInstanceIndex = thisInstanceIndex;
        this.main = this.isCluster() ? new TestingQuorumPeerMain() : new TestingZooKeeperMain();
    }

    private boolean isCluster() {
        return this.configBuilder.size() > 1;
    }

    public QuorumPeer getQuorumPeer() {
        if (this.isCluster()) {
            return ((TestingQuorumPeerMain)this.main).getTestingQuorumPeer();
        }
        throw new UnsupportedOperationException();
    }

    public Collection<InstanceSpec> getInstanceSpecs() {
        return this.configBuilder.getInstanceSpecs();
    }

    public void kill() {
        this.main.kill();
        this.state.set(State.STOPPED);
    }

    public void restart() throws Exception {
        if (this.state.get() == State.CLOSED) {
            throw new IllegalStateException("Cannot restart a closed instance");
        }
        if (this.state.get() == State.STARTED) {
            this.stop();
        }
        this.state.set(State.LATENT);
        this.main = this.isCluster() ? new TestingQuorumPeerMain() : new TestingZooKeeperMain();
        this.start();
    }

    public void stop() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.STOPPED)) {
            this.main.close();
        }
    }

    public InstanceSpec getInstanceSpec() {
        return this.configBuilder.getInstanceSpec(this.thisInstanceIndex);
    }

    @Override
    public void close() throws IOException {
        this.stop();
        if (this.state.compareAndSet(State.STOPPED, State.CLOSED)) {
            this.configBuilder.close();
            InstanceSpec spec = this.getInstanceSpec();
            if (spec.deleteDataDirectoryOnClose()) {
                DirectoryUtils.deleteRecursively(spec.getDataDirectory());
            }
        }
    }

    public void start() throws Exception {
        if (!this.state.compareAndSet(State.LATENT, State.STARTED)) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    QuorumPeerConfig config = TestingZooKeeperServer.this.configBuilder.buildConfig(TestingZooKeeperServer.this.thisInstanceIndex);
                    TestingZooKeeperServer.this.main.runFromConfig(config);
                }
                catch (Exception e) {
                    logger.error(String.format("From testing server (random state: %s) for instance: %s", String.valueOf(TestingZooKeeperServer.this.configBuilder.isFromRandom()), TestingZooKeeperServer.this.getInstanceSpec()), (Throwable)e);
                }
            }
        }).start();
        this.main.blockUntilStarted();
    }

    private static enum State {
        LATENT,
        STARTED,
        STOPPED,
        CLOSED;

    }
}

