/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.console.security;

import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.seata.console.security.CustomUserDetails;
import org.apache.seata.console.security.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class CustomUserDetailsServiceImpl
implements UserDetailsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomUserDetailsServiceImpl.class);
    @Value(value="${console.user.username:seata}")
    private String username;
    @Value(value="${console.user.password:}")
    private String password;
    private User user;

    @PostConstruct
    public void init() {
        if (!this.password.isEmpty()) {
            this.user = new User(this.username, new BCryptPasswordEncoder().encode((CharSequence)this.password));
            return;
        }
        this.password = this.generateRandomPassword();
        LOGGER.info("No password was configured. A random password has been generated for security purposes. You may either:\n1. Use the auto-generated password: [{}]\n2. Set a custom password in the configuration.", (Object)this.password);
        this.user = new User(this.username, new BCryptPasswordEncoder().encode((CharSequence)this.password));
    }

    private String generateRandomPassword() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 8);
    }

    public UserDetails loadUserByUsername(String userName) throws UsernameNotFoundException {
        if (!this.user.getUsername().equals(userName)) {
            throw new UsernameNotFoundException(userName);
        }
        return new CustomUserDetails(this.user);
    }
}

