/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.console.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.SignatureException;
import java.security.Key;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtTokenUtils.class);
    private static final String AUTHORITIES_KEY = "auth";
    @Value(value="${seata.security.secretKey}")
    private String secretKey;
    @Value(value="${seata.security.tokenValidityInMilliseconds}")
    private long tokenValidityInMilliseconds;

    public String createToken(Authentication authentication) {
        long now = new Date().getTime();
        Date expirationDate = new Date(now + this.tokenValidityInMilliseconds);
        SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])Decoders.BASE64.decode((Object)this.secretKey), SignatureAlgorithm.HS256.getJcaName());
        return Jwts.builder().setSubject(authentication.getName()).claim(AUTHORITIES_KEY, (Object)"").setExpiration(expirationDate).signWith((Key)secretKeySpec, SignatureAlgorithm.HS256).compact();
    }

    public Authentication getAuthentication(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.secretKey).parseClaimsJws(token).getBody();
        List authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)((String)claims.get((Object)AUTHORITIES_KEY)));
        User principal = new User(claims.getSubject(), "", (Collection)authorities);
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)"", (Collection)authorities);
    }

    public boolean validateToken(String token) {
        try {
            Jwts.parser().setSigningKey(this.secretKey).parseClaimsJws(token);
            return true;
        }
        catch (SignatureException e) {
            LOGGER.warn("Invalid JWT signature.");
            LOGGER.trace("Invalid JWT signature trace: {}", (Throwable)e);
        }
        catch (MalformedJwtException e) {
            LOGGER.warn("Invalid JWT token.");
            LOGGER.trace("Invalid JWT token trace: {}", (Throwable)e);
        }
        catch (ExpiredJwtException e) {
            LOGGER.warn("Expired JWT token.");
            LOGGER.trace("Expired JWT token trace: {}", (Throwable)e);
        }
        catch (UnsupportedJwtException e) {
            LOGGER.warn("Unsupported JWT token.");
            LOGGER.trace("Unsupported JWT token trace: {}", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("JWT token compact of handler are invalid.");
            LOGGER.trace("JWT token compact of handler are invalid trace: {}", (Throwable)e);
        }
        return false;
    }
}

