/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.store.db.sql.log;

import org.apache.seata.core.store.db.sql.log.LogStoreSqls;

public abstract class AbstractLogStoreSqls
implements LogStoreSqls {
    public static final String GLOBAL_TABLE_PLACEHOLD = " #global_table# ";
    public static final String BRANCH_TABLE_PLACEHOLD = " #branch_table# ";
    public static final String PRAMETER_PLACEHOLD = " #PRAMETER_PLACEHOLD# ";
    public static final String WHERE_PLACEHOLD = " #where# ";
    public static final String ALL_GLOBAL_COLUMNS = "xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified";
    protected static final String ALL_BRANCH_COLUMNS = "xid, transaction_id, branch_id, resource_group_id, resource_id, branch_type, status, client_id, application_data, gmt_create, gmt_modified";
    public static final String DELETE_GLOBAL_TRANSACTION = "delete from  #global_table#  where xid = ?";
    public static final String QUERY_GLOBAL_TRANSACTION = "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified  from  #global_table#  where xid = ?";
    public static final String QUERY_GLOBAL_TRANSACTION_BY_ID = "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified  from  #global_table#  where transaction_id = ?";
    public static final String DELETE_BRANCH_TRANSACTION_BY_BRANCH_ID = "delete from  #branch_table#  where xid = ?   and branch_id = ?";
    public static final String DELETE_BRANCH_TRANSACTION_BY_XID = "delete from  #branch_table#  where xid = ?";
    public static final String QUERY_BRANCH_TRANSACTION = "select xid, transaction_id, branch_id, resource_group_id, resource_id, branch_type, status, client_id, application_data, gmt_create, gmt_modified  from  #branch_table#  where xid = ? order by gmt_create asc";
    public static final String QUERY_BRANCH_TRANSACTION_XIDS = "select xid, transaction_id, branch_id, resource_group_id, resource_id, branch_type, status, client_id, application_data, gmt_create, gmt_modified  from  #branch_table#  where xid in ( #PRAMETER_PLACEHOLD# ) order by gmt_create asc";
    public static final String QUERY_MAX_TRANS_ID = "select max(transaction_id)  from  #global_table#  where transaction_id < ?   and transaction_id > ?";
    public static final String QUERY_MAX_BTANCH_ID = "select max(branch_id)  from  #branch_table#  where branch_id < ?   and branch_id > ?";
    public static final String QUERY_ALL_BRANCH_WITH_XID = "select xid, transaction_id, branch_id, resource_group_id, resource_id, branch_type, status, client_id, application_data, gmt_create, gmt_modified from  #branch_table#  #where#  order by gmt_create desc";
    private static final String QUERY_ALL_GLOBAL_SESSION = "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified from  #global_table#  #where#  order by gmt_create desc ";

    @Override
    public String getAllGlobalSessionSql(String globalTable, String whereCondition) {
        return QUERY_ALL_GLOBAL_SESSION.replace(GLOBAL_TABLE_PLACEHOLD, globalTable).replace(WHERE_PLACEHOLD, whereCondition);
    }

    @Override
    public String getAllBranchSessionSQL(String branchTable, String whereCondition) {
        return QUERY_ALL_BRANCH_WITH_XID.replace(BRANCH_TABLE_PLACEHOLD, branchTable).replace(WHERE_PLACEHOLD, whereCondition);
    }

    @Override
    public abstract String getInsertGlobalTransactionSQL(String var1);

    @Override
    public abstract String getUpdateGlobalTransactionStatusSQL(String var1);

    @Override
    public String getDeleteGlobalTransactionSQL(String globalTable) {
        return DELETE_GLOBAL_TRANSACTION.replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
    }

    @Override
    public String getQueryGlobalTransactionSQL(String globalTable) {
        return QUERY_GLOBAL_TRANSACTION.replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
    }

    @Override
    public String getQueryGlobalTransactionSQLByTransactionId(String globalTable) {
        return QUERY_GLOBAL_TRANSACTION_BY_ID.replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
    }

    @Override
    public abstract String getQueryGlobalTransactionSQLByStatus(String var1, String var2);

    @Override
    public abstract String getQueryGlobalTransactionForRecoverySQL(String var1);

    @Override
    public abstract String getInsertBranchTransactionSQL(String var1);

    @Override
    public abstract String getUpdateBranchTransactionStatusSQL(String var1);

    @Override
    public String getDeleteBranchTransactionByBranchIdSQL(String branchTable) {
        return DELETE_BRANCH_TRANSACTION_BY_BRANCH_ID.replace(BRANCH_TABLE_PLACEHOLD, branchTable);
    }

    @Override
    public String getDeleteBranchTransactionByXId(String branchTable) {
        return DELETE_BRANCH_TRANSACTION_BY_XID.replace(BRANCH_TABLE_PLACEHOLD, branchTable);
    }

    @Override
    public String getQueryBranchTransaction(String branchTable) {
        return QUERY_BRANCH_TRANSACTION.replace(BRANCH_TABLE_PLACEHOLD, branchTable);
    }

    @Override
    public String getQueryBranchTransaction(String branchTable, String paramsPlaceHolder) {
        return QUERY_BRANCH_TRANSACTION_XIDS.replace(BRANCH_TABLE_PLACEHOLD, branchTable).replace(PRAMETER_PLACEHOLD, paramsPlaceHolder);
    }

    @Override
    public String getQueryGlobalMax(String globalTable) {
        return QUERY_MAX_TRANS_ID.replace(GLOBAL_TABLE_PLACEHOLD, globalTable);
    }

    @Override
    public String getQueryBranchMax(String branchTable) {
        return QUERY_MAX_BTANCH_ID.replace(BRANCH_TABLE_PLACEHOLD, branchTable);
    }
}

