/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.metrics.registry.compact;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.seata.metrics.Clock;
import org.apache.seata.metrics.Counter;
import org.apache.seata.metrics.Id;
import org.apache.seata.metrics.Measurement;
import org.apache.seata.metrics.SystemClock;

public class CompactCounter
implements Counter {
    private final Id id;
    private final AtomicLong counter;
    private final Clock clock;

    public CompactCounter(Id id) {
        this(id, SystemClock.INSTANCE);
    }

    public CompactCounter(Id id, Clock clock) {
        this.id = id;
        this.counter = new AtomicLong(0L);
        this.clock = clock;
    }

    public Id getId() {
        return this.id;
    }

    public long increase(long value) {
        return this.counter.addAndGet(value);
    }

    public long decrease(long value) {
        return this.increase(-1L * value);
    }

    public long get() {
        return this.counter.get();
    }

    public Iterable<Measurement> measure() {
        return Collections.singletonList(new Measurement(this.id, this.clock.getCurrentMilliseconds(), (double)this.counter.get()));
    }
}

