/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.util;

import com.alipay.sofa.registry.client.provider.DefaultServerNode;
import com.alipay.sofa.registry.client.remoting.ServerNode;
import com.alipay.sofa.registry.client.util.StringUtils;
import java.util.Properties;

public class ServerNodeParser {
    private static final char COLON = ':';
    private static final char EQUAL = '=';
    private static final char AND = '&';
    private static final char QUES = '?';

    public static ServerNode parse(String url) {
        int i;
        if (StringUtils.isBlank(url)) {
            throw new IllegalArgumentException("Illegal format address string [" + url + "], should not be blank! ");
        }
        String ip = null;
        String port = null;
        Properties properties = null;
        int size = url.length();
        int pos = 0;
        for (i = 0; i < size; ++i) {
            if (':' == url.charAt(i)) {
                ip = url.substring(pos, i);
                pos = i;
                if (i != size - 1) break;
                throw new IllegalArgumentException("Illegal format address string [" + url + "], should not end with COLON[:]! ");
            }
            if (i != size - 1) continue;
            throw new IllegalArgumentException("Illegal format address string [" + url + "], must have one COLON[:]! ");
        }
        for (i = pos; i < size; ++i) {
            if ('?' == url.charAt(i)) {
                port = url.substring(pos + 1, i);
                pos = i;
                if (i != size - 1) break;
                throw new IllegalArgumentException("Illegal format address string [" + url + "], should not end with QUES[?]! ");
            }
            if (i != size - 1) continue;
            port = url.substring(pos + 1, i + 1);
            pos = size;
        }
        if (pos < size - 1) {
            properties = new Properties();
            while (pos < size - 1) {
                int i2;
                String key = null;
                String value = null;
                for (i2 = pos; i2 < size; ++i2) {
                    if ('=' == url.charAt(i2)) {
                        key = url.substring(pos + 1, i2);
                        pos = i2;
                        if (i2 != size - 1) break;
                        throw new IllegalArgumentException("Illegal format address string [" + url + "], should not end with EQUAL[=]! ");
                    }
                    if (i2 != size - 1) continue;
                    throw new IllegalArgumentException("Illegal format address string [" + url + "], must have one EQUAL[=]! ");
                }
                for (i2 = pos; i2 < size; ++i2) {
                    if ('&' == url.charAt(i2)) {
                        value = url.substring(pos + 1, i2);
                        pos = i2;
                        if (i2 != size - 1) break;
                        throw new IllegalArgumentException("Illegal format address string [" + url + "], should not end with AND[&]! ");
                    }
                    if (i2 != size - 1) continue;
                    value = url.substring(pos + 1, i2 + 1);
                    pos = size;
                }
                properties.put(key, value);
            }
        }
        return new DefaultServerNode(url, ip, Integer.parseInt(port), properties);
    }
}

