/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.fury.AbstractThreadSafeFury;
import org.apache.fury.Fury;
import org.apache.fury.io.FuryInputStream;
import org.apache.fury.io.FuryReadableChannel;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.MemoryUtils;
import org.apache.fury.serializer.BufferCallback;
import org.apache.fury.util.LoaderBinding;

@ThreadSafe
public class ThreadLocalFury
extends AbstractThreadSafeFury {
    private final ThreadLocal<MemoryBuffer> bufferLocal = ThreadLocal.withInitial(() -> MemoryUtils.buffer(32));
    private final ThreadLocal<LoaderBinding> bindingThreadLocal;
    private Consumer<Fury> factoryCallback = f -> {};
    private final WeakHashMap<LoaderBinding, Object> allFury = new WeakHashMap();

    public ThreadLocalFury(Function<ClassLoader, Fury> furyFactory) {
        this.bindingThreadLocal = ThreadLocal.withInitial(() -> {
            LoaderBinding binding = new LoaderBinding(furyFactory);
            binding.setBindingCallback(this.factoryCallback);
            binding.setClassLoader(Thread.currentThread().getContextClassLoader());
            this.allFury.put(binding, null);
            return binding;
        });
        Fury fury = this.bindingThreadLocal.get().get();
    }

    @Override
    protected void processCallback(Consumer<Fury> callback) {
        this.factoryCallback = this.factoryCallback.andThen(callback);
        for (LoaderBinding binding : this.allFury.keySet()) {
            binding.visitAllFury(callback);
            binding.setBindingCallback(this.factoryCallback);
        }
    }

    @Override
    public <R> R execute(Function<Fury, R> action) {
        Fury fury = this.bindingThreadLocal.get().get();
        return action.apply(fury);
    }

    @Override
    public byte[] serialize(Object obj) {
        MemoryBuffer buffer = this.bufferLocal.get();
        buffer.writerIndex(0);
        this.bindingThreadLocal.get().get().serialize(buffer, obj);
        return buffer.getBytes(0, buffer.writerIndex());
    }

    @Override
    public byte[] serialize(Object obj, BufferCallback callback) {
        MemoryBuffer buffer = this.bufferLocal.get();
        buffer.writerIndex(0);
        this.bindingThreadLocal.get().get().serialize(buffer, obj, callback);
        return buffer.getBytes(0, buffer.writerIndex());
    }

    @Override
    public MemoryBuffer serialize(Object obj, long address, int size) {
        return this.bindingThreadLocal.get().get().serialize(obj, address, size);
    }

    @Override
    public MemoryBuffer serialize(MemoryBuffer buffer, Object obj) {
        return this.bindingThreadLocal.get().get().serialize(buffer, obj);
    }

    @Override
    public MemoryBuffer serialize(MemoryBuffer buffer, Object obj, BufferCallback callback) {
        return this.bindingThreadLocal.get().get().serialize(buffer, obj, callback);
    }

    @Override
    public void serialize(OutputStream outputStream, Object obj) {
        this.bindingThreadLocal.get().get().serialize(outputStream, obj);
    }

    @Override
    public void serialize(OutputStream outputStream, Object obj, BufferCallback callback) {
        this.bindingThreadLocal.get().get().serialize(outputStream, obj, callback);
    }

    @Override
    public Object deserialize(byte[] bytes) {
        return this.bindingThreadLocal.get().get().deserialize(bytes);
    }

    @Override
    public Object deserialize(byte[] bytes, Iterable<MemoryBuffer> outOfBandBuffers) {
        return this.bindingThreadLocal.get().get().deserialize(bytes, outOfBandBuffers);
    }

    @Override
    public Object deserialize(long address, int size) {
        return this.bindingThreadLocal.get().get().deserialize(address, size);
    }

    @Override
    public Object deserialize(MemoryBuffer buffer) {
        return this.bindingThreadLocal.get().get().deserialize(buffer);
    }

    @Override
    public Object deserialize(ByteBuffer byteBuffer) {
        return this.bindingThreadLocal.get().get().deserialize(MemoryUtils.wrap(byteBuffer));
    }

    @Override
    public Object deserialize(MemoryBuffer buffer, Iterable<MemoryBuffer> outOfBandBuffers) {
        return this.bindingThreadLocal.get().get().deserialize(buffer, outOfBandBuffers);
    }

    @Override
    public Object deserialize(FuryInputStream inputStream) {
        return this.bindingThreadLocal.get().get().deserialize(inputStream);
    }

    @Override
    public Object deserialize(FuryInputStream inputStream, Iterable<MemoryBuffer> outOfBandBuffers) {
        return this.bindingThreadLocal.get().get().deserialize(inputStream, outOfBandBuffers);
    }

    @Override
    public Object deserialize(FuryReadableChannel channel) {
        return this.bindingThreadLocal.get().get().deserialize(channel);
    }

    @Override
    public Object deserialize(FuryReadableChannel channel, Iterable<MemoryBuffer> outOfBandBuffers) {
        return this.bindingThreadLocal.get().get().deserialize(channel, outOfBandBuffers);
    }

    @Override
    public byte[] serializeJavaObject(Object obj) {
        return this.bindingThreadLocal.get().get().serializeJavaObject(obj);
    }

    @Override
    public void serializeJavaObject(MemoryBuffer buffer, Object obj) {
        this.bindingThreadLocal.get().get().serializeJavaObject(buffer, obj);
    }

    @Override
    public void serializeJavaObject(OutputStream outputStream, Object obj) {
        this.bindingThreadLocal.get().get().serializeJavaObject(outputStream, obj);
    }

    @Override
    public <T> T deserializeJavaObject(byte[] data, Class<T> cls) {
        return this.bindingThreadLocal.get().get().deserializeJavaObject(data, cls);
    }

    @Override
    public <T> T deserializeJavaObject(MemoryBuffer buffer, Class<T> cls) {
        return this.bindingThreadLocal.get().get().deserializeJavaObject(buffer, cls);
    }

    @Override
    public <T> T deserializeJavaObject(FuryInputStream inputStream, Class<T> cls) {
        return this.bindingThreadLocal.get().get().deserializeJavaObject(inputStream, cls);
    }

    @Override
    public <T> T deserializeJavaObject(FuryReadableChannel channel, Class<T> cls) {
        return this.bindingThreadLocal.get().get().deserializeJavaObject(channel, cls);
    }

    @Override
    public byte[] serializeJavaObjectAndClass(Object obj) {
        return this.bindingThreadLocal.get().get().serializeJavaObjectAndClass(obj);
    }

    @Override
    public void serializeJavaObjectAndClass(MemoryBuffer buffer, Object obj) {
        this.bindingThreadLocal.get().get().serializeJavaObjectAndClass(buffer, obj);
    }

    @Override
    public void serializeJavaObjectAndClass(OutputStream outputStream, Object obj) {
        this.bindingThreadLocal.get().get().serializeJavaObjectAndClass(outputStream, obj);
    }

    @Override
    public Object deserializeJavaObjectAndClass(byte[] data) {
        return this.bindingThreadLocal.get().get().deserializeJavaObjectAndClass(data);
    }

    @Override
    public Object deserializeJavaObjectAndClass(MemoryBuffer buffer) {
        return this.bindingThreadLocal.get().get().deserializeJavaObjectAndClass(buffer);
    }

    @Override
    public Object deserializeJavaObjectAndClass(FuryInputStream inputStream) {
        return this.bindingThreadLocal.get().get().deserializeJavaObjectAndClass(inputStream);
    }

    @Override
    public Object deserializeJavaObjectAndClass(FuryReadableChannel channel) {
        return this.bindingThreadLocal.get().get().deserializeJavaObjectAndClass(channel);
    }

    @Override
    public <T> T copy(T obj) {
        return this.bindingThreadLocal.get().get().copy(obj);
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.setClassLoader(classLoader, LoaderBinding.StagingType.STRONG_STAGING);
    }

    @Override
    public void setClassLoader(ClassLoader classLoader, LoaderBinding.StagingType stagingType) {
        this.bindingThreadLocal.get().setClassLoader(classLoader, stagingType);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.bindingThreadLocal.get().getClassLoader();
    }

    @Override
    public void clearClassLoader(ClassLoader loader) {
        this.bindingThreadLocal.get().clearClassLoader(loader);
    }
}

