/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.codegen;

import java.util.Objects;

public interface Code {
    public static ExprValue exprValue(Class<?> type, String code) {
        return new SimpleExprValue(type, code);
    }

    public static ExprValue variable(Class<?> type, String name) {
        return new VariableValue(type, name);
    }

    public static ExprValue isNullVariable(String name) {
        return new VariableValue(Boolean.TYPE, name);
    }

    public static ExprValue literal(Class<?> type, String value) {
        if (type == Boolean.class || type == Boolean.TYPE) {
            if ("true".equals(value)) {
                return LiteralValue.TrueLiteral;
            }
            if ("false".equals(value)) {
                return LiteralValue.FalseLiteral;
            }
            throw new IllegalArgumentException(value);
        }
        return new LiteralValue(type, value);
    }

    public static class LiteralValue
    extends ExprValue {
        public static LiteralValue TrueLiteral = new LiteralValue(Boolean.TYPE, "true");
        public static LiteralValue FalseLiteral = new LiteralValue(Boolean.TYPE, "false");
        private final String value;

        public LiteralValue(Object value) {
            super(value.getClass());
            this.value = value.toString();
        }

        public LiteralValue(Class<?> javaType, String value) {
            super(javaType);
            this.value = value;
        }

        @Override
        String code() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LiteralValue that = (LiteralValue)o;
            return this.javaType() == that.javaType() && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.javaType());
        }
    }

    public static class VariableValue
    extends ExprValue {
        private final String variableName;

        public VariableValue(Class<?> javaType, String variableName) {
            super(javaType);
            this.variableName = variableName;
        }

        @Override
        String code() {
            return this.variableName;
        }
    }

    public static class SimpleExprValue
    extends ExprValue {
        private final String expr;

        public SimpleExprValue(Class<?> javaType, String expr) {
            super(javaType);
            this.expr = expr;
        }

        @Override
        String code() {
            return String.format("(%s)", this.expr);
        }
    }

    public static abstract class ExprValue
    extends JavaCode {
        private final Class<?> javaType;

        public ExprValue(Class<?> javaType) {
            this.javaType = javaType;
        }

        Class<?> javaType() {
            return this.javaType;
        }

        boolean isPrimitive() {
            return this.javaType.isPrimitive();
        }
    }

    public static abstract class JavaCode {
        abstract String code();

        public String toString() {
            return this.code();
        }
    }

    public static class ExprCode {
        private final String code;
        private final ExprValue isNull;
        private final ExprValue value;

        public ExprCode(String code) {
            this(code, null, null);
        }

        public ExprCode(ExprValue isNull, ExprValue value) {
            this(null, isNull, value);
        }

        public ExprCode(String code, ExprValue isNull, ExprValue value) {
            this.code = code;
            this.isNull = isNull;
            this.value = value;
        }

        public String code() {
            return this.code;
        }

        public ExprValue isNull() {
            return this.isNull;
        }

        public ExprValue value() {
            return this.value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ExprCode(");
            if (this.code != null) {
                sb.append("code=\"").append('\n').append(this.code).append("\n\", ");
            }
            sb.append("isNull=").append(this.isNull);
            sb.append(", value=").append(this.value);
            sb.append(')');
            return sb.toString();
        }
    }
}

