/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.ArrayList;
import redis.clients.jedis.params.Params;
import redis.clients.jedis.util.SafeEncoder;

public class MigrateParams
extends Params {
    private static final String COPY = "COPY";
    private static final String REPLACE = "REPLACE";
    private static final String AUTH = "AUTH";
    private static final String AUTH2 = "AUTH2";

    public static MigrateParams migrateParams() {
        return new MigrateParams();
    }

    public MigrateParams copy() {
        this.addParam(COPY);
        return this;
    }

    public MigrateParams replace() {
        this.addParam(REPLACE);
        return this;
    }

    public MigrateParams auth(String password) {
        this.addParam(AUTH, password);
        return this;
    }

    public MigrateParams auth2(String username, String password) {
        this.addParam(AUTH2, new String[]{username, password});
        return this;
    }

    @Override
    public byte[][] getByteParams() {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        if (this.contains(COPY)) {
            byteParams.add(SafeEncoder.encode(COPY));
        }
        if (this.contains(REPLACE)) {
            byteParams.add(SafeEncoder.encode(REPLACE));
        }
        if (this.contains(AUTH)) {
            byteParams.add(SafeEncoder.encode(AUTH));
            byteParams.add(SafeEncoder.encode((String)this.getParam(AUTH)));
        } else if (this.contains(AUTH2)) {
            byteParams.add(SafeEncoder.encode(AUTH2));
            String[] nameAndPass = (String[])this.getParam(AUTH2);
            byteParams.add(SafeEncoder.encode(nameAndPass[0]));
            byteParams.add(SafeEncoder.encode(nameAndPass[1]));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

