/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.snapshot;

import com.fasterxml.jackson.databind.JsonMappingException;
import io.seata.server.cluster.raft.snapshot.RaftSnapshot;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.seata.common.exception.SeataRuntimeException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.core.compressor.CompressorFactory;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.core.serializer.SerializerType;
import org.apache.seata.server.cluster.raft.snapshot.RaftSnapshot;
import org.apache.seata.server.cluster.raft.snapshot.RaftSnapshotSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftSnapshotSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftSnapshotSerializer.class);
    private static final List<String> PERMITS = new ArrayList();

    public static byte[] encode(RaftSnapshot raftSnapshot) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                Serializer serializer = (Serializer)EnhancedServiceLoader.load(Serializer.class, (String)SerializerType.getByCode((int)raftSnapshot.getCodec()).name());
                Optional.ofNullable(raftSnapshot.getBody()).ifPresent(value -> raftSnapshot.setBody((Object)CompressorFactory.getCompressor((byte)raftSnapshot.getCompressor()).compress(serializer.serialize(value))));
                oos.writeObject(raftSnapshot);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    public static byte[] encode(io.seata.server.cluster.raft.snapshot.RaftSnapshot raftSnapshot) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                Serializer serializer = (Serializer)EnhancedServiceLoader.load(Serializer.class, (String)SerializerType.getByCode((int)raftSnapshot.getCodec()).name());
                Optional.ofNullable(raftSnapshot.getBody()).ifPresent(value -> raftSnapshot.setBody((Object)CompressorFactory.getCompressor((byte)raftSnapshot.getCompressor()).compress(serializer.serialize(value))));
                oos.writeObject(raftSnapshot);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static RaftSnapshot decode(byte[] raftSnapshotByte) throws IOException {
        try (ByteArrayInputStream bin = new ByteArrayInputStream(raftSnapshotByte);){
            RaftSnapshot raftSnapshot;
            try (1 ois = new /* Unavailable Anonymous Inner Class!! */;){
                RaftSnapshot raftSnapshot2;
                Object object = ois.readObject();
                if (object instanceof io.seata.server.cluster.raft.snapshot.RaftSnapshot) {
                    raftSnapshot2 = new RaftSnapshot();
                    io.seata.server.cluster.raft.snapshot.RaftSnapshot oldRaftSnapshot = (io.seata.server.cluster.raft.snapshot.RaftSnapshot)object;
                    raftSnapshot2.setBody(oldRaftSnapshot.getBody());
                    raftSnapshot2.setVersion(oldRaftSnapshot.getVersion());
                    raftSnapshot2.setCompressor(oldRaftSnapshot.getCompressor());
                    raftSnapshot2.setType(RaftSnapshot.SnapshotType.valueOf((String)oldRaftSnapshot.getType().name()));
                } else {
                    raftSnapshot2 = (RaftSnapshot)object;
                }
                Serializer serializer = (Serializer)EnhancedServiceLoader.load(Serializer.class, (String)SerializerType.getByCode((int)raftSnapshot2.getCodec()).name());
                Optional.ofNullable(raftSnapshot2.getBody()).ifPresent(value -> raftSnapshot2.setBody(serializer.deserialize(CompressorFactory.getCompressor((byte)raftSnapshot2.getCompressor()).decompress((byte[])raftSnapshot2.getBody()))));
                raftSnapshot = raftSnapshot2;
            }
            return raftSnapshot;
        }
        catch (Exception e) {
            LOGGER.error("Failed to read raft snapshot: {}", (Object)e.getMessage(), (Object)e);
            if (e instanceof RuntimeException) {
                Throwable jsonCause;
                Throwable cause = e.getCause();
                if (cause instanceof JsonMappingException && (jsonCause = cause.getCause()) instanceof SeataRuntimeException) {
                    throw (SeataRuntimeException)jsonCause;
                }
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ List access$000() {
        return PERMITS;
    }

    static {
        PERMITS.add(RaftSnapshot.class.getName());
        PERMITS.add(RaftSnapshot.SnapshotType.class.getName());
        PERMITS.add(io.seata.server.cluster.raft.snapshot.RaftSnapshot.class.getName());
        PERMITS.add(RaftSnapshot.SnapshotType.class.getName());
        PERMITS.add(Enum.class.getName());
        PERMITS.add("[B");
    }
}

