/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.common.Constants;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.common.GroupKey;
import com.alibaba.nacos.client.config.filter.impl.ConfigFilterChainManager;
import com.alibaba.nacos.client.config.filter.impl.ConfigResponse;
import com.alibaba.nacos.client.config.http.HttpAgent;
import com.alibaba.nacos.client.config.impl.CacheData;
import com.alibaba.nacos.client.config.impl.LocalConfigInfoProcessor;
import com.alibaba.nacos.client.config.impl.LocalEncryptedDataKeyProcessor;
import com.alibaba.nacos.client.config.utils.ContentUtils;
import com.alibaba.nacos.client.monitor.MetricsMonitor;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ClientWorker
implements Closeable {
    private static final Logger LOGGER = LogUtils.logger(ClientWorker.class);
    final ScheduledExecutorService executor;
    final ScheduledExecutorService executorService;
    private final ConcurrentHashMap<String, CacheData> cacheMap = new ConcurrentHashMap();
    private final HttpAgent agent;
    private final ConfigFilterChainManager configFilterChainManager;
    private boolean isHealthServer = true;
    private long timeout;
    private double currentLongingTaskCount = 0.0;
    private int taskPenaltyTime;
    private boolean enableRemoteSyncConfig = false;

    public void addTenantListeners(String dataId, String group, List<? extends Listener> listeners) throws NacosException {
        group = this.blank2defaultGroup(group);
        String tenant = this.agent.getTenant();
        CacheData cache = this.addCacheDataIfAbsent(dataId, group, tenant);
        for (Listener listener : listeners) {
            cache.addListener(listener);
        }
    }

    public void addTenantListenersWithContent(String dataId, String group, String content, List<? extends Listener> listeners) throws NacosException {
        group = this.blank2defaultGroup(group);
        String tenant = this.agent.getTenant();
        CacheData cache = this.addCacheDataIfAbsent(dataId, group, tenant);
        cache.setContent(content);
        for (Listener listener : listeners) {
            cache.addListener(listener);
        }
    }

    public void removeTenantListener(String dataId, String group, Listener listener) {
        String tenant;
        CacheData cache = this.getCache(dataId, group = this.blank2defaultGroup(group), tenant = this.agent.getTenant());
        if (null != cache) {
            cache.removeListener(listener);
            if (cache.getListeners().isEmpty()) {
                this.removeCache(dataId, group, tenant);
            }
        }
    }

    void removeCache(String dataId, String group, String tenant) {
        String groupKey = GroupKey.getKeyTenant(dataId, group, tenant);
        this.cacheMap.remove(groupKey);
        LOGGER.info("[{}] [unsubscribe] {}", (Object)this.agent.getName(), (Object)groupKey);
        MetricsMonitor.getListenConfigCountMonitor().set((double)this.cacheMap.size());
    }

    public CacheData addCacheDataIfAbsent(String dataId, String group, String tenant) throws NacosException {
        String key = GroupKey.getKeyTenant(dataId, group, tenant);
        CacheData cacheData = this.cacheMap.get(key);
        if (cacheData != null) {
            return cacheData;
        }
        cacheData = new CacheData(this.configFilterChainManager, this.agent.getName(), dataId, group, tenant);
        CacheData lastCacheData = this.cacheMap.putIfAbsent(key, cacheData);
        if (lastCacheData == null) {
            if (this.enableRemoteSyncConfig) {
                ConfigResponse response = this.getServerConfig(dataId, group, tenant, 3000L);
                cacheData.setContent(response.getContent());
            }
            int taskId = this.cacheMap.size() / (int)ParamUtil.getPerTaskConfigSize();
            cacheData.setTaskId(taskId);
            lastCacheData = cacheData;
        }
        lastCacheData.setInitializing(true);
        LOGGER.info("[{}] [subscribe] {}", (Object)this.agent.getName(), (Object)key);
        MetricsMonitor.getListenConfigCountMonitor().set((double)this.cacheMap.size());
        return lastCacheData;
    }

    public CacheData getCache(String dataId, String group, String tenant) {
        if (null == dataId || null == group) {
            throw new IllegalArgumentException();
        }
        return this.cacheMap.get(GroupKey.getKeyTenant(dataId, group, tenant));
    }

    public ConfigResponse getServerConfig(String dataId, String group, String tenant, long readTimeout) throws NacosException {
        ConfigResponse configResponse = new ConfigResponse();
        if (StringUtils.isBlank((String)group)) {
            group = "DEFAULT_GROUP";
        }
        HttpRestResult<String> result = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>(3);
            if (StringUtils.isBlank((String)tenant)) {
                params.put("dataId", dataId);
                params.put("group", group);
            } else {
                params.put("dataId", dataId);
                params.put("group", group);
                params.put("tenant", tenant);
            }
            result = this.agent.httpGet("/v1/cs/configs", null, params, this.agent.getEncode(), readTimeout);
        }
        catch (Exception ex) {
            String message = String.format("[%s] [sub-server] get server config exception, dataId=%s, group=%s, tenant=%s", this.agent.getName(), dataId, group, tenant);
            LOGGER.error(message, (Throwable)ex);
            throw new NacosException(500, (Throwable)ex);
        }
        switch (result.getCode()) {
            case 200: {
                LocalConfigInfoProcessor.saveSnapshot(this.agent.getName(), dataId, group, tenant, (String)result.getData());
                configResponse.setContent((String)result.getData());
                String configType = result.getHeader().getValue("Config-Type") != null ? result.getHeader().getValue("Config-Type") : ConfigType.TEXT.getType();
                configResponse.setConfigType(configType);
                String encryptedDataKey = result.getHeader().getValue("Encrypted-Data-Key");
                LocalEncryptedDataKeyProcessor.saveEncryptDataKeySnapshot(this.agent.getName(), dataId, group, tenant, encryptedDataKey);
                configResponse.setEncryptedDataKey(encryptedDataKey);
                return configResponse;
            }
            case 404: {
                LocalConfigInfoProcessor.saveSnapshot(this.agent.getName(), dataId, group, tenant, null);
                LocalEncryptedDataKeyProcessor.saveEncryptDataKeySnapshot(this.agent.getName(), dataId, group, tenant, null);
                return configResponse;
            }
            case 409: {
                LOGGER.error("[{}] [sub-server-error] get server config being modified concurrently, dataId={}, group={}, tenant={}", new Object[]{this.agent.getName(), dataId, group, tenant});
                throw new NacosException(409, "data being modified, dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
            }
            case 403: {
                LOGGER.error("[{}] [sub-server-error] no right, dataId={}, group={}, tenant={}", new Object[]{this.agent.getName(), dataId, group, tenant});
                throw new NacosException(result.getCode(), result.getMessage());
            }
        }
        LOGGER.error("[{}] [sub-server-error]  dataId={}, group={}, tenant={}, code={}", new Object[]{this.agent.getName(), dataId, group, tenant, result.getCode()});
        throw new NacosException(result.getCode(), "http error, code=" + result.getCode() + ",dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
    }

    private void checkLocalConfig(CacheData cacheData) {
        String dataId = cacheData.dataId;
        String group = cacheData.group;
        String tenant = cacheData.tenant;
        File path = LocalConfigInfoProcessor.getFailoverFile(this.agent.getName(), dataId, group, tenant);
        if (!cacheData.isUseLocalConfigInfo() && path.exists()) {
            String content = LocalConfigInfoProcessor.getFailover(this.agent.getName(), dataId, group, tenant);
            String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
            cacheData.setUseLocalConfigInfo(true);
            cacheData.setLocalConfigInfoVersion(path.lastModified());
            String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeyFailover(this.agent.getName(), dataId, group, tenant);
            cacheData.setEncryptedDataKey(encryptedDataKey);
            cacheData.setContent(content);
            LOGGER.warn("[{}] [failover-change] failover file created. dataId={}, group={}, tenant={}, md5={}, content={}", new Object[]{this.agent.getName(), dataId, group, tenant, md5, ContentUtils.truncateContent(content)});
            return;
        }
        if (cacheData.isUseLocalConfigInfo() && !path.exists()) {
            cacheData.setUseLocalConfigInfo(false);
            LOGGER.warn("[{}] [failover-change] failover file deleted. dataId={}, group={}, tenant={}", new Object[]{this.agent.getName(), dataId, group, tenant});
            return;
        }
        if (cacheData.isUseLocalConfigInfo() && path.exists() && cacheData.getLocalConfigInfoVersion() != path.lastModified()) {
            String content = LocalConfigInfoProcessor.getFailover(this.agent.getName(), dataId, group, tenant);
            String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
            cacheData.setUseLocalConfigInfo(true);
            cacheData.setLocalConfigInfoVersion(path.lastModified());
            String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeyFailover(this.agent.getName(), dataId, group, tenant);
            cacheData.setEncryptedDataKey(encryptedDataKey);
            cacheData.setContent(content);
            LOGGER.warn("[{}] [failover-change] failover file changed. dataId={}, group={}, tenant={}, md5={}, content={}", new Object[]{this.agent.getName(), dataId, group, tenant, md5, ContentUtils.truncateContent(content)});
        }
    }

    private String blank2defaultGroup(String group) {
        return StringUtils.isBlank((String)group) ? "DEFAULT_GROUP" : group.trim();
    }

    public void checkConfigInfo() {
        int listenerSize = this.cacheMap.size();
        int longingTaskCount = (int)Math.ceil((double)listenerSize / ParamUtil.getPerTaskConfigSize());
        if ((double)longingTaskCount > this.currentLongingTaskCount) {
            for (int i = (int)this.currentLongingTaskCount; i < longingTaskCount; ++i) {
                this.executorService.execute(new LongPollingRunnable(i));
            }
            this.currentLongingTaskCount = longingTaskCount;
        }
    }

    List<String> checkUpdateDataIds(List<CacheData> cacheDatas, List<String> inInitializingCacheList) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (CacheData cacheData : cacheDatas) {
            if (cacheData.isUseLocalConfigInfo()) continue;
            sb.append(cacheData.dataId).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.group).append(Constants.WORD_SEPARATOR);
            if (StringUtils.isBlank((String)cacheData.tenant)) {
                sb.append(cacheData.getMd5()).append(Constants.LINE_SEPARATOR);
            } else {
                sb.append(cacheData.getMd5()).append(Constants.WORD_SEPARATOR);
                sb.append(cacheData.getTenant()).append(Constants.LINE_SEPARATOR);
            }
            if (!cacheData.isInitializing()) continue;
            inInitializingCacheList.add(GroupKey.getKeyTenant(cacheData.dataId, cacheData.group, cacheData.tenant));
        }
        boolean isInitializingCacheList = !inInitializingCacheList.isEmpty();
        return this.checkUpdateConfigStr(sb.toString(), isInitializingCacheList);
    }

    List<String> checkUpdateConfigStr(String probeUpdateString, boolean isInitializingCacheList) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("Listening-Configs", probeUpdateString);
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("Long-Pulling-Timeout", "" + this.timeout);
        if (isInitializingCacheList) {
            headers.put("Long-Pulling-Timeout-No-Hangup", "true");
        }
        if (StringUtils.isBlank((String)probeUpdateString)) {
            return Collections.emptyList();
        }
        try {
            long readTimeoutMs = this.timeout + (long)Math.round(this.timeout >> 1);
            HttpRestResult<String> result = this.agent.httpPost("/v1/cs/configs/listener", headers, params, this.agent.getEncode(), readTimeoutMs);
            if (result.ok()) {
                this.setHealthServer(true);
                return this.parseUpdateDataIdResponse((String)result.getData());
            }
            this.setHealthServer(false);
            LOGGER.error("[{}] [check-update] get changed dataId error, code: {}", (Object)this.agent.getName(), (Object)result.getCode());
        }
        catch (Exception e) {
            this.setHealthServer(false);
            LOGGER.error("[" + this.agent.getName() + "] [check-update] get changed dataId exception", (Throwable)e);
            throw e;
        }
        return Collections.emptyList();
    }

    private List<String> parseUpdateDataIdResponse(String response) {
        if (StringUtils.isBlank((String)response)) {
            return Collections.emptyList();
        }
        try {
            response = URLDecoder.decode(response, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.error("[" + this.agent.getName() + "] [polling-resp] decode modifiedDataIdsString error", (Throwable)e);
        }
        LinkedList<String> updateList = new LinkedList<String>();
        for (String dataIdAndGroup : response.split(Constants.LINE_SEPARATOR)) {
            if (StringUtils.isBlank((String)dataIdAndGroup)) continue;
            String[] keyArr = dataIdAndGroup.split(Constants.WORD_SEPARATOR);
            String dataId = keyArr[0];
            String group = keyArr[1];
            if (keyArr.length == 2) {
                updateList.add(GroupKey.getKey(dataId, group));
                LOGGER.info("[{}] [polling-resp] config changed. dataId={}, group={}", new Object[]{this.agent.getName(), dataId, group});
                continue;
            }
            if (keyArr.length == 3) {
                String tenant = keyArr[2];
                updateList.add(GroupKey.getKeyTenant(dataId, group, tenant));
                LOGGER.info("[{}] [polling-resp] config changed. dataId={}, group={}, tenant={}", new Object[]{this.agent.getName(), dataId, group, tenant});
                continue;
            }
            LOGGER.error("[{}] [polling-resp] invalid dataIdAndGroup error {}", (Object)this.agent.getName(), (Object)dataIdAndGroup);
        }
        return updateList;
    }

    public ClientWorker(final HttpAgent agent, ConfigFilterChainManager configFilterChainManager, Properties properties) {
        this.agent = agent;
        this.configFilterChainManager = configFilterChainManager;
        this.init(properties);
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.alibaba.nacos.client.Worker." + agent.getName());
                t.setDaemon(true);
                return t;
            }
        });
        this.executorService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.alibaba.nacos.client.Worker.longPolling." + agent.getName());
                t.setDaemon(true);
                return t;
            }
        });
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientWorker.this.checkConfigInfo();
                }
                catch (Throwable e) {
                    LOGGER.error("[" + agent.getName() + "] [sub-check] rotate check error", e);
                }
            }
        }, 1L, 10L, TimeUnit.MILLISECONDS);
    }

    private void init(Properties properties) {
        this.timeout = Math.max(ConvertUtils.toInt((String)properties.getProperty("configLongPollTimeout"), (int)30000), 10000);
        this.taskPenaltyTime = ConvertUtils.toInt((String)properties.getProperty("configRetryTime"), (int)2000);
        this.enableRemoteSyncConfig = Boolean.parseBoolean(properties.getProperty("enableRemoteSyncConfig"));
    }

    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LOGGER.info("{} do shutdown begin", (Object)className);
        ThreadUtils.shutdownThreadPool((ExecutorService)this.executorService, (Logger)LOGGER);
        ThreadUtils.shutdownThreadPool((ExecutorService)this.executor, (Logger)LOGGER);
        LOGGER.info("{} do shutdown stop", (Object)className);
    }

    public boolean isHealthServer() {
        return this.isHealthServer;
    }

    private void setHealthServer(boolean isHealthServer) {
        this.isHealthServer = isHealthServer;
    }

    class LongPollingRunnable
    implements Runnable {
        private final int taskId;

        public LongPollingRunnable(int taskId) {
            this.taskId = taskId;
        }

        @Override
        public void run() {
            ArrayList<CacheData> cacheDatas = new ArrayList<CacheData>();
            ArrayList<String> inInitializingCacheList = new ArrayList<String>();
            try {
                for (CacheData cacheData : ClientWorker.this.cacheMap.values()) {
                    if (cacheData.getTaskId() != this.taskId) continue;
                    cacheDatas.add(cacheData);
                    try {
                        ClientWorker.this.checkLocalConfig(cacheData);
                        if (!cacheData.isUseLocalConfigInfo()) continue;
                        cacheData.checkListenerMd5();
                    }
                    catch (Exception e) {
                        LOGGER.error("get local config info error", (Throwable)e);
                    }
                }
                List<String> changedGroupKeys = ClientWorker.this.checkUpdateDataIds(cacheDatas, inInitializingCacheList);
                if (!CollectionUtils.isEmpty(changedGroupKeys)) {
                    LOGGER.info("get changedGroupKeys:" + changedGroupKeys);
                }
                for (String groupKey : changedGroupKeys) {
                    String[] key = GroupKey.parseKey(groupKey);
                    String dataId = key[0];
                    String group = key[1];
                    String tenant = null;
                    if (key.length == 3) {
                        tenant = key[2];
                    }
                    try {
                        ConfigResponse response = ClientWorker.this.getServerConfig(dataId, group, tenant, 3000L);
                        CacheData cache = (CacheData)ClientWorker.this.cacheMap.get(GroupKey.getKeyTenant(dataId, group, tenant));
                        cache.setEncryptedDataKey(response.getEncryptedDataKey());
                        cache.setContent(response.getContent());
                        if (null != response.getConfigType()) {
                            cache.setType(response.getConfigType());
                        }
                        LOGGER.info("[{}] [data-received] dataId={}, group={}, tenant={}, md5={}, content={}, type={}", new Object[]{ClientWorker.this.agent.getName(), dataId, group, tenant, cache.getMd5(), ContentUtils.truncateContent(response.getContent()), response.getConfigType()});
                    }
                    catch (NacosException ioe) {
                        String message = String.format("[%s] [get-update] get changed config exception. dataId=%s, group=%s, tenant=%s", ClientWorker.this.agent.getName(), dataId, group, tenant);
                        LOGGER.error(message, (Throwable)ioe);
                    }
                }
                for (CacheData cacheData : cacheDatas) {
                    if (cacheData.isInitializing() && !inInitializingCacheList.contains(GroupKey.getKeyTenant(cacheData.dataId, cacheData.group, cacheData.tenant))) continue;
                    cacheData.checkListenerMd5();
                    cacheData.setInitializing(false);
                }
                inInitializingCacheList.clear();
                ClientWorker.this.executorService.execute(this);
            }
            catch (Throwable e) {
                LOGGER.error("longPolling error : ", e);
                ClientWorker.this.executorService.schedule(this, (long)ClientWorker.this.taskPenaltyTime, TimeUnit.MILLISECONDS);
            }
        }
    }
}

