/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.sofa.jraft.util.BytesUtil;
import java.util.Arrays;

public class Bytes
implements Comparable<Bytes> {
    private static final char[] HEX_CHARS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final byte[] bytes;
    private int hashCode;

    public static Bytes wrap(byte[] bytes) {
        return new Bytes(bytes);
    }

    public Bytes(byte[] bytes) {
        this.bytes = bytes;
        this.hashCode = 0;
    }

    public byte[] get() {
        return this.bytes;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.bytes);
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.hashCode() == other.hashCode() && other instanceof Bytes && Arrays.equals(this.bytes, ((Bytes)other).get());
    }

    @Override
    public int compareTo(Bytes that) {
        return BytesUtil.getDefaultByteArrayComparator().compare(this.bytes, that.bytes);
    }

    public String toString() {
        return Bytes.toString(this.bytes, 0, this.bytes.length);
    }

    private static String toString(byte[] b, int off, int len) {
        StringBuilder result = new StringBuilder();
        if (b == null) {
            return result.toString();
        }
        if (off >= b.length) {
            return result.toString();
        }
        if (off + len > b.length) {
            len = b.length - off;
        }
        for (int i = off; i < off + len; ++i) {
            int ch = b[i] & 0xFF;
            if (ch >= 32 && ch <= 126 && ch != 92) {
                result.append((char)ch);
                continue;
            }
            result.append("\\x");
            result.append(HEX_CHARS_UPPER[ch / 16]);
            result.append(HEX_CHARS_UPPER[ch % 16]);
        }
        return result.toString();
    }
}

