/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.apache.seata.core.protocol.detector.ProtocolDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolDetectHandler
extends ByteToMessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolDetectHandler.class);
    private ProtocolDetector[] supportedProtocolDetectors;

    public ProtocolDetectHandler(ProtocolDetector[] supportedProtocolDetectors) {
        this.supportedProtocolDetectors = supportedProtocolDetectors;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() > 0x800000) {
            LOGGER.error("Packet size {} exceeds maximum {}, closing connection from {}", new Object[]{in.readableBytes(), 0x800000, ctx.channel().remoteAddress()});
            ctx.close();
            return;
        }
        for (ProtocolDetector protocolDetector : this.supportedProtocolDetectors) {
            if (protocolDetector.detect(in)) {
                ChannelHandler[] protocolHandlers = protocolDetector.getHandlers();
                ctx.pipeline().addLast(protocolHandlers);
                ctx.pipeline().remove((ChannelHandler)this);
                in.resetReaderIndex();
                return;
            }
            in.resetReaderIndex();
        }
        byte[] preface = new byte[in.readableBytes()];
        in.readBytes(preface);
        LOGGER.error("Can not recognize protocol from remote {}, preface = {}", (Object)ctx.channel().remoteAddress(), (Object)preface);
        in.clear();
        ctx.close();
    }
}

