/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.console.config;

import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.List;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.console.filter.JwtAuthenticationTokenFilter;
import org.apache.seata.console.security.CustomUserDetailsServiceImpl;
import org.apache.seata.console.security.JwtAuthenticationEntryPoint;
import org.apache.seata.console.utils.JwtTokenUtils;
import org.apache.seata.mcp.core.props.MCPProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration(proxyBeanMethods=false)
@EnableWebSecurity
@EnableMethodSecurity
public class WebSecurityConfig {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String AUTHORIZATION_TOKEN = "access_token";
    public static final String SECURITY_IGNORE_URLS_SPILT_CHAR = ",";
    public static final String TOKEN_PREFIX = "Bearer ";
    @Autowired
    private CustomUserDetailsServiceImpl userDetailsService;
    @Autowired
    private JwtAuthenticationEntryPoint unauthorizedHandler;
    @Autowired
    private JwtTokenUtils tokenProvider;
    @Autowired
    private MCPProperties mcpProperties;
    @Value(value="${seata.security.ignore.urls:/**}")
    String ignoreURLs;
    @Value(value="${seata.security.csrf-ignore-urls:/**}")
    String csrfIgnoreUrls;

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public AuthenticationManager authenticationManager() {
        DaoAuthenticationProvider authenticationProvider = new DaoAuthenticationProvider((UserDetailsService)this.userDetailsService);
        authenticationProvider.setPasswordEncoder(this.passwordEncoder());
        return new ProviderManager(new AuthenticationProvider[]{authenticationProvider});
    }

    @Bean
    public WebSecurityCustomizer webSecurityCustomizer() {
        RequestMatcher[] ignoredMatchers = this.buildAntMatchers(this.ignoreURLs.trim());
        return web -> {
            if (ignoredMatchers.length > 0) {
                web.ignoring().requestMatchers(ignoredMatchers);
            }
        };
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http, AuthenticationManager authenticationManager) throws Exception {
        StringBuilder csrfIgnoreUrlsBuilder = new StringBuilder(this.csrfIgnoreUrls);
        List<String> mcpEndpoints = this.mcpProperties.getEndpoints();
        for (String endpoint : mcpEndpoints) {
            csrfIgnoreUrlsBuilder.append(SECURITY_IGNORE_URLS_SPILT_CHAR).append(endpoint);
        }
        RequestMatcher[] csrfIgnored = this.buildAntMatchers(csrfIgnoreUrlsBuilder.toString().trim());
        http.authenticationManager(authenticationManager).authorizeHttpRequests(authz -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.anyRequest()).authenticated()).exceptionHandling(exception -> exception.authenticationEntryPoint((AuthenticationEntryPoint)this.unauthorizedHandler)).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).csrf(csrf -> {
            if (csrfIgnored.length > 0) {
                csrf.ignoringRequestMatchers(csrfIgnored);
            }
            csrf.csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse());
        }).addFilterBefore((Filter)new JwtAuthenticationTokenFilter(this.tokenProvider), UsernamePasswordAuthenticationFilter.class).headers(headers -> headers.cacheControl(cache -> {}));
        return (SecurityFilterChain)http.build();
    }

    private RequestMatcher[] buildAntMatchers(String patterns) {
        if (StringUtils.isBlank((String)patterns)) {
            return new RequestMatcher[0];
        }
        return (RequestMatcher[])Arrays.stream(patterns.trim().split(SECURITY_IGNORE_URLS_SPILT_CHAR)).map(String::trim).filter(StringUtils::isNotBlank).map(AntPathRequestMatcher::new).toArray(RequestMatcher[]::new);
    }
}

