/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.progress;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.springaicommunity.mcp.annotation.McpProgress;

public abstract class AbstractMcpProgressMethodCallback {
    protected final Method method;
    protected final Object bean;

    protected AbstractMcpProgressMethodCallback(Method method, Object bean) {
        Assert.notNull((Object)method, (String)"Method can't be null!");
        Assert.notNull((Object)bean, (String)"Bean can't be null!");
        this.method = method;
        this.bean = bean;
        this.validateMethod(this.method);
    }

    protected void validateMethod(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Method must not be null");
        }
        this.validateReturnType(method);
        this.validateParameters(method);
    }

    protected abstract void validateReturnType(Method var1);

    protected void validateParameters(Method method) {
        Parameter[] parameters = method.getParameters();
        if (parameters.length != 1 && parameters.length != 3) {
            throw new IllegalArgumentException("Method must have either 1 parameter (ProgressNotification) or 3 parameters (Double, String, String): " + method.getName() + " in " + method.getDeclaringClass().getName() + " has " + parameters.length + " parameters");
        }
        if (parameters.length == 1) {
            if (!McpSchema.ProgressNotification.class.isAssignableFrom(parameters[0].getType())) {
                throw new IllegalArgumentException("Single parameter must be of type ProgressNotification: " + method.getName() + " in " + method.getDeclaringClass().getName() + " has parameter of type " + parameters[0].getType().getName());
            }
        } else {
            if (!Double.class.isAssignableFrom(parameters[0].getType()) && !Double.TYPE.isAssignableFrom(parameters[0].getType())) {
                throw new IllegalArgumentException("First parameter must be of type Double or double: " + method.getName() + " in " + method.getDeclaringClass().getName() + " has parameter of type " + parameters[0].getType().getName());
            }
            if (!String.class.isAssignableFrom(parameters[1].getType())) {
                throw new IllegalArgumentException("Second parameter must be of type String: " + method.getName() + " in " + method.getDeclaringClass().getName() + " has parameter of type " + parameters[1].getType().getName());
            }
            if (!String.class.isAssignableFrom(parameters[2].getType())) {
                throw new IllegalArgumentException("Third parameter must be of type String: " + method.getName() + " in " + method.getDeclaringClass().getName() + " has parameter of type " + parameters[2].getType().getName());
            }
        }
    }

    protected Object[] buildArgs(Method method, Object exchange, McpSchema.ProgressNotification notification) {
        Parameter[] parameters = method.getParameters();
        Object[] args = new Object[parameters.length];
        if (parameters.length == 1) {
            args[0] = notification;
        } else {
            args[0] = notification.progress();
            args[1] = notification.progressToken();
            args[2] = notification.total() != null ? String.valueOf(notification.total()) : null;
        }
        return args;
    }

    protected static abstract class AbstractBuilder<T extends AbstractBuilder<T, R>, R> {
        protected Method method;
        protected Object bean;

        protected AbstractBuilder() {
        }

        public T method(Method method) {
            this.method = method;
            return (T)this;
        }

        public T bean(Object bean) {
            this.bean = bean;
            return (T)this;
        }

        public T progress(McpProgress progress) {
            return (T)this;
        }

        protected void validate() {
            if (this.method == null) {
                throw new IllegalArgumentException("Method must not be null");
            }
            if (this.bean == null) {
                throw new IllegalArgumentException("Bean must not be null");
            }
        }

        public abstract R build();
    }

    public static class McpProgressMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public McpProgressMethodException(String message, Throwable cause) {
            super(message, cause);
        }

        public McpProgressMethodException(String message) {
            super(message);
        }
    }
}

