/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v5.28.3
// source: branch_undo_log.proto

package parser

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type IndexType int32

const (
	IndexType_IndexTypeNull       IndexType = 0
	IndexType_IndexTypePrimaryKey IndexType = 1
)

// Enum value maps for IndexType.
var (
	IndexType_name = map[int32]string{
		0: "IndexTypeNull",
		1: "IndexTypePrimaryKey",
	}
	IndexType_value = map[string]int32{
		"IndexTypeNull":       0,
		"IndexTypePrimaryKey": 1,
	}
)

func (x IndexType) Enum() *IndexType {
	p := new(IndexType)
	*p = x
	return p
}

func (x IndexType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IndexType) Descriptor() protoreflect.EnumDescriptor {
	return file_branch_undo_log_proto_enumTypes[0].Descriptor()
}

func (IndexType) Type() protoreflect.EnumType {
	return &file_branch_undo_log_proto_enumTypes[0]
}

func (x IndexType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IndexType.Descriptor instead.
func (IndexType) EnumDescriptor() ([]byte, []int) {
	return file_branch_undo_log_proto_rawDescGZIP(), []int{0}
}

type JDBCType int32

const (
	JDBCType_JDBCTypeNull                  JDBCType = 0
	JDBCType_JDBCTypeBit                   JDBCType = -7
	JDBCType_JDBCTypeTinyInt               JDBCType = -6
	JDBCType_JDBCTypeSmallInt              JDBCType = 5
	JDBCType_JDBCTypeInteger               JDBCType = 4
	JDBCType_JDBCTypeBigInt                JDBCType = -5
	JDBCType_JDBCTypeFloat                 JDBCType = 6
	JDBCType_JDBCTypeReal                  JDBCType = 7
	JDBCType_JDBCTypeDouble                JDBCType = 8
	JDBCType_JDBCTypeNumberic              JDBCType = 2
	JDBCType_JDBCTypeDecimal               JDBCType = 3
	JDBCType_JDBCTypeChar                  JDBCType = 1
	JDBCType_JDBCTypeVarchar               JDBCType = 12
	JDBCType_JDBCTypeLongVarchar           JDBCType = -1
	JDBCType_JDBCTypeDate                  JDBCType = 91
	JDBCType_JDBCTypeTime                  JDBCType = 92
	JDBCType_JDBCTypeTimestamp             JDBCType = 93
	JDBCType_JDBCTypeBinary                JDBCType = -2
	JDBCType_JDBCTypeVarBinary             JDBCType = -3
	JDBCType_JDBCTypeLongVarBinary         JDBCType = -4
	JDBCType_JDBCTypeOther                 JDBCType = 1111
	JDBCType_JDBCTypeJavaObject            JDBCType = 2000
	JDBCType_JDBCTypeDistinct              JDBCType = 2001
	JDBCType_JDBCTypeStruct                JDBCType = 2002
	JDBCType_JDBCTypeArray                 JDBCType = 2003
	JDBCType_JDBCTypeBlob                  JDBCType = 2004
	JDBCType_JDBCTypeClob                  JDBCType = 2005
	JDBCType_JDBCTypeRef                   JDBCType = 2006
	JDBCType_JDBCTypeDateLink              JDBCType = 70
	JDBCType_JDBCTypeBoolean               JDBCType = 16
	JDBCType_JDBCTypeRowID                 JDBCType = -8
	JDBCType_JDBCTypeNchar                 JDBCType = -15
	JDBCType_JDBCTypeNvarchar              JDBCType = -9
	JDBCType_JDBCTypeLongNvVarchar         JDBCType = -16
	JDBCType_JDBCTypeNclob                 JDBCType = 2011
	JDBCType_JDBCTypeSqlXML                JDBCType = 2009
	JDBCType_JDBCTypeRefCursor             JDBCType = 2012
	JDBCType_JDBCTypeTimeWithTimeZone      JDBCType = 2013
	JDBCType_JDBCTypeTimestampWithTimezone JDBCType = 2014
)

// Enum value maps for JDBCType.
var (
	JDBCType_name = map[int32]string{
		0:    "JDBCTypeNull",
		-7:   "JDBCTypeBit",
		-6:   "JDBCTypeTinyInt",
		5:    "JDBCTypeSmallInt",
		4:    "JDBCTypeInteger",
		-5:   "JDBCTypeBigInt",
		6:    "JDBCTypeFloat",
		7:    "JDBCTypeReal",
		8:    "JDBCTypeDouble",
		2:    "JDBCTypeNumberic",
		3:    "JDBCTypeDecimal",
		1:    "JDBCTypeChar",
		12:   "JDBCTypeVarchar",
		-1:   "JDBCTypeLongVarchar",
		91:   "JDBCTypeDate",
		92:   "JDBCTypeTime",
		93:   "JDBCTypeTimestamp",
		-2:   "JDBCTypeBinary",
		-3:   "JDBCTypeVarBinary",
		-4:   "JDBCTypeLongVarBinary",
		1111: "JDBCTypeOther",
		2000: "JDBCTypeJavaObject",
		2001: "JDBCTypeDistinct",
		2002: "JDBCTypeStruct",
		2003: "JDBCTypeArray",
		2004: "JDBCTypeBlob",
		2005: "JDBCTypeClob",
		2006: "JDBCTypeRef",
		70:   "JDBCTypeDateLink",
		16:   "JDBCTypeBoolean",
		-8:   "JDBCTypeRowID",
		-15:  "JDBCTypeNchar",
		-9:   "JDBCTypeNvarchar",
		-16:  "JDBCTypeLongNvVarchar",
		2011: "JDBCTypeNclob",
		2009: "JDBCTypeSqlXML",
		2012: "JDBCTypeRefCursor",
		2013: "JDBCTypeTimeWithTimeZone",
		2014: "JDBCTypeTimestampWithTimezone",
	}
	JDBCType_value = map[string]int32{
		"JDBCTypeNull":                  0,
		"JDBCTypeBit":                   -7,
		"JDBCTypeTinyInt":               -6,
		"JDBCTypeSmallInt":              5,
		"JDBCTypeInteger":               4,
		"JDBCTypeBigInt":                -5,
		"JDBCTypeFloat":                 6,
		"JDBCTypeReal":                  7,
		"JDBCTypeDouble":                8,
		"JDBCTypeNumberic":              2,
		"JDBCTypeDecimal":               3,
		"JDBCTypeChar":                  1,
		"JDBCTypeVarchar":               12,
		"JDBCTypeLongVarchar":           -1,
		"JDBCTypeDate":                  91,
		"JDBCTypeTime":                  92,
		"JDBCTypeTimestamp":             93,
		"JDBCTypeBinary":                -2,
		"JDBCTypeVarBinary":             -3,
		"JDBCTypeLongVarBinary":         -4,
		"JDBCTypeOther":                 1111,
		"JDBCTypeJavaObject":            2000,
		"JDBCTypeDistinct":              2001,
		"JDBCTypeStruct":                2002,
		"JDBCTypeArray":                 2003,
		"JDBCTypeBlob":                  2004,
		"JDBCTypeClob":                  2005,
		"JDBCTypeRef":                   2006,
		"JDBCTypeDateLink":              70,
		"JDBCTypeBoolean":               16,
		"JDBCTypeRowID":                 -8,
		"JDBCTypeNchar":                 -15,
		"JDBCTypeNvarchar":              -9,
		"JDBCTypeLongNvVarchar":         -16,
		"JDBCTypeNclob":                 2011,
		"JDBCTypeSqlXML":                2009,
		"JDBCTypeRefCursor":             2012,
		"JDBCTypeTimeWithTimeZone":      2013,
		"JDBCTypeTimestampWithTimezone": 2014,
	}
)

func (x JDBCType) Enum() *JDBCType {
	p := new(JDBCType)
	*p = x
	return p
}

func (x JDBCType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JDBCType) Descriptor() protoreflect.EnumDescriptor {
	return file_branch_undo_log_proto_enumTypes[1].Descriptor()
}

func (JDBCType) Type() protoreflect.EnumType {
	return &file_branch_undo_log_proto_enumTypes[1]
}

func (x JDBCType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JDBCType.Descriptor instead.
func (JDBCType) EnumDescriptor() ([]byte, []int) {
	return file_branch_undo_log_proto_rawDescGZIP(), []int{1}
}

type SQLType int32

const (
	SQLType_SQLTypeSelect                  SQLType = 0
	SQLType_SQLTypeInsert                  SQLType = 1
	SQLType_SQLTypeUpdate                  SQLType = 2
	SQLType_SQLTypeDelete                  SQLType = 3
	SQLType_SQLTypeSelectForUpdate         SQLType = 4
	SQLType_SQLTypeReplace                 SQLType = 5
	SQLType_SQLTypeTruncate                SQLType = 6
	SQLType_SQLTypeCreate                  SQLType = 7
	SQLType_SQLTypeDrop                    SQLType = 8
	SQLType_SQLTypeLoad                    SQLType = 9
	SQLType_SQLTypeMerge                   SQLType = 10
	SQLType_SQLTypeShow                    SQLType = 11
	SQLType_SQLTypeAlter                   SQLType = 12
	SQLType_SQLTypeRename                  SQLType = 13
	SQLType_SQLTypeDump                    SQLType = 14
	SQLType_SQLTypeDebug                   SQLType = 15
	SQLType_SQLTypeExplain                 SQLType = 16
	SQLType_SQLTypeProcedure               SQLType = 17
	SQLType_SQLTypeDesc                    SQLType = 18
	SQLType_SQLLastInsertID                SQLType = 19
	SQLType_SQLSelectWithoutTable          SQLType = 20
	SQLType_SQLCreateSequence              SQLType = 21
	SQLType_SQLShowSequence                SQLType = 22
	SQLType_SQLGetSequence                 SQLType = 23
	SQLType_SQLAlterSequence               SQLType = 24
	SQLType_SQLDropSequence                SQLType = 25
	SQLType_SQLTddlShow                    SQLType = 26
	SQLType_SQLTypeSet                     SQLType = 27
	SQLType_SQLTypeReload                  SQLType = 28
	SQLType_SQLTypeSelectUnion             SQLType = 29
	SQLType_SQLTypeCreateTable             SQLType = 30
	SQLType_SQLTypeDropTable               SQLType = 31
	SQLType_SQLTypeAlterTable              SQLType = 32
	SQLType_SQLTypeSavePoint               SQLType = 33
	SQLType_SQLTypeSelectFromUpdate        SQLType = 34
	SQLType_SQLTypeMultiDelete             SQLType = 35
	SQLType_SQLTypeMultiUpdate             SQLType = 36
	SQLType_SQLTypeCreateIndex             SQLType = 37
	SQLType_SQLTypeDropIndex               SQLType = 38
	SQLType_SQLTypeKill                    SQLType = 39
	SQLType_SQLTypeLockTables              SQLType = 40
	SQLType_SQLTypeUnLockTables            SQLType = 41
	SQLType_SQLTypeCheckTable              SQLType = 42
	SQLType_SQLTypeSelectFoundRows         SQLType = 43
	SQLType_SQLTypeInsertIgnore            SQLType = 101 // Adjusted the value to match Go's logic
	SQLType_SQLTypeInsertOnDuplicateUpdate SQLType = 102
	SQLType_SQLTypeMulti                   SQLType = 1044 // Adjusted the value to match Go's logic
	SQLType_SQLTypeUnknown                 SQLType = 1045
)

// Enum value maps for SQLType.
var (
	SQLType_name = map[int32]string{
		0:    "SQLTypeSelect",
		1:    "SQLTypeInsert",
		2:    "SQLTypeUpdate",
		3:    "SQLTypeDelete",
		4:    "SQLTypeSelectForUpdate",
		5:    "SQLTypeReplace",
		6:    "SQLTypeTruncate",
		7:    "SQLTypeCreate",
		8:    "SQLTypeDrop",
		9:    "SQLTypeLoad",
		10:   "SQLTypeMerge",
		11:   "SQLTypeShow",
		12:   "SQLTypeAlter",
		13:   "SQLTypeRename",
		14:   "SQLTypeDump",
		15:   "SQLTypeDebug",
		16:   "SQLTypeExplain",
		17:   "SQLTypeProcedure",
		18:   "SQLTypeDesc",
		19:   "SQLLastInsertID",
		20:   "SQLSelectWithoutTable",
		21:   "SQLCreateSequence",
		22:   "SQLShowSequence",
		23:   "SQLGetSequence",
		24:   "SQLAlterSequence",
		25:   "SQLDropSequence",
		26:   "SQLTddlShow",
		27:   "SQLTypeSet",
		28:   "SQLTypeReload",
		29:   "SQLTypeSelectUnion",
		30:   "SQLTypeCreateTable",
		31:   "SQLTypeDropTable",
		32:   "SQLTypeAlterTable",
		33:   "SQLTypeSavePoint",
		34:   "SQLTypeSelectFromUpdate",
		35:   "SQLTypeMultiDelete",
		36:   "SQLTypeMultiUpdate",
		37:   "SQLTypeCreateIndex",
		38:   "SQLTypeDropIndex",
		39:   "SQLTypeKill",
		40:   "SQLTypeLockTables",
		41:   "SQLTypeUnLockTables",
		42:   "SQLTypeCheckTable",
		43:   "SQLTypeSelectFoundRows",
		101:  "SQLTypeInsertIgnore",
		102:  "SQLTypeInsertOnDuplicateUpdate",
		1044: "SQLTypeMulti",
		1045: "SQLTypeUnknown",
	}
	SQLType_value = map[string]int32{
		"SQLTypeSelect":                  0,
		"SQLTypeInsert":                  1,
		"SQLTypeUpdate":                  2,
		"SQLTypeDelete":                  3,
		"SQLTypeSelectForUpdate":         4,
		"SQLTypeReplace":                 5,
		"SQLTypeTruncate":                6,
		"SQLTypeCreate":                  7,
		"SQLTypeDrop":                    8,
		"SQLTypeLoad":                    9,
		"SQLTypeMerge":                   10,
		"SQLTypeShow":                    11,
		"SQLTypeAlter":                   12,
		"SQLTypeRename":                  13,
		"SQLTypeDump":                    14,
		"SQLTypeDebug":                   15,
		"SQLTypeExplain":                 16,
		"SQLTypeProcedure":               17,
		"SQLTypeDesc":                    18,
		"SQLLastInsertID":                19,
		"SQLSelectWithoutTable":          20,
		"SQLCreateSequence":              21,
		"SQLShowSequence":                22,
		"SQLGetSequence":                 23,
		"SQLAlterSequence":               24,
		"SQLDropSequence":                25,
		"SQLTddlShow":                    26,
		"SQLTypeSet":                     27,
		"SQLTypeReload":                  28,
		"SQLTypeSelectUnion":             29,
		"SQLTypeCreateTable":             30,
		"SQLTypeDropTable":               31,
		"SQLTypeAlterTable":              32,
		"SQLTypeSavePoint":               33,
		"SQLTypeSelectFromUpdate":        34,
		"SQLTypeMultiDelete":             35,
		"SQLTypeMultiUpdate":             36,
		"SQLTypeCreateIndex":             37,
		"SQLTypeDropIndex":               38,
		"SQLTypeKill":                    39,
		"SQLTypeLockTables":              40,
		"SQLTypeUnLockTables":            41,
		"SQLTypeCheckTable":              42,
		"SQLTypeSelectFoundRows":         43,
		"SQLTypeInsertIgnore":            101,
		"SQLTypeInsertOnDuplicateUpdate": 102,
		"SQLTypeMulti":                   1044,
		"SQLTypeUnknown":                 1045,
	}
)

func (x SQLType) Enum() *SQLType {
	p := new(SQLType)
	*p = x
	return p
}

func (x SQLType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SQLType) Descriptor() protoreflect.EnumDescriptor {
	return file_branch_undo_log_proto_enumTypes[2].Descriptor()
}

func (SQLType) Type() protoreflect.EnumType {
	return &file_branch_undo_log_proto_enumTypes[2]
}

func (x SQLType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SQLType.Descriptor instead.
func (SQLType) EnumDescriptor() ([]byte, []int) {
	return file_branch_undo_log_proto_rawDescGZIP(), []int{2}
}

type BranchUndoLog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Xid      string        `protobuf:"bytes,1,opt,name=Xid,proto3" json:"Xid,omitempty"`
	BranchID uint64        `protobuf:"varint,2,opt,name=BranchID,proto3" json:"BranchID,omitempty"`
	Logs     []*SQLUndoLog `protobuf:"bytes,3,rep,name=Logs,proto3" json:"Logs,omitempty"`
}

func (x *BranchUndoLog) Reset() {
	*x = BranchUndoLog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_branch_undo_log_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BranchUndoLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BranchUndoLog) ProtoMessage() {}

func (x *BranchUndoLog) ProtoReflect() protoreflect.Message {
	mi := &file_branch_undo_log_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BranchUndoLog.ProtoReflect.Descriptor instead.
func (*BranchUndoLog) Descriptor() ([]byte, []int) {
	return file_branch_undo_log_proto_rawDescGZIP(), []int{0}
}

func (x *BranchUndoLog) GetXid() string {
	if x != nil {
		return x.Xid
	}
	return ""
}

func (x *BranchUndoLog) GetBranchID() uint64 {
	if x != nil {
		return x.BranchID
	}
	return 0
}

func (x *BranchUndoLog) GetLogs() []*SQLUndoLog {
	if x != nil {
		return x.Logs
	}
	return nil
}

type SQLUndoLog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SQLType     SQLType      `protobuf:"varint,1,opt,name=SQLType,proto3,enum=parser.SQLType" json:"SQLType,omitempty"`
	TableName   string       `protobuf:"bytes,2,opt,name=TableName,proto3" json:"TableName,omitempty"`
	BeforeImage *RecordImage `protobuf:"bytes,3,opt,name=BeforeImage,proto3" json:"BeforeImage,omitempty"`
	AfterImage  *RecordImage `protobuf:"bytes,4,opt,name=AfterImage,proto3" json:"AfterImage,omitempty"`
}

func (x *SQLUndoLog) Reset() {
	*x = SQLUndoLog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_branch_undo_log_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SQLUndoLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SQLUndoLog) ProtoMessage() {}

func (x *SQLUndoLog) ProtoReflect() protoreflect.Message {
	mi := &file_branch_undo_log_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SQLUndoLog.ProtoReflect.Descriptor instead.
func (*SQLUndoLog) Descriptor() ([]byte, []int) {
	return file_branch_undo_log_proto_rawDescGZIP(), []int{1}
}

func (x *SQLUndoLog) GetSQLType() SQLType {
	if x != nil {
		return x.SQLType
	}
	return SQLType_SQLTypeSelect
}

func (x *SQLUndoLog) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *SQLUndoLog) GetBeforeImage() *RecordImage {
	if x != nil {
		return x.BeforeImage
	}
	return nil
}

func (x *SQLUndoLog) GetAfterImage() *RecordImage {
	if x != nil {
		return x.AfterImage
	}
	return nil
}

type RecordImage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Index     int32       `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	TableName string      `protobuf:"bytes,2,opt,name=TableName,proto3" json:"TableName,omitempty"`
	SQLType   SQLType     `protobuf:"varint,3,opt,name=SQLType,proto3,enum=parser.SQLType" json:"SQLType,omitempty"`
	Rows      []*RowImage `protobuf:"bytes,4,rep,name=Rows,proto3" json:"Rows,omitempty"`
	TableMeta *TableMeta  `protobuf:"bytes,5,opt,name=TableMeta,proto3" json:"TableMeta,omitempty"`
}

func (x *RecordImage) Reset() {
	*x = RecordImage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_branch_undo_log_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordImage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordImage) ProtoMessage() {}

func (x *RecordImage) ProtoReflect() protoreflect.Message {
	mi := &file_branch_undo_log_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordImage.ProtoReflect.Descriptor instead.
func (*RecordImage) Descriptor() ([]byte, []int) {
	return file_branch_undo_log_proto_rawDescGZIP(), []int{2}
}

func (x *RecordImage) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *RecordImage) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *RecordImage) GetSQLType() SQLType {
	if x != nil {
		return x.SQLType
	}
	return SQLType_SQLTypeSelect
}

func (x *RecordImage) GetRows() []*RowImage {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *RecordImage) GetTableMeta() *TableMeta {
	if x != nil {
		return x.TableMeta
	}
	return nil
}

type RowImage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Columns []*ColumnImage `protobuf:"bytes,1,rep,name=Columns,proto3" json:"Columns,omitempty"`
}

func (x *RowImage) Reset() {
	*x = RowImage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_branch_undo_log_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RowImage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RowImage) ProtoMessage() {}

func (x *RowImage) ProtoReflect() protoreflect.Message {
	mi := &file_branch_undo_log_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RowImage.ProtoReflect.Descriptor instead.
func (*RowImage) Descriptor() ([]byte, []int) {
	return file_branch_undo_log_proto_rawDescGZIP(), []int{3}
}

func (x *RowImage) GetColumns() []*ColumnImage {
	if x != nil {
		return x.Columns
	}
	return nil
}

type ColumnImage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KeyType    IndexType  `protobuf:"varint,1,opt,name=KeyType,proto3,enum=parser.IndexType" json:"KeyType,omitempty"`
	ColumnName string     `protobuf:"bytes,2,opt,name=ColumnName,proto3" json:"ColumnName,omitempty"`
	ColumnType JDBCType   `protobuf:"varint,3,opt,name=ColumnType,proto3,enum=parser.JDBCType" json:"ColumnType,omitempty"`
	Value      *anypb.Any `protobuf:"bytes,4,opt,name=Value,proto3" json:"Value,omitempty"`
}

func (x *ColumnImage) Reset() {
	*x = ColumnImage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_branch_undo_log_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColumnImage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnImage) ProtoMessage() {}

func (x *ColumnImage) ProtoReflect() protoreflect.Message {
	mi := &file_branch_undo_log_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColumnImage.ProtoReflect.Descriptor instead.
func (*ColumnImage) Descriptor() ([]byte, []int) {
	return file_branch_undo_log_proto_rawDescGZIP(), []int{4}
}

func (x *ColumnImage) GetKeyType() IndexType {
	if x != nil {
		return x.KeyType
	}
	return IndexType_IndexTypeNull
}

func (x *ColumnImage) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

func (x *ColumnImage) GetColumnType() JDBCType {
	if x != nil {
		return x.ColumnType
	}
	return JDBCType_JDBCTypeNull
}

func (x *ColumnImage) GetValue() *anypb.Any {
	if x != nil {
		return x.Value
	}
	return nil
}

type TableMeta struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TableName   string                 `protobuf:"bytes,1,opt,name=TableName,proto3" json:"TableName,omitempty"`
	Columns     map[string]*ColumnMeta `protobuf:"bytes,2,rep,name=Columns,proto3" json:"Columns,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Indexs      map[string]*IndexMeta  `protobuf:"bytes,3,rep,name=Indexs,proto3" json:"Indexs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ColumnNames []string               `protobuf:"bytes,4,rep,name=ColumnNames,proto3" json:"ColumnNames,omitempty"`
}

func (x *TableMeta) Reset() {
	*x = TableMeta{}
	if protoimpl.UnsafeEnabled {
		mi := &file_branch_undo_log_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableMeta) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableMeta) ProtoMessage() {}

func (x *TableMeta) ProtoReflect() protoreflect.Message {
	mi := &file_branch_undo_log_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableMeta.ProtoReflect.Descriptor instead.
func (*TableMeta) Descriptor() ([]byte, []int) {
	return file_branch_undo_log_proto_rawDescGZIP(), []int{5}
}

func (x *TableMeta) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *TableMeta) GetColumns() map[string]*ColumnMeta {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *TableMeta) GetIndexs() map[string]*IndexMeta {
	if x != nil {
		return x.Indexs
	}
	return nil
}

func (x *TableMeta) GetColumnNames() []string {
	if x != nil {
		return x.ColumnNames
	}
	return nil
}

type ColumnMeta struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Schema             string `protobuf:"bytes,1,opt,name=Schema,proto3" json:"Schema,omitempty"`
	Table              string `protobuf:"bytes,2,opt,name=Table,proto3" json:"Table,omitempty"`
	ColumnDef          []byte `protobuf:"bytes,3,opt,name=ColumnDef,proto3" json:"ColumnDef,omitempty"`
	Autoincrement      bool   `protobuf:"varint,4,opt,name=Autoincrement,proto3" json:"Autoincrement,omitempty"`
	ColumnName         string `protobuf:"bytes,5,opt,name=ColumnName,proto3" json:"ColumnName,omitempty"`
	ColumnType         string `protobuf:"bytes,6,opt,name=ColumnType,proto3" json:"ColumnType,omitempty"`
	DatabaseType       int32  `protobuf:"varint,7,opt,name=DatabaseType,proto3" json:"DatabaseType,omitempty"`
	DatabaseTypeString string `protobuf:"bytes,8,opt,name=DatabaseTypeString,proto3" json:"DatabaseTypeString,omitempty"`
	ColumnKey          string `protobuf:"bytes,9,opt,name=ColumnKey,proto3" json:"ColumnKey,omitempty"`
	IsNullable         int32  `protobuf:"varint,10,opt,name=IsNullable,proto3" json:"IsNullable,omitempty"`
	Extra              string `protobuf:"bytes,11,opt,name=Extra,proto3" json:"Extra,omitempty"`
}

func (x *ColumnMeta) Reset() {
	*x = ColumnMeta{}
	if protoimpl.UnsafeEnabled {
		mi := &file_branch_undo_log_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColumnMeta) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnMeta) ProtoMessage() {}

func (x *ColumnMeta) ProtoReflect() protoreflect.Message {
	mi := &file_branch_undo_log_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColumnMeta.ProtoReflect.Descriptor instead.
func (*ColumnMeta) Descriptor() ([]byte, []int) {
	return file_branch_undo_log_proto_rawDescGZIP(), []int{6}
}

func (x *ColumnMeta) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

func (x *ColumnMeta) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *ColumnMeta) GetColumnDef() []byte {
	if x != nil {
		return x.ColumnDef
	}
	return nil
}

func (x *ColumnMeta) GetAutoincrement() bool {
	if x != nil {
		return x.Autoincrement
	}
	return false
}

func (x *ColumnMeta) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

func (x *ColumnMeta) GetColumnType() string {
	if x != nil {
		return x.ColumnType
	}
	return ""
}

func (x *ColumnMeta) GetDatabaseType() int32 {
	if x != nil {
		return x.DatabaseType
	}
	return 0
}

func (x *ColumnMeta) GetDatabaseTypeString() string {
	if x != nil {
		return x.DatabaseTypeString
	}
	return ""
}

func (x *ColumnMeta) GetColumnKey() string {
	if x != nil {
		return x.ColumnKey
	}
	return ""
}

func (x *ColumnMeta) GetIsNullable() int32 {
	if x != nil {
		return x.IsNullable
	}
	return 0
}

func (x *ColumnMeta) GetExtra() string {
	if x != nil {
		return x.Extra
	}
	return ""
}

type IndexMeta struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Schema     string        `protobuf:"bytes,1,opt,name=Schema,proto3" json:"Schema,omitempty"`
	Table      string        `protobuf:"bytes,2,opt,name=Table,proto3" json:"Table,omitempty"`
	Name       string        `protobuf:"bytes,3,opt,name=Name,proto3" json:"Name,omitempty"`
	ColumnName string        `protobuf:"bytes,4,opt,name=ColumnName,proto3" json:"ColumnName,omitempty"`
	IType      IndexType     `protobuf:"varint,5,opt,name=IType,proto3,enum=parser.IndexType" json:"IType,omitempty"`
	Columns    []*ColumnMeta `protobuf:"bytes,6,rep,name=Columns,proto3" json:"Columns,omitempty"`
}

func (x *IndexMeta) Reset() {
	*x = IndexMeta{}
	if protoimpl.UnsafeEnabled {
		mi := &file_branch_undo_log_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexMeta) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexMeta) ProtoMessage() {}

func (x *IndexMeta) ProtoReflect() protoreflect.Message {
	mi := &file_branch_undo_log_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexMeta.ProtoReflect.Descriptor instead.
func (*IndexMeta) Descriptor() ([]byte, []int) {
	return file_branch_undo_log_proto_rawDescGZIP(), []int{7}
}

func (x *IndexMeta) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

func (x *IndexMeta) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *IndexMeta) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IndexMeta) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

func (x *IndexMeta) GetIType() IndexType {
	if x != nil {
		return x.IType
	}
	return IndexType_IndexTypeNull
}

func (x *IndexMeta) GetColumns() []*ColumnMeta {
	if x != nil {
		return x.Columns
	}
	return nil
}

var File_branch_undo_log_proto protoreflect.FileDescriptor

var file_branch_undo_log_proto_rawDesc = []byte{
	0x0a, 0x15, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x5f, 0x75, 0x6e, 0x64, 0x6f, 0x5f, 0x6c, 0x6f,
	0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x65, 0x0a, 0x0d, 0x42, 0x72,
	0x61, 0x6e, 0x63, 0x68, 0x55, 0x6e, 0x64, 0x6f, 0x4c, 0x6f, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x58,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x58, 0x69, 0x64, 0x12, 0x1a, 0x0a,
	0x08, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x08, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x49, 0x44, 0x12, 0x26, 0x0a, 0x04, 0x4c, 0x6f, 0x67,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72,
	0x2e, 0x53, 0x51, 0x4c, 0x55, 0x6e, 0x64, 0x6f, 0x4c, 0x6f, 0x67, 0x52, 0x04, 0x4c, 0x6f, 0x67,
	0x73, 0x22, 0xc1, 0x01, 0x0a, 0x0a, 0x53, 0x51, 0x4c, 0x55, 0x6e, 0x64, 0x6f, 0x4c, 0x6f, 0x67,
	0x12, 0x29, 0x0a, 0x07, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x0f, 0x2e, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72, 0x2e, 0x53, 0x51, 0x4c, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x07, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x0b, 0x42, 0x65, 0x66,
	0x6f, 0x72, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x52, 0x0b, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x12, 0x33, 0x0a, 0x0a, 0x41, 0x66, 0x74, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72, 0x2e, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x0a, 0x41, 0x66, 0x74, 0x65, 0x72,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x22, 0xc3, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1c, 0x0a, 0x09, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x07, 0x53, 0x51, 0x4c,
	0x54, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0f, 0x2e, 0x70, 0x61, 0x72,
	0x73, 0x65, 0x72, 0x2e, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x53, 0x51, 0x4c,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x04, 0x52, 0x6f, 0x77, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72, 0x2e, 0x52, 0x6f, 0x77, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x52, 0x04, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x2f, 0x0a, 0x09, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x70, 0x61, 0x72, 0x73, 0x65, 0x72, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x52, 0x09, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x22, 0x39, 0x0a, 0x08, 0x52,
	0x6f, 0x77, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x2d, 0x0a, 0x07, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x61, 0x72, 0x73, 0x65,
	0x72, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x07, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x22, 0xb8, 0x01, 0x0a, 0x0b, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x2b, 0x0a, 0x07, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x11, 0x2e, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72,
	0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x4b, 0x65, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x0a, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72,
	0x2e, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x05, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x22, 0xda, 0x02, 0x0a, 0x09, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x12,
	0x1c, 0x0a, 0x09, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a,
	0x07, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07,
	0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x35, 0x0a, 0x06, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72,
	0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x73, 0x12, 0x20,
	0x0a, 0x0b, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x1a, 0x4e, 0x0a, 0x0c, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x28, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x4c, 0x0a, 0x0b, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x27, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x11, 0x2e, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4d,
	0x65, 0x74, 0x61, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xe6,
	0x02, 0x0a, 0x0a, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x16, 0x0a,
	0x06, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x14, 0x0a, 0x05, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x44, 0x65, 0x66, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09,
	0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x44, 0x65, 0x66, 0x12, 0x24, 0x0a, 0x0d, 0x41, 0x75, 0x74,
	0x6f, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x41, 0x75, 0x74, 0x6f, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x1e, 0x0a, 0x0a, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1e, 0x0a, 0x0a, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x22, 0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x2e, 0x0a, 0x12, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x12, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x12, 0x1c, 0x0a, 0x09, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4b, 0x65, 0x79,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4b, 0x65,
	0x79, 0x12, 0x1e, 0x0a, 0x0a, 0x49, 0x73, 0x4e, 0x75, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x49, 0x73, 0x4e, 0x75, 0x6c, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x45, 0x78, 0x74, 0x72, 0x61, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x45, 0x78, 0x74, 0x72, 0x61, 0x22, 0xc4, 0x01, 0x0a, 0x09, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x16, 0x0a, 0x06, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x14, 0x0a,
	0x05, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x05, 0x49, 0x54, 0x79, 0x70, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x11, 0x2e, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72, 0x2e,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x52, 0x05, 0x49, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x2c, 0x0a, 0x07, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x07, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x2a, 0x37,
	0x0a, 0x09, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x12, 0x11, 0x0a, 0x0d, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x4e, 0x75, 0x6c, 0x6c, 0x10, 0x00, 0x12, 0x17,
	0x0a, 0x13, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x4b, 0x65, 0x79, 0x10, 0x01, 0x2a, 0xb4, 0x07, 0x0a, 0x08, 0x4a, 0x44, 0x42, 0x43,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x0c, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65,
	0x4e, 0x75, 0x6c, 0x6c, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x0b, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x69, 0x74, 0x10, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
	0x12, 0x1c, 0x0a, 0x0f, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x54, 0x69, 0x6e, 0x79,
	0x49, 0x6e, 0x74, 0x10, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x14,
	0x0a, 0x10, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x53, 0x6d, 0x61, 0x6c, 0x6c, 0x49,
	0x6e, 0x74, 0x10, 0x05, 0x12, 0x13, 0x0a, 0x0f, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65,
	0x49, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x10, 0x04, 0x12, 0x1b, 0x0a, 0x0e, 0x4a, 0x44, 0x42,
	0x43, 0x54, 0x79, 0x70, 0x65, 0x42, 0x69, 0x67, 0x49, 0x6e, 0x74, 0x10, 0xfb, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79,
	0x70, 0x65, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x10, 0x06, 0x12, 0x10, 0x0a, 0x0c, 0x4a, 0x44, 0x42,
	0x43, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x61, 0x6c, 0x10, 0x07, 0x12, 0x12, 0x0a, 0x0e, 0x4a,
	0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x10, 0x08, 0x12,
	0x14, 0x0a, 0x10, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x69, 0x63, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70,
	0x65, 0x44, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c, 0x4a, 0x44,
	0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x43, 0x68, 0x61, 0x72, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f,
	0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x56, 0x61, 0x72, 0x63, 0x68, 0x61, 0x72, 0x10,
	0x0c, 0x12, 0x20, 0x0a, 0x13, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x6f, 0x6e,
	0x67, 0x56, 0x61, 0x72, 0x63, 0x68, 0x61, 0x72, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x44,
	0x61, 0x74, 0x65, 0x10, 0x5b, 0x12, 0x10, 0x0a, 0x0c, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x10, 0x5c, 0x12, 0x15, 0x0a, 0x11, 0x4a, 0x44, 0x42, 0x43, 0x54,
	0x79, 0x70, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x10, 0x5d, 0x12, 0x1b,
	0x0a, 0x0e, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79,
	0x10, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x1e, 0x0a, 0x11, 0x4a,
	0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x56, 0x61, 0x72, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79,
	0x10, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x22, 0x0a, 0x15, 0x4a,
	0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x6f, 0x6e, 0x67, 0x56, 0x61, 0x72, 0x42, 0x69,
	0x6e, 0x61, 0x72, 0x79, 0x10, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12,
	0x12, 0x0a, 0x0d, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x74, 0x68, 0x65, 0x72,
	0x10, 0xd7, 0x08, 0x12, 0x17, 0x0a, 0x12, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x4a,
	0x61, 0x76, 0x61, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x10, 0xd0, 0x0f, 0x12, 0x15, 0x0a, 0x10,
	0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x44, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74,
	0x10, 0xd1, 0x0f, 0x12, 0x13, 0x0a, 0x0e, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x10, 0xd2, 0x0f, 0x12, 0x12, 0x0a, 0x0d, 0x4a, 0x44, 0x42, 0x43,
	0x54, 0x79, 0x70, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x10, 0xd3, 0x0f, 0x12, 0x11, 0x0a, 0x0c,
	0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x42, 0x6c, 0x6f, 0x62, 0x10, 0xd4, 0x0f, 0x12,
	0x11, 0x0a, 0x0c, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6c, 0x6f, 0x62, 0x10,
	0xd5, 0x0f, 0x12, 0x10, 0x0a, 0x0b, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65,
	0x66, 0x10, 0xd6, 0x0f, 0x12, 0x14, 0x0a, 0x10, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65,
	0x44, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x10, 0x46, 0x12, 0x13, 0x0a, 0x0f, 0x4a, 0x44,
	0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x42, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x10, 0x10, 0x12,
	0x1a, 0x0a, 0x0d, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x52, 0x6f, 0x77, 0x49, 0x44,
	0x10, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x1a, 0x0a, 0x0d, 0x4a,
	0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x4e, 0x63, 0x68, 0x61, 0x72, 0x10, 0xf1, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x1d, 0x0a, 0x10, 0x4a, 0x44, 0x42, 0x43, 0x54,
	0x79, 0x70, 0x65, 0x4e, 0x76, 0x61, 0x72, 0x63, 0x68, 0x61, 0x72, 0x10, 0xf7, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x22, 0x0a, 0x15, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79,
	0x70, 0x65, 0x4c, 0x6f, 0x6e, 0x67, 0x4e, 0x76, 0x56, 0x61, 0x72, 0x63, 0x68, 0x61, 0x72, 0x10,
	0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x12, 0x0a, 0x0d, 0x4a, 0x44,
	0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x4e, 0x63, 0x6c, 0x6f, 0x62, 0x10, 0xdb, 0x0f, 0x12, 0x13,
	0x0a, 0x0e, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x53, 0x71, 0x6c, 0x58, 0x4d, 0x4c,
	0x10, 0xd9, 0x0f, 0x12, 0x16, 0x0a, 0x11, 0x4a, 0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x65, 0x66, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x10, 0xdc, 0x0f, 0x12, 0x1d, 0x0a, 0x18, 0x4a,
	0x44, 0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x74, 0x68, 0x54,
	0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x10, 0xdd, 0x0f, 0x12, 0x22, 0x0a, 0x1d, 0x4a, 0x44,
	0x42, 0x43, 0x54, 0x79, 0x70, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x57,
	0x69, 0x74, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x7a, 0x6f, 0x6e, 0x65, 0x10, 0xde, 0x0f, 0x2a, 0x8b,
	0x08, 0x0a, 0x07, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x51,
	0x4c, 0x54, 0x79, 0x70, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x10, 0x00, 0x12, 0x11, 0x0a,
	0x0d, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x10, 0x01,
	0x12, 0x11, 0x0a, 0x0d, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x10, 0x03, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70,
	0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x46, 0x6f, 0x72, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x10, 0x05, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70,
	0x65, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d, 0x53,
	0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x10, 0x07, 0x12, 0x0f,
	0x0a, 0x0b, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x44, 0x72, 0x6f, 0x70, 0x10, 0x08, 0x12,
	0x0f, 0x0a, 0x0b, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x6f, 0x61, 0x64, 0x10, 0x09,
	0x12, 0x10, 0x0a, 0x0c, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x4d, 0x65, 0x72, 0x67, 0x65,
	0x10, 0x0a, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x53, 0x68, 0x6f,
	0x77, 0x10, 0x0b, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x41, 0x6c,
	0x74, 0x65, 0x72, 0x10, 0x0c, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x10, 0x0d, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x51, 0x4c, 0x54,
	0x79, 0x70, 0x65, 0x44, 0x75, 0x6d, 0x70, 0x10, 0x0e, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x51, 0x4c,
	0x54, 0x79, 0x70, 0x65, 0x44, 0x65, 0x62, 0x75, 0x67, 0x10, 0x0f, 0x12, 0x12, 0x0a, 0x0e, 0x53,
	0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x10, 0x10, 0x12,
	0x14, 0x0a, 0x10, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x64,
	0x75, 0x72, 0x65, 0x10, 0x11, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65,
	0x44, 0x65, 0x73, 0x63, 0x10, 0x12, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x51, 0x4c, 0x4c, 0x61, 0x73,
	0x74, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x49, 0x44, 0x10, 0x13, 0x12, 0x19, 0x0a, 0x15, 0x53,
	0x51, 0x4c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x57, 0x69, 0x74, 0x68, 0x6f, 0x75, 0x74, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x10, 0x14, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x51, 0x4c, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x10, 0x15, 0x12, 0x13, 0x0a,
	0x0f, 0x53, 0x51, 0x4c, 0x53, 0x68, 0x6f, 0x77, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65,
	0x10, 0x16, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x51, 0x4c, 0x47, 0x65, 0x74, 0x53, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x65, 0x10, 0x17, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x51, 0x4c, 0x41, 0x6c, 0x74,
	0x65, 0x72, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x10, 0x18, 0x12, 0x13, 0x0a, 0x0f,
	0x53, 0x51, 0x4c, 0x44, 0x72, 0x6f, 0x70, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x10,
	0x19, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x51, 0x4c, 0x54, 0x64, 0x64, 0x6c, 0x53, 0x68, 0x6f, 0x77,
	0x10, 0x1a, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x53, 0x65, 0x74,
	0x10, 0x1b, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x6c,
	0x6f, 0x61, 0x64, 0x10, 0x1c, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x55, 0x6e, 0x69, 0x6f, 0x6e, 0x10, 0x1d, 0x12, 0x16, 0x0a,
	0x12, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x10, 0x1e, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65,
	0x44, 0x72, 0x6f, 0x70, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x10, 0x1f, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x10, 0x20, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x53, 0x61, 0x76,
	0x65, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x10, 0x21, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x51, 0x4c, 0x54,
	0x79, 0x70, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x46, 0x72, 0x6f, 0x6d, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x10, 0x22, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65,
	0x4d, 0x75, 0x6c, 0x74, 0x69, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x10, 0x23, 0x12, 0x16, 0x0a,
	0x12, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x10, 0x24, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x10, 0x25, 0x12, 0x14, 0x0a,
	0x10, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x44, 0x72, 0x6f, 0x70, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x10, 0x26, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x4b, 0x69,
	0x6c, 0x6c, 0x10, 0x27, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x4c,
	0x6f, 0x63, 0x6b, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x10, 0x28, 0x12, 0x17, 0x0a, 0x13, 0x53,
	0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x55, 0x6e, 0x4c, 0x6f, 0x63, 0x6b, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x10, 0x29, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x10, 0x2a, 0x12, 0x1a, 0x0a, 0x16, 0x53,
	0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x46, 0x6f, 0x75, 0x6e,
	0x64, 0x52, 0x6f, 0x77, 0x73, 0x10, 0x2b, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x51, 0x4c, 0x54, 0x79,
	0x70, 0x65, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x10, 0x65,
	0x12, 0x22, 0x0a, 0x1e, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x49, 0x6e, 0x73, 0x65, 0x72,
	0x74, 0x4f, 0x6e, 0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x10, 0x66, 0x12, 0x11, 0x0a, 0x0c, 0x53, 0x51, 0x4c, 0x54, 0x79, 0x70, 0x65, 0x4d,
	0x75, 0x6c, 0x74, 0x69, 0x10, 0x94, 0x08, 0x12, 0x13, 0x0a, 0x0e, 0x53, 0x51, 0x4c, 0x54, 0x79,
	0x70, 0x65, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x10, 0x95, 0x08, 0x42, 0x0a, 0x5a, 0x08,
	0x2e, 0x3b, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_branch_undo_log_proto_rawDescOnce sync.Once
	file_branch_undo_log_proto_rawDescData = file_branch_undo_log_proto_rawDesc
)

func file_branch_undo_log_proto_rawDescGZIP() []byte {
	file_branch_undo_log_proto_rawDescOnce.Do(func() {
		file_branch_undo_log_proto_rawDescData = protoimpl.X.CompressGZIP(file_branch_undo_log_proto_rawDescData)
	})
	return file_branch_undo_log_proto_rawDescData
}

var file_branch_undo_log_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_branch_undo_log_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_branch_undo_log_proto_goTypes = []any{
	(IndexType)(0),        // 0: parser.IndexType
	(JDBCType)(0),         // 1: parser.JDBCType
	(SQLType)(0),          // 2: parser.SQLType
	(*BranchUndoLog)(nil), // 3: parser.BranchUndoLog
	(*SQLUndoLog)(nil),    // 4: parser.SQLUndoLog
	(*RecordImage)(nil),   // 5: parser.RecordImage
	(*RowImage)(nil),      // 6: parser.RowImage
	(*ColumnImage)(nil),   // 7: parser.ColumnImage
	(*TableMeta)(nil),     // 8: parser.TableMeta
	(*ColumnMeta)(nil),    // 9: parser.ColumnMeta
	(*IndexMeta)(nil),     // 10: parser.IndexMeta
	nil,                   // 11: parser.TableMeta.ColumnsEntry
	nil,                   // 12: parser.TableMeta.IndexsEntry
	(*anypb.Any)(nil),     // 13: google.protobuf.Any
}
var file_branch_undo_log_proto_depIdxs = []int32{
	4,  // 0: parser.BranchUndoLog.Logs:type_name -> parser.SQLUndoLog
	2,  // 1: parser.SQLUndoLog.SQLType:type_name -> parser.SQLType
	5,  // 2: parser.SQLUndoLog.BeforeImage:type_name -> parser.RecordImage
	5,  // 3: parser.SQLUndoLog.AfterImage:type_name -> parser.RecordImage
	2,  // 4: parser.RecordImage.SQLType:type_name -> parser.SQLType
	6,  // 5: parser.RecordImage.Rows:type_name -> parser.RowImage
	8,  // 6: parser.RecordImage.TableMeta:type_name -> parser.TableMeta
	7,  // 7: parser.RowImage.Columns:type_name -> parser.ColumnImage
	0,  // 8: parser.ColumnImage.KeyType:type_name -> parser.IndexType
	1,  // 9: parser.ColumnImage.ColumnType:type_name -> parser.JDBCType
	13, // 10: parser.ColumnImage.Value:type_name -> google.protobuf.Any
	11, // 11: parser.TableMeta.Columns:type_name -> parser.TableMeta.ColumnsEntry
	12, // 12: parser.TableMeta.Indexs:type_name -> parser.TableMeta.IndexsEntry
	0,  // 13: parser.IndexMeta.IType:type_name -> parser.IndexType
	9,  // 14: parser.IndexMeta.Columns:type_name -> parser.ColumnMeta
	9,  // 15: parser.TableMeta.ColumnsEntry.value:type_name -> parser.ColumnMeta
	10, // 16: parser.TableMeta.IndexsEntry.value:type_name -> parser.IndexMeta
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_branch_undo_log_proto_init() }
func file_branch_undo_log_proto_init() {
	if File_branch_undo_log_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_branch_undo_log_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*BranchUndoLog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_branch_undo_log_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*SQLUndoLog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_branch_undo_log_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*RecordImage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_branch_undo_log_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*RowImage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_branch_undo_log_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*ColumnImage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_branch_undo_log_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*TableMeta); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_branch_undo_log_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*ColumnMeta); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_branch_undo_log_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*IndexMeta); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_branch_undo_log_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_branch_undo_log_proto_goTypes,
		DependencyIndexes: file_branch_undo_log_proto_depIdxs,
		EnumInfos:         file_branch_undo_log_proto_enumTypes,
		MessageInfos:      file_branch_undo_log_proto_msgTypes,
	}.Build()
	File_branch_undo_log_proto = out.File
	file_branch_undo_log_proto_rawDesc = nil
	file_branch_undo_log_proto_goTypes = nil
	file_branch_undo_log_proto_depIdxs = nil
}
