/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

@GwtCompatible
public final class AtomicLongMap<K> {
    private final ConcurrentHashMap<K, AtomicLong> map;
    private transient Map<K, Long> asMap;

    private AtomicLongMap(ConcurrentHashMap<K, AtomicLong> map2) {
        this.map = Preconditions.checkNotNull(map2);
    }

    public static <K> AtomicLongMap<K> create() {
        return new AtomicLongMap(new ConcurrentHashMap());
    }

    public static <K> AtomicLongMap<K> create(Map<? extends K, ? extends Long> m) {
        AtomicLongMap<? extends K> result2 = AtomicLongMap.create();
        result2.putAll(m);
        return result2;
    }

    public long get(K key) {
        AtomicLong atomic2 = this.map.get(key);
        return atomic2 == null ? 0L : atomic2.get();
    }

    public long incrementAndGet(K key) {
        return this.addAndGet(key, 1L);
    }

    public long decrementAndGet(K key) {
        return this.addAndGet(key, -1L);
    }

    public long addAndGet(K key, long delta2) {
        long newValue;
        block0: while (true) {
            long oldValue;
            AtomicLong atomic2;
            if ((atomic2 = this.map.get(key)) == null && (atomic2 = this.map.putIfAbsent(key, new AtomicLong(delta2))) == null) {
                return delta2;
            }
            do {
                if ((oldValue = atomic2.get()) != 0L) continue;
                if (!this.map.replace(key, atomic2, new AtomicLong(delta2))) continue block0;
                return delta2;
            } while (!atomic2.compareAndSet(oldValue, newValue = oldValue + delta2));
            break;
        }
        return newValue;
    }

    public long getAndIncrement(K key) {
        return this.getAndAdd(key, 1L);
    }

    public long getAndDecrement(K key) {
        return this.getAndAdd(key, -1L);
    }

    public long getAndAdd(K key, long delta2) {
        long oldValue;
        block0: while (true) {
            long newValue;
            AtomicLong atomic2;
            if ((atomic2 = this.map.get(key)) == null && (atomic2 = this.map.putIfAbsent(key, new AtomicLong(delta2))) == null) {
                return 0L;
            }
            do {
                if ((oldValue = atomic2.get()) != 0L) continue;
                if (!this.map.replace(key, atomic2, new AtomicLong(delta2))) continue block0;
                return 0L;
            } while (!atomic2.compareAndSet(oldValue, newValue = oldValue + delta2));
            break;
        }
        return oldValue;
    }

    public long put(K key, long newValue) {
        long oldValue;
        block0: while (true) {
            AtomicLong atomic2;
            if ((atomic2 = this.map.get(key)) == null && (atomic2 = this.map.putIfAbsent(key, new AtomicLong(newValue))) == null) {
                return 0L;
            }
            do {
                if ((oldValue = atomic2.get()) != 0L) continue;
                if (!this.map.replace(key, atomic2, new AtomicLong(newValue))) continue block0;
                return 0L;
            } while (!atomic2.compareAndSet(oldValue, newValue));
            break;
        }
        return oldValue;
    }

    public void putAll(Map<? extends K, ? extends Long> m) {
        for (Map.Entry<K, Long> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public long remove(K key) {
        long oldValue;
        AtomicLong atomic2 = this.map.get(key);
        if (atomic2 == null) {
            return 0L;
        }
        while ((oldValue = atomic2.get()) != 0L && !atomic2.compareAndSet(oldValue, 0L)) {
        }
        this.map.remove(key, atomic2);
        return oldValue;
    }

    public void removeAllZeros() {
        for (Object key : this.map.keySet()) {
            AtomicLong atomic2 = this.map.get(key);
            if (atomic2 == null || atomic2.get() != 0L) continue;
            this.map.remove(key, atomic2);
        }
    }

    public long sum() {
        long sum2 = 0L;
        for (AtomicLong value2 : this.map.values()) {
            sum2 += value2.get();
        }
        return sum2;
    }

    public Map<K, Long> asMap() {
        Map<K, Long> result2 = this.asMap;
        return result2 == null ? (this.asMap = this.createAsMap()) : result2;
    }

    private Map<K, Long> createAsMap() {
        return Collections.unmodifiableMap(Maps.transformValues(this.map, new Function<AtomicLong, Long>(){

            @Override
            public Long apply(AtomicLong atomic2) {
                return atomic2.get();
            }
        }));
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }

    long putIfAbsent(K key, long newValue) {
        long oldValue;
        block2: {
            AtomicLong atomic2;
            do {
                if ((atomic2 = this.map.get(key)) == null && (atomic2 = this.map.putIfAbsent(key, new AtomicLong(newValue))) == null) {
                    return 0L;
                }
                oldValue = atomic2.get();
                if (oldValue != 0L) break block2;
            } while (!this.map.replace(key, atomic2, new AtomicLong(newValue)));
            return 0L;
        }
        return oldValue;
    }

    boolean replace(K key, long expectedOldValue, long newValue) {
        if (expectedOldValue == 0L) {
            return this.putIfAbsent(key, newValue) == 0L;
        }
        AtomicLong atomic2 = this.map.get(key);
        return atomic2 == null ? false : atomic2.compareAndSet(expectedOldValue, newValue);
    }

    boolean remove(K key, long value2) {
        AtomicLong atomic2 = this.map.get(key);
        if (atomic2 == null) {
            return false;
        }
        long oldValue = atomic2.get();
        if (oldValue != value2) {
            return false;
        }
        if (oldValue == 0L || atomic2.compareAndSet(oldValue, 0L)) {
            this.map.remove(key, atomic2);
            return true;
        }
        return false;
    }
}

