/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;
import joptsimple.ParserRules;
import joptsimple.internal.Classes;
import joptsimple.internal.Messages;
import joptsimple.internal.Rows;
import joptsimple.internal.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltinHelpFormatter
implements HelpFormatter {
    private final Rows nonOptionRows;
    private final Rows optionRows;

    BuiltinHelpFormatter() {
        this(80, 2);
    }

    public BuiltinHelpFormatter(int desiredOverallWidth, int desiredColumnSeparatorWidth) {
        this.nonOptionRows = new Rows(desiredOverallWidth * 2, 0);
        this.optionRows = new Rows(desiredOverallWidth, desiredColumnSeparatorWidth);
    }

    @Override
    public String format(Map<String, ? extends OptionDescriptor> options2) {
        Comparator<OptionDescriptor> comparator = new Comparator<OptionDescriptor>(){

            @Override
            public int compare(OptionDescriptor first2, OptionDescriptor second2) {
                return first2.options().iterator().next().compareTo(second2.options().iterator().next());
            }
        };
        TreeSet<OptionDescriptor> sorted2 = new TreeSet<OptionDescriptor>(comparator);
        sorted2.addAll(options2.values());
        this.addRows(sorted2);
        return this.formattedHelpOutput();
    }

    protected void addOptionRow(String single2) {
        this.addOptionRow(single2, "");
    }

    protected void addOptionRow(String left2, String right2) {
        this.optionRows.add(left2, right2);
    }

    protected void addNonOptionRow(String single2) {
        this.nonOptionRows.add(single2, "");
    }

    protected void fitRowsToWidth() {
        this.nonOptionRows.fitToWidth();
        this.optionRows.fitToWidth();
    }

    protected String nonOptionOutput() {
        return this.nonOptionRows.render();
    }

    protected String optionOutput() {
        return this.optionRows.render();
    }

    protected String formattedHelpOutput() {
        StringBuilder formatted = new StringBuilder();
        String nonOptionDisplay = this.nonOptionOutput();
        if (!Strings.isNullOrEmpty(nonOptionDisplay)) {
            formatted.append(nonOptionDisplay).append(Strings.LINE_SEPARATOR);
        }
        formatted.append(this.optionOutput());
        return formatted.toString();
    }

    protected void addRows(Collection<? extends OptionDescriptor> options2) {
        this.addNonOptionsDescription(options2);
        if (options2.isEmpty()) {
            this.addOptionRow(this.message("no.options.specified", new Object[0]));
        } else {
            this.addHeaders(options2);
            this.addOptions(options2);
        }
        this.fitRowsToWidth();
    }

    protected void addNonOptionsDescription(Collection<? extends OptionDescriptor> options2) {
        OptionDescriptor nonOptions = this.findAndRemoveNonOptionsSpec(options2);
        if (this.shouldShowNonOptionArgumentDisplay(nonOptions)) {
            this.addNonOptionRow(this.message("non.option.arguments.header", new Object[0]));
            this.addNonOptionRow(this.createNonOptionArgumentsDisplay(nonOptions));
        }
    }

    protected boolean shouldShowNonOptionArgumentDisplay(OptionDescriptor nonOptionDescriptor) {
        return !Strings.isNullOrEmpty(nonOptionDescriptor.description()) || !Strings.isNullOrEmpty(nonOptionDescriptor.argumentTypeIndicator()) || !Strings.isNullOrEmpty(nonOptionDescriptor.argumentDescription());
    }

    protected String createNonOptionArgumentsDisplay(OptionDescriptor nonOptionDescriptor) {
        StringBuilder buffer2 = new StringBuilder();
        this.maybeAppendOptionInfo(buffer2, nonOptionDescriptor);
        this.maybeAppendNonOptionsDescription(buffer2, nonOptionDescriptor);
        return buffer2.toString();
    }

    protected void maybeAppendNonOptionsDescription(StringBuilder buffer2, OptionDescriptor nonOptions) {
        buffer2.append(buffer2.length() > 0 && !Strings.isNullOrEmpty(nonOptions.description()) ? " -- " : "").append(nonOptions.description());
    }

    protected OptionDescriptor findAndRemoveNonOptionsSpec(Collection<? extends OptionDescriptor> options2) {
        Iterator<? extends OptionDescriptor> it = options2.iterator();
        while (it.hasNext()) {
            OptionDescriptor next2 = it.next();
            if (!next2.representsNonOptions()) continue;
            it.remove();
            return next2;
        }
        throw new AssertionError((Object)"no non-options argument spec");
    }

    protected void addHeaders(Collection<? extends OptionDescriptor> options2) {
        if (this.hasRequiredOption(options2)) {
            this.addOptionRow(this.message("option.header.with.required.indicator", new Object[0]), this.message("description.header", new Object[0]));
            this.addOptionRow(this.message("option.divider.with.required.indicator", new Object[0]), this.message("description.divider", new Object[0]));
        } else {
            this.addOptionRow(this.message("option.header", new Object[0]), this.message("description.header", new Object[0]));
            this.addOptionRow(this.message("option.divider", new Object[0]), this.message("description.divider", new Object[0]));
        }
    }

    protected final boolean hasRequiredOption(Collection<? extends OptionDescriptor> options2) {
        for (OptionDescriptor optionDescriptor : options2) {
            if (!optionDescriptor.isRequired()) continue;
            return true;
        }
        return false;
    }

    protected void addOptions(Collection<? extends OptionDescriptor> options2) {
        for (OptionDescriptor optionDescriptor : options2) {
            if (optionDescriptor.representsNonOptions()) continue;
            this.addOptionRow(this.createOptionDisplay(optionDescriptor), this.createDescriptionDisplay(optionDescriptor));
        }
    }

    protected String createOptionDisplay(OptionDescriptor descriptor) {
        StringBuilder buffer2 = new StringBuilder(descriptor.isRequired() ? "* " : "");
        Iterator<String> i = descriptor.options().iterator();
        while (i.hasNext()) {
            String option2 = i.next();
            buffer2.append(this.optionLeader(option2));
            buffer2.append(option2);
            if (!i.hasNext()) continue;
            buffer2.append(", ");
        }
        this.maybeAppendOptionInfo(buffer2, descriptor);
        return buffer2.toString();
    }

    protected String optionLeader(String option2) {
        return option2.length() > 1 ? "--" : ParserRules.HYPHEN;
    }

    protected void maybeAppendOptionInfo(StringBuilder buffer2, OptionDescriptor descriptor) {
        String indicator = this.extractTypeIndicator(descriptor);
        String description = descriptor.argumentDescription();
        if (indicator != null || !Strings.isNullOrEmpty(description)) {
            this.appendOptionHelp(buffer2, indicator, description, descriptor.requiresArgument());
        }
    }

    protected String extractTypeIndicator(OptionDescriptor descriptor) {
        String indicator = descriptor.argumentTypeIndicator();
        if (!Strings.isNullOrEmpty(indicator) && !String.class.getName().equals(indicator)) {
            return Classes.shortNameOf(indicator);
        }
        return null;
    }

    protected void appendOptionHelp(StringBuilder buffer2, String typeIndicator, String description, boolean required) {
        if (required) {
            this.appendTypeIndicator(buffer2, typeIndicator, description, '<', '>');
        } else {
            this.appendTypeIndicator(buffer2, typeIndicator, description, '[', ']');
        }
    }

    protected void appendTypeIndicator(StringBuilder buffer2, String typeIndicator, String description, char start2, char end2) {
        buffer2.append(' ').append(start2);
        if (typeIndicator != null) {
            buffer2.append(typeIndicator);
        }
        if (!Strings.isNullOrEmpty(description)) {
            if (typeIndicator != null) {
                buffer2.append(": ");
            }
            buffer2.append(description);
        }
        buffer2.append(end2);
    }

    protected String createDescriptionDisplay(OptionDescriptor descriptor) {
        List<?> defaultValues = descriptor.defaultValues();
        if (defaultValues.isEmpty()) {
            return descriptor.description();
        }
        String defaultValuesDisplay = this.createDefaultValuesDisplay(defaultValues);
        return (descriptor.description() + ' ' + Strings.surround(this.message("default.value.header", new Object[0]) + ' ' + defaultValuesDisplay, '(', ')')).trim();
    }

    protected String createDefaultValuesDisplay(List<?> defaultValues) {
        return defaultValues.size() == 1 ? defaultValues.get(0).toString() : defaultValues.toString();
    }

    protected String message(String keySuffix, Object ... args) {
        return Messages.message(Locale.getDefault(), "joptsimple.HelpFormatterMessages", BuiltinHelpFormatter.class, keySuffix, args);
    }
}

