/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.style;

import org.springframework.core.style.ToStringStyler;
import org.springframework.core.style.ValueStyler;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class DefaultToStringStyler
implements ToStringStyler {
    private final ValueStyler valueStyler;

    public DefaultToStringStyler(ValueStyler valueStyler) {
        Assert.notNull((Object)valueStyler, "ValueStyler must not be null");
        this.valueStyler = valueStyler;
    }

    protected final ValueStyler getValueStyler() {
        return this.valueStyler;
    }

    @Override
    public void styleStart(StringBuilder buffer2, Object obj2) {
        if (!obj2.getClass().isArray()) {
            buffer2.append('[').append(ClassUtils.getShortName(obj2.getClass()));
            this.styleIdentityHashCode(buffer2, obj2);
        } else {
            buffer2.append('[');
            this.styleIdentityHashCode(buffer2, obj2);
            buffer2.append(' ');
            this.styleValue(buffer2, obj2);
        }
    }

    private void styleIdentityHashCode(StringBuilder buffer2, Object obj2) {
        buffer2.append('@');
        buffer2.append(ObjectUtils.getIdentityHexString(obj2));
    }

    @Override
    public void styleEnd(StringBuilder buffer2, Object o) {
        buffer2.append(']');
    }

    @Override
    public void styleField(StringBuilder buffer2, String fieldName, @Nullable Object value2) {
        this.styleFieldStart(buffer2, fieldName);
        this.styleValue(buffer2, value2);
        this.styleFieldEnd(buffer2, fieldName);
    }

    protected void styleFieldStart(StringBuilder buffer2, String fieldName) {
        buffer2.append(' ').append(fieldName).append(" = ");
    }

    protected void styleFieldEnd(StringBuilder buffer2, String fieldName) {
    }

    @Override
    public void styleValue(StringBuilder buffer2, @Nullable Object value2) {
        buffer2.append(this.valueStyler.style(value2));
    }

    @Override
    public void styleFieldSeparator(StringBuilder buffer2) {
        buffer2.append(',');
    }
}

