/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

class DomContentHandler
implements ContentHandler {
    private final Document document;
    private final List<Element> elements = new ArrayList<Element>();
    private final Node node;

    DomContentHandler(Node node4) {
        this.node = node4;
        this.document = node4 instanceof Document ? (Document)node4 : node4.getOwnerDocument();
    }

    private Node getParent() {
        if (!this.elements.isEmpty()) {
            return this.elements.get(this.elements.size() - 1);
        }
        return this.node;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        Node parent2 = this.getParent();
        Element element2 = this.document.createElementNS(uri, qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attrUri = attributes.getURI(i);
            String attrQname = attributes.getQName(i);
            String value2 = attributes.getValue(i);
            if (attrQname.startsWith("xmlns")) continue;
            element2.setAttributeNS(attrUri, attrQname, value2);
        }
        element2 = (Element)parent2.appendChild(element2);
        this.elements.add(element2);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.elements.remove(this.elements.size() - 1);
    }

    @Override
    public void characters(char[] ch, int start2, int length2) {
        String data = new String(ch, start2, length2);
        Node parent2 = this.getParent();
        Node lastChild = parent2.getLastChild();
        if (lastChild != null && lastChild.getNodeType() == 3) {
            ((Text)lastChild).appendData(data);
        } else {
            Text text2 = this.document.createTextNode(data);
            parent2.appendChild(text2);
        }
    }

    @Override
    public void processingInstruction(String target, String data) {
        Node parent2 = this.getParent();
        ProcessingInstruction pi = this.document.createProcessingInstruction(target, data);
        parent2.appendChild(pi);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start2, int length2) {
    }

    @Override
    public void skippedEntity(String name) {
    }
}

