/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zeromq.ZConfig;
import org.zeromq.ZMQ;
import org.zeromq.util.ZDigest;
import org.zeromq.util.ZMetadata;

public class ZCertStore {
    private final File location;
    private final Map<File, byte[]> fingerprints = new HashMap<File, byte[]>();
    private final Map<String, ZMetadata> publicKeys = new HashMap<String, ZMetadata>();
    private final Fingerprinter finger;

    public ZCertStore(String location) {
        this(location, new Timestamper());
    }

    public ZCertStore(String location, Fingerprinter fingerprinter) {
        this.finger = fingerprinter;
        this.location = new File(location);
        this.loadFiles();
    }

    private boolean traverseDirectory(File root, IFileVisitor visitor) {
        assert (root.exists());
        assert (root.isDirectory());
        if (visitor.visitDir(root)) {
            return true;
        }
        for (File file2 : root.listFiles()) {
            if (file2.isFile()) {
                if (!visitor.visitFile(file2)) continue;
                return true;
            }
            if (file2.isDirectory()) {
                return this.traverseDirectory(file2, visitor);
            }
            System.out.printf("WARNING: %s is neither file nor directory? This shouldn't happen....SKIPPING%n", file2.getAbsolutePath());
        }
        return false;
    }

    public boolean containsPublicKey(byte[] publicKey) {
        if (publicKey.length != 32) {
            throw new RuntimeException("publickey needs to have a size of 32 bytes. got only " + publicKey.length);
        }
        return this.containsPublicKey(ZMQ.Curve.z85Encode(publicKey));
    }

    public boolean containsPublicKey(String publicKey) {
        if (publicKey.length() != 40) {
            throw new RuntimeException("z85 publickeys should have a length of 40 bytes but got " + publicKey.length());
        }
        this.reloadIfNecessary();
        return this.publicKeys.containsKey(publicKey);
    }

    public ZMetadata getMetadata(String publicKey) {
        this.reloadIfNecessary();
        return this.publicKeys.get(publicKey);
    }

    private void loadFiles() {
        final HashMap keys2 = new HashMap();
        if (!this.location.exists()) {
            this.location.mkdirs();
        }
        final HashMap collected = new HashMap();
        this.traverseDirectory(this.location, new IFileVisitor(){

            @Override
            public boolean visitFile(File file2) {
                try {
                    ZConfig zconf = ZConfig.load(file2.getAbsolutePath());
                    String publicKey = zconf.getValue("curve/public-key");
                    if (publicKey == null) {
                        System.out.printf("Warning!! File %s has no curve/public-key-element. SKIPPING!%n", file2.getAbsolutePath());
                        return false;
                    }
                    if (publicKey.length() == 32) {
                        publicKey = ZMQ.Curve.z85Encode(publicKey.getBytes(ZMQ.CHARSET));
                    }
                    assert (publicKey.length() == 40);
                    keys2.put(publicKey, ZMetadata.read(zconf));
                    collected.put(file2, ZCertStore.this.finger.print(file2));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return false;
            }

            @Override
            public boolean visitDir(File dir) {
                collected.put(dir, ZCertStore.this.finger.print(dir));
                return false;
            }
        });
        this.publicKeys.clear();
        this.publicKeys.putAll(keys2);
        this.fingerprints.clear();
        this.fingerprints.putAll(collected);
    }

    int getCertificatesCount() {
        this.reloadIfNecessary();
        return this.publicKeys.size();
    }

    boolean reloadIfNecessary() {
        if (this.checkForChanges()) {
            this.loadFiles();
            return true;
        }
        return false;
    }

    boolean checkForChanges() {
        final HashMap<File, byte[]> presents = new HashMap<File, byte[]>(this.fingerprints);
        boolean modified = this.traverseDirectory(this.location, new IFileVisitor(){

            @Override
            public boolean visitFile(File file2) {
                return ZCertStore.this.modified((byte[])presents.remove(file2), file2);
            }

            @Override
            public boolean visitDir(File dir) {
                return ZCertStore.this.modified((byte[])presents.remove(dir), dir);
            }
        });
        return modified || !presents.isEmpty();
    }

    private boolean modified(byte[] fingerprint, File path2) {
        if (!path2.exists()) {
            return true;
        }
        if (fingerprint == null) {
            return true;
        }
        return !Arrays.equals(fingerprint, this.finger.print(path2));
    }

    private static interface IFileVisitor {
        public boolean visitFile(File var1);

        public boolean visitDir(File var1);
    }

    public static final class Hasher
    implements Fingerprinter {
        private final byte[] buffer = new byte[8192];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] print(File path2) {
            InputStream input = this.stream(path2);
            if (input != null) {
                try {
                    byte[] byArray = new ZDigest(this.buffer).update(input).data();
                    return byArray;
                }
                catch (IOException e) {
                    byte[] byArray = null;
                    return byArray;
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }

        private InputStream stream(File path2) {
            if (path2.isFile()) {
                try {
                    return new FileInputStream(path2);
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
            if (path2.isDirectory()) {
                List<String> list2 = Arrays.asList(path2.list());
                Collections.sort(list2);
                return new ByteArrayInputStream(list2.toString().getBytes(ZMQ.CHARSET));
            }
            return null;
        }
    }

    public static final class Timestamper
    implements Fingerprinter {
        private final byte[] buf = new byte[8];

        @Override
        public byte[] print(File path2) {
            long value2 = path2.lastModified();
            this.buf[0] = (byte)(value2 >>> 56 & 0xFFL);
            this.buf[0] = (byte)(value2 >>> 48 & 0xFFL);
            this.buf[0] = (byte)(value2 >>> 40 & 0xFFL);
            this.buf[0] = (byte)(value2 >>> 32 & 0xFFL);
            this.buf[0] = (byte)(value2 >>> 24 & 0xFFL);
            this.buf[0] = (byte)(value2 >>> 16 & 0xFFL);
            this.buf[0] = (byte)(value2 >>> 8 & 0xFFL);
            this.buf[0] = (byte)(value2 & 0xFFL);
            return this.buf;
        }
    }

    public static interface Fingerprinter {
        public byte[] print(File var1);
    }
}

