/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.util;

import java.io.PrintStream;
import java.util.Arrays;
import org.zeromq.ZMQ;

public class ZData {
    private static final String HEX_CHAR = "0123456789ABCDEF";
    private final byte[] data;

    public ZData(byte[] data) {
        this.data = data;
    }

    public boolean streq(String str) {
        return ZData.streq(this.data, str);
    }

    public static boolean streq(byte[] data, String str) {
        if (data == null) {
            return false;
        }
        return new String(data, ZMQ.CHARSET).compareTo(str) == 0;
    }

    public boolean equals(byte[] that2) {
        return Arrays.equals(this.data, that2);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ZData that2 = (ZData)other;
        return Arrays.equals(this.data, that2.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return ZData.toString(this.data);
    }

    public static String toString(byte[] data) {
        if (data == null) {
            return "";
        }
        boolean isText = true;
        for (byte aData : data) {
            if (aData >= 32 && aData <= 127) continue;
            isText = false;
            break;
        }
        if (isText) {
            return new String(data, ZMQ.CHARSET);
        }
        return ZData.strhex(data);
    }

    public String strhex() {
        return ZData.strhex(this.data);
    }

    public static String strhex(byte[] data) {
        if (data == null) {
            return "";
        }
        StringBuilder b2 = new StringBuilder();
        for (byte aData : data) {
            int b1 = aData >>> 4 & 0xF;
            int b22 = aData & 0xF;
            b2.append(HEX_CHAR.charAt(b1));
            b2.append(HEX_CHAR.charAt(b22));
        }
        return b2.toString();
    }

    public void print(PrintStream out2, String prefix) {
        ZData.print(out2, prefix, this.data, this.data.length);
    }

    public static void print(PrintStream out2, String prefix, byte[] data, int size2) {
        int charNbr;
        if (data == null) {
            return;
        }
        if (prefix != null) {
            out2.printf("%s", prefix);
        }
        boolean isBin = false;
        for (charNbr = 0; charNbr < size2; ++charNbr) {
            if (data[charNbr] >= 9 && data[charNbr] <= 127) continue;
            isBin = true;
        }
        out2.printf("[%03d] ", size2);
        int maxSize = isBin ? 35 : 70;
        String elipsis = "";
        if (size2 > maxSize) {
            size2 = maxSize;
            elipsis = "...";
        }
        for (charNbr = 0; charNbr < size2; ++charNbr) {
            if (isBin) {
                out2.printf("%02X", data[charNbr]);
                continue;
            }
            out2.printf("%c", data[charNbr]);
        }
        out2.printf("%s\n", elipsis);
        out2.flush();
    }
}

