/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.channels.Selector;
import java.util.Arrays;
import zmq.Msg;
import zmq.SocketBase;
import zmq.ZMQ;
import zmq.poll.PollItem;

class Proxy {
    private State state = State.ACTIVE;

    public static boolean proxy(SocketBase frontend, SocketBase backend, SocketBase capture) {
        return new Proxy().start(frontend, backend, capture, null);
    }

    public static boolean proxy(SocketBase frontend, SocketBase backend, SocketBase capture, SocketBase control) {
        return new Proxy().start(frontend, backend, capture, control);
    }

    private Proxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean start(SocketBase frontend, SocketBase backend, SocketBase capture, SocketBase control) {
        int count2 = control == null ? 2 : 3;
        PollItem[] items = new PollItem[count2];
        items[0] = new PollItem(frontend, 1);
        items[1] = new PollItem(backend, 1);
        if (control != null) {
            items[2] = new PollItem(control, 1);
        }
        PollItem[] itemsout = new PollItem[]{new PollItem(frontend, 2), new PollItem(backend, 2)};
        Selector selector = frontend.getCtx().createSelector();
        try {
            while (this.state != State.TERMINATED) {
                boolean bl;
                int rc = ZMQ.poll(selector, items, -1L);
                if (rc < 0) {
                    bl = false;
                    return bl;
                }
                if (frontend != backend && (rc = ZMQ.poll(selector, itemsout, 0L)) < 0) {
                    bl = false;
                    return bl;
                }
                if (control != null && items[2].isReadable()) {
                    Msg msg = control.recv(0);
                    if (msg == null) {
                        bl = false;
                        return bl;
                    }
                    int more = control.getSocketOpt(13);
                    if (more < 0) {
                        bl = false;
                        return bl;
                    }
                    boolean success2 = this.capture(capture, msg, more);
                    if (!success2) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    byte[] command = msg.data();
                    if (Arrays.equals(command, ZMQ.PROXY_PAUSE)) {
                        this.state = State.PAUSED;
                    } else if (Arrays.equals(command, ZMQ.PROXY_RESUME)) {
                        this.state = State.ACTIVE;
                    } else if (Arrays.equals(command, ZMQ.PROXY_TERMINATE)) {
                        this.state = State.TERMINATED;
                    } else {
                        System.out.printf("E: invalid command sent to proxy '%s'%n", new String(command, ZMQ.CHARSET));
                        assert (false);
                    }
                }
                if (this.process(items[0], itemsout[1], frontend, backend) && !this.forward(frontend, backend, capture)) {
                    bl = false;
                    return bl;
                }
                if (!this.process(items[1], itemsout[0], frontend, backend) || this.forward(backend, frontend, capture)) continue;
                bl = false;
                return bl;
            }
        }
        finally {
            frontend.getCtx().closeSelector(selector);
        }
        return true;
    }

    private boolean process(PollItem read2, PollItem write2, SocketBase frontend, SocketBase backend) {
        return this.state == State.ACTIVE && read2.isReadable() && (frontend == backend || write2.isWritable());
    }

    private boolean forward(SocketBase from2, SocketBase to2, SocketBase capture) {
        int more;
        do {
            Msg msg;
            if ((msg = from2.recv(0)) == null) {
                return false;
            }
            more = from2.getSocketOpt(13);
            if (more < 0) {
                return false;
            }
            boolean success2 = this.capture(capture, msg, more);
            if (!success2) {
                return false;
            }
            success2 = to2.send(msg, more > 0 ? 2 : 0);
            if (success2) continue;
            return false;
        } while (more != 0);
        return true;
    }

    private boolean capture(SocketBase capture, Msg msg, int more) {
        Msg ctrl;
        boolean success2;
        return capture == null || (success2 = capture.send(ctrl = new Msg(msg), more > 0 ? 2 : 0));
    }

    public static enum State {
        ACTIVE,
        PAUSED,
        TERMINATED;

    }
}

