/*
 * Decompiled with CFR 0.152.
 */
package zmq.poll;

import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import zmq.SocketBase;

public class PollItem {
    private final SocketBase socket;
    private final SelectableChannel channel;
    private final int zinterest;
    private final int interest;
    private int ready;

    public PollItem(SocketBase socket, int ops) {
        this(socket, null, ops);
    }

    public PollItem(SelectableChannel channel, int ops) {
        this(null, channel, ops);
    }

    private PollItem(SocketBase socket, SelectableChannel channel, int ops) {
        this.socket = socket;
        this.channel = channel;
        this.zinterest = ops;
        this.interest = this.init(ops);
    }

    private int init(int ops) {
        int interest = 0;
        if ((ops & 1) > 0) {
            interest |= 1;
        }
        if ((ops & 2) > 0) {
            interest = this.socket != null ? (interest |= 1) : (interest |= 4);
        }
        this.ready = 0;
        return interest;
    }

    public final boolean isReadable() {
        return (this.ready & 1) > 0;
    }

    public final boolean isWritable() {
        return (this.ready & 2) > 0;
    }

    public final boolean isError() {
        return (this.ready & 4) > 0;
    }

    public final SocketBase getSocket() {
        return this.socket;
    }

    public final SelectableChannel getRawSocket() {
        return this.channel;
    }

    public final SelectableChannel getChannel() {
        if (this.socket != null) {
            return this.socket.getFD();
        }
        return this.channel;
    }

    public final int interestOps() {
        return this.interest;
    }

    @Deprecated
    public final int zinterestOps() {
        return this.zinterest;
    }

    public final boolean hasEvent(int events) {
        return (this.zinterest & events) > 0;
    }

    public final int interestOps(int ops) {
        this.init(ops);
        return this.interest;
    }

    public final int readyOps(SelectionKey key, int nevents) {
        this.ready = 0;
        if (this.socket != null) {
            int events = this.socket.getSocketOpt(15);
            if (events < 0) {
                return -1;
            }
            if ((this.zinterest & 2) > 0 && (events & 2) > 0) {
                this.ready |= 2;
            }
            if ((this.zinterest & 1) > 0 && (events & 1) > 0) {
                this.ready |= 1;
            }
        } else if (nevents > 0) {
            if (key.isReadable()) {
                this.ready |= 1;
            }
            if (key.isWritable()) {
                this.ready |= 2;
            }
            if (!key.isValid() || key.isAcceptable() || key.isConnectable()) {
                this.ready |= 4;
            }
        }
        return this.ready;
    }

    public final int readyOps() {
        return this.ready;
    }
}

