/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import zmq.Ctx;
import zmq.Msg;
import zmq.SocketBase;
import zmq.ZMQ;
import zmq.io.Metadata;
import zmq.pipe.Pipe;
import zmq.socket.FQ;
import zmq.util.Blob;
import zmq.util.Utils;
import zmq.util.ValueReference;
import zmq.util.Wire;

public class Stream
extends SocketBase {
    private final FQ fq;
    private boolean prefetched = false;
    private boolean identitySent = false;
    private Msg prefetchedId;
    private Msg prefetchedMsg;
    private Map<Blob, Outpipe> outpipes = new HashMap<Blob, Outpipe>();
    private Pipe currentOut = null;
    private boolean moreOut = false;
    private int nextRid = Utils.randomInt();

    public Stream(Ctx parent2, int tid, int sid) {
        super(parent2, tid, sid);
        this.options.type = 11;
        this.options.rawSocket = true;
        this.fq = new FQ();
        this.prefetchedId = new Msg();
        this.prefetchedMsg = new Msg();
    }

    @Override
    protected void xattachPipe(Pipe pipe, boolean icanhasall) {
        assert (pipe != null);
        this.identifyPeer(pipe);
        this.fq.attach(pipe);
    }

    @Override
    protected void xpipeTerminated(Pipe pipe) {
        Outpipe outpipe = this.outpipes.remove(pipe.getIdentity());
        assert (outpipe != null);
        this.fq.terminated(pipe);
        if (pipe == this.currentOut) {
            this.currentOut = null;
        }
    }

    @Override
    protected void xreadActivated(Pipe pipe) {
        this.fq.activated(pipe);
    }

    @Override
    protected void xwriteActivated(Pipe pipe) {
        Outpipe out2 = null;
        for (Outpipe outpipe : this.outpipes.values()) {
            if (outpipe.pipe != pipe) continue;
            out2 = outpipe;
            break;
        }
        assert (out2 != null);
        assert (!out2.active);
        out2.active = true;
    }

    @Override
    protected boolean xsend(Msg msg) {
        if (!this.moreOut) {
            assert (this.currentOut == null);
            if (msg.hasMore()) {
                this.moreOut = true;
                Blob identity2 = Blob.createBlob(msg);
                Outpipe op = this.outpipes.get(identity2);
                if (op != null) {
                    this.currentOut = op.pipe;
                    if (!this.currentOut.checkWrite()) {
                        op.active = false;
                        this.currentOut = null;
                        this.errno.set(35);
                        return false;
                    }
                } else {
                    this.errno.set(65);
                    return false;
                }
            }
            this.moreOut = true;
            return true;
        }
        msg.resetFlags(1);
        this.moreOut = false;
        if (this.currentOut != null) {
            if (msg.size() == 0) {
                this.currentOut.terminate(false);
                this.currentOut = null;
                return true;
            }
            boolean ok = this.currentOut.write(msg);
            if (ok) {
                this.currentOut.flush();
            }
            this.currentOut = null;
        }
        return true;
    }

    @Override
    protected boolean xsetsockopt(int option2, Object optval) {
        switch (option2) {
            case 61: {
                this.connectRid = (String)optval;
                return true;
            }
        }
        this.errno.set(22);
        return false;
    }

    @Override
    public Msg xrecv() {
        if (this.prefetched) {
            Msg msg;
            if (!this.identitySent) {
                msg = this.prefetchedId;
                this.prefetchedId = null;
                this.identitySent = true;
            } else {
                msg = this.prefetchedMsg;
                this.prefetchedMsg = null;
                this.prefetched = false;
            }
            return msg;
        }
        ValueReference<Pipe> pipe = new ValueReference<Pipe>();
        this.prefetchedMsg = this.fq.recvPipe(this.errno, pipe);
        if (this.prefetchedMsg == null) {
            this.errno.set(35);
            return null;
        }
        assert (pipe.get() != null);
        assert (!this.prefetchedMsg.hasMore());
        Blob identity2 = pipe.get().getIdentity();
        Msg msg = new Msg(identity2.data());
        Metadata metadata = this.prefetchedMsg.getMetadata();
        if (metadata != null) {
            msg.setMetadata(metadata);
        }
        msg.setFlags(1);
        this.prefetched = true;
        this.identitySent = true;
        return msg;
    }

    @Override
    protected boolean xhasIn() {
        if (this.prefetched) {
            return true;
        }
        ValueReference<Pipe> pipe = new ValueReference<Pipe>();
        this.prefetchedMsg = this.fq.recvPipe(this.errno, pipe);
        if (this.prefetchedMsg == null) {
            return false;
        }
        assert (pipe.get() != null);
        assert (!this.prefetchedMsg.hasMore());
        Blob identity2 = pipe.get().getIdentity();
        this.prefetchedId = new Msg(identity2.data());
        Metadata metadata = this.prefetchedMsg.getMetadata();
        if (metadata != null) {
            this.prefetchedId.setMetadata(metadata);
        }
        this.prefetchedId.setFlags(1);
        this.prefetched = true;
        this.identitySent = false;
        return true;
    }

    @Override
    protected boolean xhasOut() {
        return true;
    }

    private void identifyPeer(Pipe pipe) {
        Outpipe outpipe;
        Blob identity2;
        if (this.connectRid != null && !this.connectRid.isEmpty()) {
            identity2 = Blob.createBlob(this.connectRid.getBytes(ZMQ.CHARSET));
            this.connectRid = null;
            outpipe = this.outpipes.get(identity2);
            assert (outpipe == null);
        } else {
            ByteBuffer buf = ByteBuffer.allocate(5);
            buf.put((byte)0);
            Wire.putUInt32(buf, this.nextRid++);
            identity2 = Blob.createBlob(buf.array());
        }
        pipe.setIdentity(identity2);
        outpipe = new Outpipe(pipe, true);
        this.outpipes.put(identity2, outpipe);
    }

    private class Outpipe {
        private Pipe pipe;
        private boolean active;

        public Outpipe(Pipe pipe, boolean active) {
            this.pipe = pipe;
            this.active = active;
        }
    }
}

