/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternNode;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.RamUsageEstimator;

@NotThreadSafe
public class PatternTreeMap<V, VSerializer extends PathPatternNode.Serializer<V>>
implements Accountable {
    private final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(PatternTreeMap.class);
    private final PathPatternNode<V, VSerializer> root;
    private final Supplier<? extends Set<V>> supplier;
    private final BiConsumer<V, Set<V>> appendFunction;
    private final BiConsumer<V, Set<V>> deleteFunction;
    private final VSerializer serializer;

    public PatternTreeMap(Supplier<? extends Set<V>> supplier, BiConsumer<V, Set<V>> appendFunction, BiConsumer<V, Set<V>> deleteFunction, VSerializer serializer) {
        this.root = new PathPatternNode("root", supplier, serializer);
        this.supplier = supplier;
        this.appendFunction = appendFunction;
        this.deleteFunction = deleteFunction;
        this.serializer = serializer;
    }

    public void append(PartialPath key, V value) {
        if (this.appendFunction == null) {
            throw new UnsupportedOperationException();
        }
        String[] pathNodes = key.getNodes();
        PathPatternNode<V, VSerializer> curNode = this.root;
        for (int i = 1; i < pathNodes.length; ++i) {
            PathPatternNode<V, VSerializer> nextNode = curNode.getChildren(pathNodes[i]);
            if (nextNode == null) {
                nextNode = new PathPatternNode(pathNodes[i], this.supplier, this.serializer);
                curNode.addChild(nextNode);
            }
            curNode = nextNode;
        }
        curNode.appendValue(value, this.appendFunction);
    }

    public void delete(PartialPath key, V value) {
        if (this.deleteFunction == null) {
            throw new UnsupportedOperationException();
        }
        this.deletePathNode(this.root, key.getNodes(), 0, value);
    }

    private boolean deletePathNode(PathPatternNode<V, VSerializer> node, String[] pathNodes, int pos, V value) {
        if (node == null) {
            return false;
        }
        if (pos == pathNodes.length - 1) {
            node.deleteValue(value, this.deleteFunction);
        } else {
            PathPatternNode<V, VSerializer> child = node.getChildren(pathNodes[pos + 1]);
            if (this.deletePathNode(child, pathNodes, pos + 1, value)) {
                node.deleteChild(child);
            }
        }
        return node.isLeaf() && node.getValues().isEmpty();
    }

    public List<V> getOverlapped(PartialPath fullPath) {
        HashSet res = new HashSet();
        this.searchOverlapped(this.root, fullPath.getNodes(), 0, res);
        return new ArrayList(res);
    }

    private void searchOverlapped(PathPatternNode<V, VSerializer> node, String[] pathNodes, int pos, Set<V> resultSet) {
        if (pos == pathNodes.length - 1) {
            resultSet.addAll(node.getValues());
            return;
        }
        if (node.isMultiLevelWildcard()) {
            this.searchOverlapped(node, pathNodes, pos + 1, resultSet);
        }
        for (PathPatternNode<V, VSerializer> child : node.getMatchChildren(pathNodes[pos + 1])) {
            this.searchOverlapped(child, pathNodes, pos + 1, resultSet);
        }
    }

    public List<List<V>> getOverlapped(PartialPath devicePath, List<String> measurements) {
        ArrayList<Set<V>> resultSet = new ArrayList<Set<V>>();
        for (int i = 0; i < measurements.size(); ++i) {
            resultSet.add(new HashSet());
        }
        this.searchOverlapped(this.root, devicePath.getNodes(), 0, measurements, resultSet);
        ArrayList<List<V>> res = new ArrayList<List<V>>();
        for (Set set : resultSet) {
            res.add(new ArrayList(set));
        }
        return res;
    }

    private void searchOverlapped(PathPatternNode<V, VSerializer> node, String[] deviceNodes, int pos, List<String> measurements, List<Set<V>> resultSet) {
        if (pos == deviceNodes.length - 1) {
            for (int i = 0; i < measurements.size(); ++i) {
                for (PathPatternNode<V, VSerializer> child : node.getMatchChildren(measurements.get(i))) {
                    resultSet.get(i).addAll(child.getValues());
                }
                if (!node.isMultiLevelWildcard()) continue;
                resultSet.get(i).addAll(node.getValues());
            }
            return;
        }
        if (node.isMultiLevelWildcard()) {
            this.searchOverlapped(node, deviceNodes, pos + 1, measurements, resultSet);
        }
        for (PathPatternNode<V, VSerializer> child : node.getMatchChildren(deviceNodes[pos + 1])) {
            this.searchOverlapped(child, deviceNodes, pos + 1, measurements, resultSet);
        }
    }

    public List<V> getDeviceOverlapped(PartialPath devicePath) {
        HashSet resultSet = new HashSet();
        this.searchDeviceOverlapped(this.root, devicePath.getNodes(), 0, resultSet);
        return new ArrayList(resultSet);
    }

    private void searchDeviceOverlapped(PathPatternNode<V, VSerializer> node, String[] deviceNodes, int pos, Set<V> resultSet) {
        if (pos == deviceNodes.length - 1) {
            resultSet.addAll(node.getValues());
            for (PathPatternNode<V, VSerializer> child : node.getChildren().values()) {
                resultSet.addAll(child.getValues());
            }
            return;
        }
        if (node.isMultiLevelWildcard()) {
            this.searchDeviceOverlapped(node, deviceNodes, pos + 1, resultSet);
        }
        for (PathPatternNode<V, VSerializer> child : node.getMatchChildren(deviceNodes[pos + 1])) {
            this.searchDeviceOverlapped(child, deviceNodes, pos + 1, resultSet);
        }
    }

    public long ramBytesUsed() {
        return this.SHALLOW_SIZE + RamUsageEstimator.sizeOfObject(this.root);
    }
}

