/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.customizer.parameter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.udf.api.type.Type;

public class UDFParameters {
    private final List<String> childExpressions;
    private final List<Type> childExpressionDataTypes;
    private final Map<String, String> userAttributes;
    private final Map<String, String> systemAttributes;

    public UDFParameters(List<String> childExpressions, List<Type> childExpressionDataTypes, Map<String, String> userAttributes) {
        this(childExpressions, childExpressionDataTypes, userAttributes, new HashMap<String, String>());
    }

    public UDFParameters(List<String> childExpressions, List<Type> childExpressionDataTypes, Map<String, String> userAttributes, Map<String, String> systemAttributes) {
        this.childExpressions = childExpressions;
        this.childExpressionDataTypes = childExpressionDataTypes;
        this.userAttributes = userAttributes;
        this.systemAttributes = systemAttributes;
    }

    public List<String> getChildExpressions() {
        return this.childExpressions;
    }

    public Map<String, String> getAttributes() {
        return this.userAttributes;
    }

    public List<Type> getDataTypes() {
        return this.childExpressionDataTypes;
    }

    public int getChildExpressionsSize() {
        return this.childExpressions.size();
    }

    public Type getDataType(int index) {
        return this.childExpressionDataTypes.get(index);
    }

    public boolean hasAttribute(String attributeKey) {
        return this.userAttributes.containsKey(attributeKey);
    }

    public String getString(String key) {
        return this.userAttributes.get(key);
    }

    public Boolean getBoolean(String key) {
        String value = this.userAttributes.get(key);
        return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    public Integer getInt(String key) {
        String value = this.userAttributes.get(key);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public Long getLong(String key) {
        String value = this.userAttributes.get(key);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public Float getFloat(String key) {
        String value = this.userAttributes.get(key);
        return value == null ? null : Float.valueOf(Float.parseFloat(value));
    }

    public Double getDouble(String key) {
        String value = this.userAttributes.get(key);
        return value == null ? null : Double.valueOf(Double.parseDouble(value));
    }

    public String getStringOrDefault(String key, String defaultValue) {
        String value = this.userAttributes.get(key);
        return value == null ? defaultValue : value;
    }

    public boolean getBooleanOrDefault(String key, boolean defaultValue) {
        String value = this.userAttributes.get(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public int getIntOrDefault(String key, int defaultValue) {
        String value = this.userAttributes.get(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public long getLongOrDefault(String key, long defaultValue) {
        String value = this.userAttributes.get(key);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public float getFloatOrDefault(String key, float defaultValue) {
        String value = this.userAttributes.get(key);
        return value == null ? defaultValue : Float.parseFloat(value);
    }

    public double getDoubleOrDefault(String key, double defaultValue) {
        String value = this.userAttributes.get(key);
        return value == null ? defaultValue : Double.parseDouble(value);
    }

    public boolean hasSystemAttribute(String attributeKey) {
        return this.systemAttributes.containsKey(attributeKey);
    }

    public Map<String, String> getSystemAttributes() {
        return this.systemAttributes;
    }

    public String getSystemString(String key) {
        return this.systemAttributes.get(key);
    }

    public Boolean getSystemBoolean(String key) {
        String value = this.systemAttributes.get(key);
        return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    public Integer getSystemInt(String key) {
        String value = this.systemAttributes.get(key);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public Long getSystemLong(String key) {
        String value = this.systemAttributes.get(key);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public Float getSystemFloat(String key) {
        String value = this.systemAttributes.get(key);
        return value == null ? null : Float.valueOf(Float.parseFloat(value));
    }

    public Double getSystemDouble(String key) {
        String value = this.systemAttributes.get(key);
        return value == null ? null : Double.valueOf(Double.parseDouble(value));
    }

    public String getSystemStringOrDefault(String key, String defaultValue) {
        String value = this.systemAttributes.get(key);
        return value == null ? defaultValue : value;
    }

    public boolean getSystemBooleanOrDefault(String key, boolean defaultValue) {
        String value = this.systemAttributes.get(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public int getSystemIntOrDefault(String key, int defaultValue) {
        String value = this.systemAttributes.get(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public long getSystemLongOrDefault(String key, long defaultValue) {
        String value = this.systemAttributes.get(key);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public float getSystemFloatOrDefault(String key, float defaultValue) {
        String value = this.systemAttributes.get(key);
        return value == null ? defaultValue : Float.parseFloat(value);
    }

    public double getSystemDoubleOrDefault(String key, double defaultValue) {
        String value = this.systemAttributes.get(key);
        return value == null ? defaultValue : Double.parseDouble(value);
    }
}

