/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.payload.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.pipe.connector.payload.pipeconsensus.request.PipeConsensusRequestType;
import org.apache.iotdb.commons.pipe.connector.payload.pipeconsensus.request.PipeConsensusRequestVersion;
import org.apache.iotdb.consensus.pipe.thrift.TCommitId;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.tsfile.utils.PublicBAOS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensusTabletBinaryReq
extends TPipeConsensusTransferReq {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusTabletBinaryReq.class);
    private transient ByteBuffer byteBuffer;

    private PipeConsensusTabletBinaryReq() {
    }

    public InsertNode convertToInsertNode() {
        PlanNode node = WALEntry.deserializeForConsensus(this.byteBuffer);
        return node instanceof InsertNode ? (InsertNode)node : null;
    }

    public static PipeConsensusTabletBinaryReq toTPipeConsensusTransferReq(ByteBuffer byteBuffer, TCommitId commitId, TConsensusGroupId consensusGroupId, ProgressIndex progressIndex, int thisDataNodeId) {
        PipeConsensusTabletBinaryReq req = new PipeConsensusTabletBinaryReq();
        req.byteBuffer = byteBuffer;
        req.commitId = commitId;
        req.consensusGroupId = consensusGroupId;
        req.dataNodeId = thisDataNodeId;
        req.version = PipeConsensusRequestVersion.VERSION_1.getVersion();
        req.type = PipeConsensusRequestType.TRANSFER_TABLET_BINARY.getType();
        req.body = byteBuffer;
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            progressIndex.serialize((OutputStream)outputStream);
            req.progressIndex = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to serialize progress index {}", (Object)progressIndex, (Object)e);
        }
        return req;
    }

    public static PipeConsensusTabletBinaryReq fromTPipeConsensusTransferReq(TPipeConsensusTransferReq transferReq) {
        PipeConsensusTabletBinaryReq binaryReq = new PipeConsensusTabletBinaryReq();
        binaryReq.byteBuffer = transferReq.body;
        binaryReq.version = transferReq.version;
        binaryReq.type = transferReq.type;
        binaryReq.body = transferReq.body;
        binaryReq.commitId = transferReq.commitId;
        binaryReq.dataNodeId = transferReq.dataNodeId;
        binaryReq.consensusGroupId = transferReq.consensusGroupId;
        binaryReq.progressIndex = transferReq.progressIndex;
        return binaryReq;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeConsensusTabletBinaryReq that = (PipeConsensusTabletBinaryReq)((Object)obj);
        return this.byteBuffer.equals(that.byteBuffer) && this.version == that.version && this.type == that.type && this.body.equals(that.body) && Objects.equals(this.commitId, that.commitId) && Objects.equals(this.consensusGroupId, that.consensusGroupId) && Objects.equals(this.progressIndex, that.progressIndex) && Objects.equals(this.dataNodeId, that.dataNodeId);
    }

    public int hashCode() {
        return Objects.hash(this.byteBuffer, this.version, this.type, this.body, this.commitId, this.consensusGroupId, this.dataNodeId, this.progressIndex);
    }
}

