/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Objects;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.slf4j.Logger;

public class SchemaRegionUtils {
    private SchemaRegionUtils() {
    }

    public static void deleteSchemaRegionFolder(String schemaRegionDirPath, Logger logger) throws MetadataException {
        File schemaRegionDir = SystemFileFactory.INSTANCE.getFile(schemaRegionDirPath);
        File[] sgFiles = schemaRegionDir.listFiles();
        if (sgFiles == null) {
            throw new MetadataException(String.format("Can't get files in schema region dir %s", schemaRegionDirPath));
        }
        for (File file : sgFiles) {
            try {
                Files.delete(file.toPath());
                logger.info("Delete schema region file {}", (Object)file.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn("Delete schema region file {} failed.", (Object)file.getAbsolutePath());
                throw new MetadataException(String.format("Failed to delete schema region file %s", file.getAbsolutePath()));
            }
        }
        try {
            Files.delete(schemaRegionDir.toPath());
            logger.info("Delete schema region folder {}", (Object)schemaRegionDir.getAbsolutePath());
        }
        catch (IOException e) {
            logger.warn("Delete schema region folder {} failed.", (Object)schemaRegionDir.getAbsolutePath());
            throw new MetadataException(String.format("Failed to delete schema region folder %s", schemaRegionDir.getAbsolutePath()));
        }
        File storageGroupDir = schemaRegionDir.getParentFile();
        if (Objects.requireNonNull(storageGroupDir.listFiles()).length == 0) {
            try {
                Files.delete(storageGroupDir.toPath());
                logger.info("Delete database schema folder {}", (Object)storageGroupDir.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn("Delete database schema folder {} failed", (Object)storageGroupDir.getAbsolutePath());
            }
        }
    }
}

