/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;

public class StatusUtils {
    public static final TSStatus OK = StatusUtils.getStatus(TSStatusCode.SUCCESS_STATUS);
    public static final TSStatus INTERNAL_ERROR = StatusUtils.getStatus(TSStatusCode.INTERNAL_SERVER_ERROR);
    public static final TSStatus EXECUTE_STATEMENT_ERROR = StatusUtils.getStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR);
    private static final Set<Integer> NEED_RETRY = new HashSet<Integer>();
    private static final Set<Integer> UNKNOWN_ERRORS = new HashSet<Integer>();
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();

    private StatusUtils() {
    }

    public static TSStatus[] getFailingStatus(Map<Integer, TSStatus> statusMap, int size) {
        if (statusMap == null || statusMap.isEmpty()) {
            return new TSStatus[0];
        }
        Object[] failingStatus = new TSStatus[size];
        Arrays.fill(failingStatus, RpcUtils.SUCCESS_STATUS);
        for (Map.Entry<Integer, TSStatus> status : statusMap.entrySet()) {
            failingStatus[status.getKey().intValue()] = status.getValue();
        }
        return failingStatus;
    }

    public static TSStatus getStatus(TSStatusCode statusCode) {
        TSStatus status = new TSStatus();
        status.setCode(statusCode.getStatusCode());
        switch (statusCode) {
            case SUCCESS_STATUS: {
                status.setMessage("Executed successfully.");
                break;
            }
            case INTERNAL_REQUEST_TIME_OUT: {
                status.setMessage("Request timed out.");
                break;
            }
            case INCOMPATIBLE_VERSION: {
                status.setMessage("Incompatible version.");
                break;
            }
            case REMOVE_DATANODE_ERROR: {
                status.setMessage("Failed while removing DataNode.");
                break;
            }
            case ALIAS_ALREADY_EXIST: {
                status.setMessage("Alias already exists.");
                break;
            }
            case PATH_ALREADY_EXIST: {
                status.setMessage("Path already exist.");
                break;
            }
            case PATH_NOT_EXIST: {
                status.setMessage("Path does not exist.");
                break;
            }
            case METADATA_ERROR: {
                status.setMessage("Meet error when dealing with metadata.");
                break;
            }
            case OUT_OF_TTL: {
                status.setMessage("Insertion time is less than TTL time bound.");
                break;
            }
            case COMPACTION_ERROR: {
                status.setMessage("Meet error while merging.");
                break;
            }
            case DISPATCH_ERROR: {
                status.setMessage("Meet error while dispatching.");
                break;
            }
            case DATAREGION_PROCESS_ERROR: {
                status.setMessage("Database processor related error.");
                break;
            }
            case STORAGE_ENGINE_ERROR: {
                status.setMessage("Storage engine related error.");
                break;
            }
            case TSFILE_PROCESSOR_ERROR: {
                status.setMessage("TsFile processor related error.");
                break;
            }
            case ILLEGAL_PATH: {
                status.setMessage("Illegal path.");
                break;
            }
            case LOAD_FILE_ERROR: {
                status.setMessage("Meet error while loading file.");
                break;
            }
            case EXECUTE_STATEMENT_ERROR: {
                status.setMessage("Execute statement error.");
                break;
            }
            case SQL_PARSE_ERROR: {
                status.setMessage("Meet error while parsing SQL.");
                break;
            }
            case GENERATE_TIME_ZONE_ERROR: {
                status.setMessage("Meet error while generating time zone.");
                break;
            }
            case SET_TIME_ZONE_ERROR: {
                status.setMessage("Meet error while setting time zone.");
                break;
            }
            case QUERY_NOT_ALLOWED: {
                status.setMessage("Query statements are not allowed error.");
                break;
            }
            case LOGICAL_OPERATOR_ERROR: {
                status.setMessage("Logical operator related error.");
                break;
            }
            case LOGICAL_OPTIMIZE_ERROR: {
                status.setMessage("Logical optimize related error.");
                break;
            }
            case UNSUPPORTED_FILL_TYPE: {
                status.setMessage("Unsupported fill type related error.");
                break;
            }
            case QUERY_PROCESS_ERROR: {
                status.setMessage("Query process related error.");
                break;
            }
            case WRITE_PROCESS_ERROR: {
                status.setMessage("Writing data related error.");
                break;
            }
            case INTERNAL_SERVER_ERROR: {
                status.setMessage("Internal server error.");
                break;
            }
            case CLOSE_OPERATION_ERROR: {
                status.setMessage("Meet error in close operation.");
                break;
            }
            case SYSTEM_READ_ONLY: {
                status.setMessage("Fail to do non-query operations because system is read-only.");
                break;
            }
            case DISK_SPACE_INSUFFICIENT: {
                status.setMessage("Disk space is insufficient.");
                break;
            }
            case START_UP_ERROR: {
                status.setMessage("Meet error while starting up.");
                break;
            }
            case WRONG_LOGIN_PASSWORD: {
                status.setMessage("Username or password is wrong.");
                break;
            }
            case NOT_LOGIN: {
                status.setMessage("Has not logged in.");
                break;
            }
            case NO_PERMISSION: {
                status.setMessage("No permissions for this operation, please add privilege.");
                break;
            }
            case INIT_AUTH_ERROR: {
                status.setMessage("Failed to init authorizer.");
                break;
            }
            case UNSUPPORTED_OPERATION: {
                status.setMessage("Unsupported operation.");
                break;
            }
            case CAN_NOT_CONNECT_DATANODE: {
                status.setMessage("Node cannot be reached.");
                break;
            }
            default: {
                status.setMessage("");
            }
        }
        return status;
    }

    public static boolean needRetry(TSStatus status) {
        if (status == null || status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return false;
        }
        if (!COMMON_CONFIG.isRunning()) {
            return true;
        }
        return StatusUtils.needRetryHelper(status);
    }

    public static boolean needRetryHelper(TSStatus status) {
        int code = status.getCode();
        if (code == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            for (TSStatus subStatus : status.subStatus) {
                if (subStatus != null && (subStatus.getCode() == StatusUtils.OK.code || StatusUtils.needRetryHelperForSingleStatus(subStatus.getCode()))) continue;
                return false;
            }
            return true;
        }
        return StatusUtils.needRetryHelperForSingleStatus(code);
    }

    private static boolean needRetryHelperForSingleStatus(int statusCode) {
        return NEED_RETRY.contains(statusCode) || COMMON_CONFIG.isRetryForUnknownErrors() && UNKNOWN_ERRORS.contains(statusCode);
    }

    static {
        UNKNOWN_ERRORS.add(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
        UNKNOWN_ERRORS.add(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        NEED_RETRY.add(TSStatusCode.DISPATCH_ERROR.getStatusCode());
        NEED_RETRY.add(TSStatusCode.SYSTEM_READ_ONLY.getStatusCode());
        NEED_RETRY.add(TSStatusCode.STORAGE_ENGINE_NOT_READY.getStatusCode());
        NEED_RETRY.add(TSStatusCode.WRITE_PROCESS_ERROR.getStatusCode());
        NEED_RETRY.add(TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode());
        NEED_RETRY.add(TSStatusCode.WAL_ERROR.getStatusCode());
        NEED_RETRY.add(TSStatusCode.DISK_SPACE_INSUFFICIENT.getStatusCode());
        NEED_RETRY.add(TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode());
        NEED_RETRY.add(TSStatusCode.INTERNAL_REQUEST_TIME_OUT.getStatusCode());
        NEED_RETRY.add(TSStatusCode.INTERNAL_REQUEST_RETRY_ERROR.getStatusCode());
        NEED_RETRY.add(TSStatusCode.CREATE_REGION_ERROR.getStatusCode());
        NEED_RETRY.add(TSStatusCode.CONSENSUS_NOT_INITIALIZED.getStatusCode());
        NEED_RETRY.add(TSStatusCode.NO_AVAILABLE_REGION_GROUP.getStatusCode());
        NEED_RETRY.add(TSStatusCode.LACK_PARTITION_ALLOCATION.getStatusCode());
        NEED_RETRY.add(TSStatusCode.NO_ENOUGH_DATANODE.getStatusCode());
        NEED_RETRY.add(TSStatusCode.TOO_MANY_CONCURRENT_QUERIES_ERROR.getStatusCode());
    }
}

