/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.nio.charset.Charset;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.jdbc.Config;
import org.apache.iotdb.jdbc.Constant;
import org.apache.iotdb.jdbc.IoTDBConnectionParams;
import org.apache.iotdb.jdbc.IoTDBURLException;

public class Utils {
    static final Pattern SUFFIX_URL_PATTERN = Pattern.compile("(/|\\\\?.*=.*(&.*=.*)*)?");
    static final String COLON = ":";
    static final char SLASH = '/';
    static final String PARAMETER_SEPARATOR = "?";
    static final String RPC_COMPRESS = "rpc_compress";

    static IoTDBConnectionParams parseUrl(String url, Properties info) throws IoTDBURLException {
        IoTDBConnectionParams params = new IoTDBConnectionParams(url);
        if (url.trim().equalsIgnoreCase("jdbc:iotdb://")) {
            return params;
        }
        boolean isUrlLegal = false;
        Matcher matcher = null;
        String host = null;
        String suffixURL = null;
        if (url.startsWith("jdbc:iotdb://")) {
            String subURL = url.substring("jdbc:iotdb://".length());
            int i = subURL.lastIndexOf(COLON);
            host = subURL.substring(0, i);
            params.setHost(host);
            ++i;
            int port = 0;
            while (i < subURL.length() && Character.isDigit(subURL.charAt(i))) {
                port = port * 10 + (subURL.charAt(i) - 48);
                ++i;
            }
            String string = suffixURL = i < subURL.length() ? subURL.substring(i) : "";
            if (port >= 1 && port <= 65535) {
                params.setPort(port);
                if (i < subURL.length() && subURL.charAt(i) == '/') {
                    String database;
                    int endIndex = subURL.indexOf(PARAMETER_SEPARATOR, i + 1);
                    if (endIndex <= i + 1) {
                        database = i + 1 == subURL.length() ? null : subURL.substring(i + 1);
                        suffixURL = "";
                    } else {
                        database = subURL.substring(i + 1, endIndex);
                        suffixURL = subURL.substring(endIndex);
                    }
                    params.setDb(database);
                }
                if ((matcher = SUFFIX_URL_PATTERN.matcher(suffixURL)).matches() && Utils.parseUrlParam(subURL, info)) {
                    isUrlLegal = true;
                }
            }
        }
        if (!isUrlLegal) {
            throw new IoTDBURLException("Error url format, url should be jdbc:iotdb://anything:port/[database] or jdbc:iotdb://anything:port[/database]?property1=value1&property2=value2, current url is " + url);
        }
        if (info.containsKey("user")) {
            params.setUsername(info.getProperty("user"));
        }
        if (info.containsKey("password")) {
            params.setPassword(info.getProperty("password"));
        }
        if (info.containsKey("thrift_default_buffer_capacity")) {
            params.setThriftDefaultBufferSize(Integer.parseInt(info.getProperty("thrift_default_buffer_capacity")));
        }
        if (info.containsKey("thrift_max_frame_size")) {
            params.setThriftMaxFrameSize(Integer.parseInt(info.getProperty("thrift_max_frame_size")));
        }
        if (info.containsKey("version")) {
            params.setVersion(Constant.Version.valueOf(info.getProperty("version")));
        }
        if (info.containsKey("network_timeout")) {
            params.setNetworkTimeout(Integer.parseInt(info.getProperty("network_timeout")));
        }
        if (info.containsKey("time_zone")) {
            params.setTimeZone(info.getProperty("time_zone"));
        }
        if (info.containsKey("charset")) {
            params.setCharset(info.getProperty("charset"));
        }
        if (info.containsKey("use_ssl")) {
            params.setUseSSL(Boolean.parseBoolean(info.getProperty("use_ssl")));
        }
        if (info.containsKey("trust_store")) {
            params.setTrustStore(info.getProperty("trust_store"));
        }
        if (info.containsKey("trust_store_pwd")) {
            params.setTrustStorePwd(info.getProperty("trust_store_pwd"));
        }
        if (info.containsKey("sql_dialect")) {
            params.setSqlDialect(info.getProperty("sql_dialect"));
        }
        return params;
    }

    private static boolean parseUrlParam(String subURL, Properties info) {
        String[] params;
        if (!subURL.contains(PARAMETER_SEPARATOR)) {
            return true;
        }
        String paramURL = subURL.substring(subURL.indexOf(63) + 1);
        block21: for (String tmpParam : params = paramURL.split("&")) {
            String[] paramSplit = tmpParam.split("=");
            if (paramSplit.length != 2) {
                return false;
            }
            String key = tmpParam.split("=")[0];
            String value = tmpParam.split("=")[1];
            switch (key) {
                case "rpc_compress": {
                    if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                        Config.rpcThriftCompressionEnable = Boolean.parseBoolean(value);
                        continue block21;
                    }
                    return false;
                }
                case "use_ssl": 
                case "trust_store": 
                case "trust_store_pwd": 
                case "version": 
                case "network_timeout": 
                case "sql_dialect": {
                    info.put(key, value);
                    continue block21;
                }
                case "time_zone": {
                    try {
                        ZoneId.of(value);
                    }
                    catch (DateTimeException e) {
                        return false;
                    }
                    info.put(key, value);
                    continue block21;
                }
                case "charset": {
                    try {
                        Charset.forName(value);
                    }
                    catch (Exception e) {
                        return false;
                    }
                    info.put(key, value);
                    continue block21;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private Utils() {
    }
}

