/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field.datetime.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.james.mime4j.dom.datetime.DateTime;
import org.apache.james.mime4j.field.datetime.parser.DateTimeParserConstants;
import org.apache.james.mime4j.field.datetime.parser.DateTimeParserTokenManager;
import org.apache.james.mime4j.field.datetime.parser.ParseException;
import org.apache.james.mime4j.field.datetime.parser.SimpleCharStream;
import org.apache.james.mime4j.field.datetime.parser.Token;
import org.apache.james.mime4j.field.datetime.parser.TokenMgrError;

public class DateTimeParser
implements DateTimeParserConstants {
    private static final boolean ignoreMilitaryZoneOffset = true;
    public DateTimeParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[7];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static void main(String[] args) throws ParseException {
        try {
            while (true) {
                DateTimeParser parser = new DateTimeParser(System.in);
                parser.parseLine();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            return;
        }
    }

    public DateTime parseAll() throws ParseException {
        try {
            return this.doParseAll();
        }
        catch (TokenMgrError e) {
            throw new ParseException(e);
        }
    }

    public DateTime parseLine() throws ParseException {
        try {
            return this.doParseLine();
        }
        catch (TokenMgrError e) {
            throw new ParseException(e);
        }
    }

    private static int parseDigits(Token token) {
        return Integer.parseInt(token.image, 10);
    }

    private static int getMilitaryZoneOffset(char c) {
        return 0;
    }

    private final DateTime doParseLine() throws ParseException {
        DateTime dt = this.date_time();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        this.jj_consume_token(2);
        return dt;
    }

    private final DateTime doParseAll() throws ParseException {
        DateTime dt = this.date_time();
        this.jj_consume_token(0);
        return dt;
    }

    public final DateTime date_time() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                this.day_of_week();
                this.jj_consume_token(3);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        Date d = this.date();
        Time t2 = this.time();
        return new DateTime(d.getYear(), d.getMonth(), d.getDay(), t2.getHour(), t2.getMinute(), t2.getSecond(), t2.getZone());
    }

    public final String day_of_week() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final Date date() throws ParseException {
        int d = this.day();
        int m4 = this.month();
        String y = this.year();
        return new Date(y, m4, d);
    }

    public final int day() throws ParseException {
        Token t2 = this.jj_consume_token(27);
        return DateTimeParser.parseDigits(t2);
    }

    public final int month() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                return 1;
            }
            case 29: {
                this.jj_consume_token(29);
                return 2;
            }
            case 30: {
                this.jj_consume_token(30);
                return 3;
            }
            case 31: {
                this.jj_consume_token(31);
                return 4;
            }
            case 32: {
                this.jj_consume_token(32);
                return 5;
            }
            case 33: {
                this.jj_consume_token(33);
                return 6;
            }
            case 34: {
                this.jj_consume_token(34);
                return 7;
            }
            case 35: {
                this.jj_consume_token(35);
                return 8;
            }
            case 36: {
                this.jj_consume_token(36);
                return 9;
            }
            case 37: {
                this.jj_consume_token(37);
                return 10;
            }
            case 38: {
                this.jj_consume_token(38);
                return 11;
            }
            case 39: {
                this.jj_consume_token(39);
                return 12;
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String year() throws ParseException {
        Token t2 = this.jj_consume_token(27);
        String year = t2.image;
        if (year.length() == 2) {
            if (year.charAt(0) > '6') {
                return "19" + year;
            }
            return "20" + year;
        }
        return year;
    }

    public final Time time() throws ParseException {
        int s2 = 0;
        int h2 = this.hour();
        this.jj_consume_token(4);
        int m4 = this.minute();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                s2 = this.second();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        int z = this.zone();
        return new Time(h2, m4, s2, z);
    }

    public final int hour() throws ParseException {
        Token t2 = this.jj_consume_token(27);
        return DateTimeParser.parseDigits(t2);
    }

    public final int minute() throws ParseException {
        Token t2 = this.jj_consume_token(27);
        return DateTimeParser.parseDigits(t2);
    }

    public final int second() throws ParseException {
        Token t2 = this.jj_consume_token(27);
        return DateTimeParser.parseDigits(t2);
    }

    public final int zone() throws ParseException {
        int z;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                Token t2 = this.jj_consume_token(5);
                Token u = this.jj_consume_token(27);
                z = DateTimeParser.parseDigits(u) * (t2.image.equals("-") ? -1 : 1);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                z = this.obs_zone();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return z;
    }

    public final int obs_zone() throws ParseException {
        int z;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                z = 0;
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                z = 0;
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                z = -5;
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                z = -4;
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                z = -6;
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                z = -5;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                z = -7;
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                z = -6;
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                z = -8;
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                z = -7;
                break;
            }
            case 16: {
                Token t2 = this.jj_consume_token(16);
                z = DateTimeParser.getMilitaryZoneOffset(t2.image.charAt(0));
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return z * 100;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{2, 0, 0, -268435456, 16, 131040, 131008};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 32512, 32512, 255, 0, 0, 0};
    }

    public DateTimeParser(InputStream stream) {
        this(stream, null);
    }

    public DateTimeParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new DateTimeParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public DateTimeParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new DateTimeParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public DateTimeParser(DateTimeParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(DateTimeParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t2 = this.token;
        for (int i = 0; i < index; ++i) {
            t2 = t2.next != null ? t2.next : (t2.next = this.token_source.getNextToken());
        }
        return t2;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[49];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 7; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 49; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        DateTimeParser.jj_la1_init_0();
        DateTimeParser.jj_la1_init_1();
    }

    private static class Date {
        private String year;
        private int month;
        private int day;

        public Date(String year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }

        public String getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDay() {
            return this.day;
        }
    }

    private static class Time {
        private int hour;
        private int minute;
        private int second;
        private int zone;

        public Time(int hour, int minute, int second, int zone) {
            this.hour = hour;
            this.minute = minute;
            this.second = second;
            this.zone = zone;
        }

        public int getHour() {
            return this.hour;
        }

        public int getMinute() {
            return this.minute;
        }

        public int getSecond() {
            return this.second;
        }

        public int getZone() {
            return this.zone;
        }
    }
}

