/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import java.util.Optional;
import modules.BlobPostgresModule;
import org.apache.james.blob.aes.AESBlobStoreDAO;
import org.apache.james.blob.aes.CryptoConfig;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.ObjectStorageHealthCheck;
import org.apache.james.blob.cassandra.CassandraBlobStoreDAO;
import org.apache.james.blob.file.FileBlobStoreDAO;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreConfiguration;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreDAO;
import org.apache.james.blob.objectstorage.aws.S3RequestOption;
import org.apache.james.blob.objectstorage.aws.sse.S3SSECConfiguration;
import org.apache.james.blob.objectstorage.aws.sse.S3SSECustomerKeyFactory;
import org.apache.james.blob.postgres.PostgresBlobStoreDAO;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.modules.blobstore.BlobDeduplicationGCModule;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.modules.blobstore.validation.BlobStoreConfigurationValidationStartUpCheck;
import org.apache.james.modules.blobstore.validation.StoragePolicyConfigurationSanityEnforcementModule;
import org.apache.james.modules.mailbox.BlobStoreAPIModule;
import org.apache.james.modules.mailbox.CassandraBlobStoreDependenciesModule;
import org.apache.james.modules.mailbox.DefaultBucketModule;
import org.apache.james.modules.objectstorage.S3BlobStoreModule;
import org.apache.james.modules.objectstorage.S3BucketModule;
import org.apache.james.server.blob.deduplication.DeDuplicationBlobStore;
import org.apache.james.server.blob.deduplication.PassThroughBlobStore;
import org.apache.james.server.blob.deduplication.StorageStrategy;
import org.apache.james.server.core.MissingArgumentException;

public class BlobStoreModulesChooser {
    private static final String UNENCRYPTED = "unencrypted";

    public static List<Module> chooseModules(BlobStoreConfiguration choosingConfiguration) {
        return ImmutableList.builder().add((Object)BlobStoreModulesChooser.chooseEncryptionModule(choosingConfiguration.getCryptoConfig())).add((Object)BlobStoreModulesChooser.chooseBlobStoreDAOModule(choosingConfiguration.getImplementation())).addAll(BlobStoreModulesChooser.chooseStoragePolicyModule(choosingConfiguration.storageStrategy())).add((Object)new StoragePolicyConfigurationSanityEnforcementModule()).add(binder -> binder.bind(BlobStoreConfiguration.class).toInstance((Object)choosingConfiguration)).add(binder -> binder.bind(BlobStoreConfigurationValidationStartUpCheck.StorageStrategySupplier.class).toInstance(choosingConfiguration::storageStrategy)).build();
    }

    public static Module chooseBlobStoreDAOModule(BlobStoreConfiguration.BlobStoreImplName implementation) {
        switch (implementation) {
            case CASSANDRA: {
                return new CassandraBlobStoreDAODeclarationModule();
            }
            case S3: {
                return new ObjectStorageBlobStoreDAODeclarationModule();
            }
            case FILE: {
                return new FileBlobStoreDAODeclarationModule();
            }
            case POSTGRES: {
                return new PostgresBlobStoreDAODeclarationModule();
            }
        }
        throw new RuntimeException("Unsupported blobStore implementation " + String.valueOf((Object)implementation));
    }

    public static Module chooseEncryptionModule(Optional<CryptoConfig> cryptoConfig) {
        Optional<Module> encryptionModule = cryptoConfig.map(EncryptionModule::new);
        return encryptionModule.orElse((Module)new NoEncryptionModule());
    }

    public static List<Module> chooseStoragePolicyModule(StorageStrategy storageStrategy) {
        switch (storageStrategy) {
            case DEDUPLICATION: {
                Module deduplicationBlobModule = binder -> binder.bind(BlobStore.class).annotatedWith((Annotation)Names.named((String)"blobStoreBackend")).to(DeDuplicationBlobStore.class);
                return ImmutableList.of((Object)new BlobDeduplicationGCModule(), (Object)deduplicationBlobModule);
            }
            case PASSTHROUGH: {
                Module passThroughBlobModule = binder -> binder.bind(BlobStore.class).annotatedWith((Annotation)Names.named((String)"blobStoreBackend")).to(PassThroughBlobStore.class);
                return ImmutableList.of((Object)new BlobStoreAPIModule(), (Object)passThroughBlobModule);
            }
        }
        throw new RuntimeException("Unknown storage strategy " + storageStrategy.name());
    }

    static class CassandraBlobStoreDAODeclarationModule
    extends AbstractModule {
        CassandraBlobStoreDAODeclarationModule() {
        }

        protected void configure() {
            this.install((Module)new CassandraBlobStoreDependenciesModule());
            this.install((Module)new DefaultBucketModule());
            this.bind(BlobStoreDAO.class).annotatedWith((Annotation)Names.named((String)BlobStoreModulesChooser.UNENCRYPTED)).to(CassandraBlobStoreDAO.class);
        }
    }

    static class ObjectStorageBlobStoreDAODeclarationModule
    extends AbstractModule {
        ObjectStorageBlobStoreDAODeclarationModule() {
        }

        protected void configure() {
            this.install((Module)new S3BlobStoreModule());
            this.install((Module)new S3BucketModule());
            this.bind(BlobStoreDAO.class).annotatedWith((Annotation)Names.named((String)BlobStoreModulesChooser.UNENCRYPTED)).to(S3BlobStoreDAO.class).in(Scopes.SINGLETON);
            Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class).addBinding().to(ObjectStorageHealthCheck.class);
        }

        @Provides
        @Singleton
        S3RequestOption provideS3RequestOption(S3BlobStoreConfiguration configuration) throws InvalidKeySpecException, NoSuchAlgorithmException {
            if (!configuration.ssecEnabled()) {
                return S3RequestOption.DEFAULT;
            }
            S3SSECConfiguration ssecConfiguration = (S3SSECConfiguration)configuration.getSSECConfiguration().orElseThrow(() -> new MissingArgumentException("SSEC is enabled but no configuration is provided"));
            S3SSECustomerKeyFactory.SingleCustomerKeyFactory sseCustomerKeyFactory = new S3SSECustomerKeyFactory.SingleCustomerKeyFactory((S3SSECConfiguration.Basic)ssecConfiguration);
            return new S3RequestOption(new S3RequestOption.SSEC(true, Optional.of(sseCustomerKeyFactory)));
        }
    }

    static class FileBlobStoreDAODeclarationModule
    extends AbstractModule {
        FileBlobStoreDAODeclarationModule() {
        }

        protected void configure() {
            this.install((Module)new DefaultBucketModule());
            this.bind(BlobStoreDAO.class).annotatedWith((Annotation)Names.named((String)BlobStoreModulesChooser.UNENCRYPTED)).to(FileBlobStoreDAO.class);
        }
    }

    static class PostgresBlobStoreDAODeclarationModule
    extends AbstractModule {
        PostgresBlobStoreDAODeclarationModule() {
        }

        protected void configure() {
            this.install((Module)new BlobPostgresModule());
            this.install((Module)new DefaultBucketModule());
            this.bind(BlobStoreDAO.class).annotatedWith((Annotation)Names.named((String)BlobStoreModulesChooser.UNENCRYPTED)).to(PostgresBlobStoreDAO.class);
        }
    }

    static class NoEncryptionModule
    extends AbstractModule {
        NoEncryptionModule() {
        }

        @Provides
        @Singleton
        BlobStoreDAO blobStoreDAO(@Named(value="unencrypted") BlobStoreDAO unencrypted) {
            return unencrypted;
        }
    }

    static class EncryptionModule
    extends AbstractModule {
        private final CryptoConfig cryptoConfig;

        EncryptionModule(CryptoConfig cryptoConfig) {
            this.cryptoConfig = cryptoConfig;
        }

        @Provides
        @Singleton
        BlobStoreDAO blobStoreDAO(@Named(value="unencrypted") BlobStoreDAO unencrypted) {
            return new AESBlobStoreDAO(unencrypted, this.cryptoConfig);
        }

        @Provides
        CryptoConfig cryptoConfig() {
            return this.cryptoConfig;
        }
    }
}

