/*
 * Decompiled with CFR 0.152.
 */
package spark;

import java.util.HashMap;
import java.util.Map;
import spark.ExceptionHandlerImpl;

public class ExceptionMapper {
    private static ExceptionMapper servletInstance;
    private Map<Class<? extends Exception>, ExceptionHandlerImpl> exceptionMap = new HashMap<Class<? extends Exception>, ExceptionHandlerImpl>();

    @Deprecated
    public static ExceptionMapper getInstance() {
        return ExceptionMapper.getServletInstance();
    }

    public static synchronized ExceptionMapper getServletInstance() {
        if (servletInstance == null) {
            servletInstance = new ExceptionMapper();
        }
        return servletInstance;
    }

    public void map(Class<? extends Exception> exceptionClass, ExceptionHandlerImpl handler) {
        this.exceptionMap.put(exceptionClass, handler);
    }

    public ExceptionHandlerImpl getHandler(Class<? extends Exception> exceptionClass) {
        if (!this.exceptionMap.containsKey(exceptionClass)) {
            Class<? extends Exception> superclass = exceptionClass.getSuperclass();
            do {
                if (!this.exceptionMap.containsKey(superclass)) continue;
                ExceptionHandlerImpl handler = this.exceptionMap.get(superclass);
                this.exceptionMap.put(exceptionClass, handler);
                return handler;
            } while ((superclass = superclass.getSuperclass()) != null);
            this.exceptionMap.put(exceptionClass, null);
            return null;
        }
        return this.exceptionMap.get(exceptionClass);
    }

    public ExceptionHandlerImpl getHandler(Exception exception) {
        return this.getHandler(exception.getClass());
    }

    public void clear() {
        this.exceptionMap.clear();
    }
}

