/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.paging;

import com.datastax.oss.driver.api.core.AsyncPagingIterable;
import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class OffsetPager {
    private final int pageSize;

    public OffsetPager(int pageSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("Invalid pageSize, expected >=1, got " + pageSize);
        }
        this.pageSize = pageSize;
    }

    @NonNull
    public <ElementT> Page<ElementT> getPage(@NonNull PagingIterable<ElementT> iterable, int targetPageNumber) {
        this.throwIfIllegalArguments(iterable, targetPageNumber);
        ArrayList currentPageElements = new ArrayList();
        int currentPageNumber = 1;
        int currentPageSize = 0;
        for (Object element : iterable) {
            if (++currentPageSize > this.pageSize) {
                ++currentPageNumber;
                currentPageSize = 1;
                currentPageElements.clear();
            }
            currentPageElements.add(element);
            if (currentPageNumber != targetPageNumber || currentPageSize != this.pageSize) continue;
            break;
        }
        boolean isLast = iterable.one() == null;
        return new DefaultPage(currentPageElements, currentPageNumber, isLast);
    }

    @NonNull
    public <ElementT, IterableT extends AsyncPagingIterable<ElementT, IterableT>> CompletionStage<Page<ElementT>> getPage(@NonNull IterableT iterable, int targetPageNumber) {
        this.throwIfIllegalArguments(iterable, targetPageNumber);
        CompletableFuture<Page<ElementT>> pageFuture = new CompletableFuture<Page<ElementT>>();
        this.getPage(iterable, targetPageNumber, 1, 0, new ArrayList(), pageFuture);
        return pageFuture;
    }

    private void throwIfIllegalArguments(@NonNull Object iterable, int targetPageNumber) {
        Objects.requireNonNull(iterable);
        if (targetPageNumber < 1) {
            throw new IllegalArgumentException("Invalid targetPageNumber, expected >=1, got " + targetPageNumber);
        }
    }

    private <IterableT extends AsyncPagingIterable<ElementT, IterableT>, ElementT> void getPage(@NonNull IterableT iterable, int targetPageNumber, int currentPageNumber, int currentPageSize, @NonNull List<ElementT> currentPageElements, @NonNull CompletableFuture<Page<ElementT>> pageFuture) {
        Iterator<ElementT> currentFrame = iterable.currentPage().iterator();
        while (currentFrame.hasNext()) {
            ElementT element = currentFrame.next();
            if (++currentPageSize > this.pageSize) {
                ++currentPageNumber;
                currentPageSize = 1;
                currentPageElements.clear();
            }
            currentPageElements.add(element);
            if (currentPageNumber != targetPageNumber || currentPageSize != this.pageSize) continue;
            if (currentFrame.hasNext()) {
                pageFuture.complete(new DefaultPage<ElementT>(currentPageElements, currentPageNumber, false));
            } else if (!iterable.hasMorePages()) {
                pageFuture.complete(new DefaultPage<ElementT>(currentPageElements, currentPageNumber, true));
            } else {
                int finalCurrentPageNumber = currentPageNumber;
                iterable.fetchNextPage().whenComplete((nextIterable, throwable) -> {
                    if (throwable != null) {
                        pageFuture.completeExceptionally((Throwable)throwable);
                    } else {
                        boolean isLastPage = !nextIterable.currentPage().iterator().hasNext();
                        pageFuture.complete(new DefaultPage(currentPageElements, finalCurrentPageNumber, isLastPage));
                    }
                });
            }
            return;
        }
        if (iterable.hasMorePages()) {
            int finalCurrentPageNumber = currentPageNumber;
            int finalCurrentPageSize = currentPageSize;
            iterable.fetchNextPage().whenComplete((nextIterable, throwable) -> {
                if (throwable != null) {
                    pageFuture.completeExceptionally((Throwable)throwable);
                } else {
                    this.getPage(nextIterable, targetPageNumber, finalCurrentPageNumber, finalCurrentPageSize, currentPageElements, pageFuture);
                }
            });
        } else {
            pageFuture.complete(new DefaultPage<ElementT>(currentPageElements, currentPageNumber, true));
        }
    }

    private static class DefaultPage<ElementT>
    implements Page<ElementT> {
        private final List<ElementT> elements;
        private final int pageNumber;
        private final boolean isLast;

        DefaultPage(@NonNull List<ElementT> elements, int pageNumber, boolean isLast) {
            this.elements = ImmutableList.copyOf(elements);
            this.pageNumber = pageNumber;
            this.isLast = isLast;
        }

        @Override
        @NonNull
        public List<ElementT> getElements() {
            return this.elements;
        }

        @Override
        public int getPageNumber() {
            return this.pageNumber;
        }

        @Override
        public boolean isLast() {
            return this.isLast;
        }
    }

    public static interface Page<ElementT> {
        @NonNull
        public List<ElementT> getElements();

        public int getPageNumber();

        public boolean isLast();
    }
}

